/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.Asn1Value;
import com.objsys.asn1j.runtime.Asn1ValueParseException;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;

public class Asn1BitString
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 3);
    public transient int numbits;
    public transient byte[] value;
    private static final long serialVersionUID = -8111143948369307678L;

    public Asn1BitString() {
        this.numbits = 0;
        this.value = null;
    }

    public Asn1BitString(int n, byte[] byArray) {
        this.numbits = n;
        this.value = byArray;
    }

    /*
     * Unable to fully structure code
     */
    public Asn1BitString(boolean[] var1_1) {
        var6_2 = Asn1Type.a;
        super();
        this.a(var1_1.length);
        var4_3 = 0;
        var5_4 = 128;
        var2_5 = 0;
        var3_6 = 0;
        if (var6_2 == 0) ** GOTO lbl27
        block0: while (true) {
            v0 = var1_1[var2_5];
            if (var6_2 != 0) ** GOTO lbl18
            if (v0 != 0) {
                var3_6 |= var5_4;
            }
            v1 = var5_4;
            v2 = 1;
            do {
                block8: {
                    block7: {
                        v0 = var5_4 = v1 >> v2;
lbl18:
                        // 2 sources

                        if (var6_2 != 0) break block7;
                        if (v0 != 0) break block8;
                        this.value[var4_3++] = (byte)var3_6;
                        var5_4 = 128;
                        v0 = 0;
                    }
                    var3_6 = v0;
                }
                ++var2_5;
lbl27:
                // 2 sources

                if (var2_5 < var1_1.length) continue block0;
                v1 = var5_4;
                v2 = 128;
            } while (var6_2 != 0);
            break;
        }
        if (v1 != v2) {
            this.value[var4_3] = (byte)var3_6;
        }
    }

    public Asn1BitString(String string) throws Asn1ValueParseException {
        IntHolder intHolder = new IntHolder();
        this.value = Asn1Value.parseString(string, intHolder);
        this.numbits = intHolder.value;
    }

    /*
     * Unable to fully structure code
     */
    public Asn1BitString(BitSet var1_1) {
        var6_2 = Asn1Type.a;
        super();
        this.a(var1_1.length());
        var4_3 = 0;
        var5_4 = 128;
        var2_5 = 0;
        var3_6 = 0;
        if (var6_2 == 0) ** GOTO lbl27
        block0: while (true) {
            v0 = var1_1.get(var2_5);
            if (var6_2 != 0) ** GOTO lbl18
            if (v0 != 0) {
                var3_6 |= var5_4;
            }
            v1 = var5_4;
            v2 = 1;
            do {
                block8: {
                    block7: {
                        v0 = var5_4 = v1 >> v2;
lbl18:
                        // 2 sources

                        if (var6_2 != 0) break block7;
                        if (v0 != 0) break block8;
                        this.value[var4_3++] = (byte)var3_6;
                        var5_4 = 128;
                        v0 = 0;
                    }
                    var3_6 = v0;
                }
                ++var2_5;
lbl27:
                // 2 sources

                if (var2_5 < var1_1.length()) continue block0;
                v1 = var5_4;
                v2 = 128;
            } while (var6_2 != 0);
            break;
        }
        if (v1 != v2) {
            this.value[var4_3] = (byte)var3_6;
        }
    }

    public void clear(int n) {
        this.set(n, false);
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        int n2 = bl ? this.matchTag(asn1BerDecodeBuffer, TAG) : n;
        Asn1Tag asn1Tag = asn1BerDecodeBuffer.getLastTag();
        if (asn1Tag != null && asn1Tag.isConstructed()) {
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            byte by = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n2);
            while (!asn1BerDecodeContext.expired()) {
                int n6 = this.matchTag(asn1BerDecodeBuffer, TAG);
                if (n6 > 0) {
                    n3 += n6;
                    if (n4 == 0) {
                        this.a(n3 * 8);
                    } else {
                        this.b(n3 * 8);
                    }
                    n5 = n4;
                    asn1BerDecodeBuffer.read(this.value, n4, n6);
                    n4 = n3;
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (n5 >= 0) {
                by = this.value[n5];
                if (n4 - n5 - 1 > 0) {
                    System.arraycopy(this.value, n5 + 1, this.value, n5, n4 - n5 - 1);
                }
                --n3;
            }
            this.b(n3 * 8 - by);
            if (bl && n2 == -9999) {
                this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else {
            if (n2 < 0) {
                throw new Asn1InvalidLengthException();
            }
            if (n2 != 0) {
                int n7 = n2 - 1;
                int n8 = asn1BerDecodeBuffer.read();
                if (n8 < 0) {
                    throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
                }
                this.numbits = n7 * 8 - n8;
                this.value = new byte[n7];
                asn1BerDecodeBuffer.read(this.value);
            } else {
                this.numbits = 0;
                this.value = null;
            }
        }
        asn1BerDecodeBuffer.setTypeCode((short)3);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n = this.value.length + 1;
        int n2 = this.numbits % 8;
        if (n2 != 0) {
            n2 = 8 - n2;
        }
        asn1BerEncodeBuffer.copy(this.value);
        asn1BerEncodeBuffer.copy((byte)n2);
        if (bl) {
            n += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n);
        }
        return n;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            n2 += n;
            asn1PerDecodeBuffer.byteAlign();
            if (n3 == 0) {
                this.a(n2);
            } else {
                this.b(n2);
            }
            asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, n3, n);
            if (n < 16384) continue;
            n3 += n / 8;
        } while (n >= 16384);
        asn1PerDecodeBuffer.setTypeCode((short)3);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n, int n2) throws Asn1Exception, IOException {
        if (n2 < 65536) {
            this.numbits = (int)asn1PerDecodeBuffer.decodeLength(n, n2);
            if (this.numbits > 0) {
                if (n != n2 || n2 > 16) {
                    asn1PerDecodeBuffer.byteAlign();
                }
                this.a(this.numbits);
                asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, 0, this.numbits);
            }
        } else {
            this.decode(asn1PerDecodeBuffer);
        }
        asn1PerDecodeBuffer.setTypeCode((short)3);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        int n = this.numbits;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = (int)asn1PerEncodeBuffer.encodeLength(n)) > 0) {
                asn1PerEncodeBuffer.byteAlign();
                asn1PerEncodeBuffer.encodeBits(this.value, n2, n3);
            }
            if ((n -= n3) <= 0) break;
            n2 += n3 / 8;
        }
        asn1PerEncodeBuffer.encodeLengthEOM(this.numbits);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n, int n2) throws Asn1Exception, IOException {
        if (this.numbits >= n && this.numbits <= n2) {
            if (n2 < 65536) {
                asn1PerEncodeBuffer.encodeLength(this.numbits, n, n2);
                if (this.numbits > 0) {
                    if (n != n2 || n2 > 16) {
                        asn1PerEncodeBuffer.byteAlign();
                    }
                    asn1PerEncodeBuffer.encodeBits(this.value, 0, this.numbits);
                }
            } else {
                this.encode(asn1PerEncodeBuffer);
            }
        } else {
            throw new Asn1ConsVioException("Asn1BitString.length", this.numbits);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "BIT_STRING";
        }
        if (this.numbits == 0) {
            asn1XerEncoder.indent();
            asn1XerEncoder.encodeEmptyElement(string);
        } else {
            asn1XerEncoder.encodeStartElement(string);
            asn1XerEncoder.encodeBinStrValue(this.value, this.numbits);
            asn1XerEncoder.encodeEndElement(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decodeXER(String var1_1, String var2_2) throws Asn1Exception {
        var9_3 = Asn1Type.a;
        var1_1 = var1_1.trim();
        var5_4 = 128;
        var6_5 = 0;
        var7_6 = var1_1.length();
        var4_7 = 0;
        var3_8 = 0;
        if (var9_3 == 0) ** GOTO lbl14
        block0: while (true) {
            if (!Character.isSpaceChar(var1_1.charAt(var3_8))) {
                ++var4_7;
            }
            do {
                ++var3_8;
lbl14:
                // 2 sources

                if (var3_8 < var7_6) continue block0;
                this.value = new byte[(var4_7 + 7) / 8];
                var4_7 = 0;
                var3_8 = 0;
            } while (var9_3 != 0);
            break;
        }
        if (var9_3 == 0) ** GOTO lbl55
        do {
            block15: {
                block16: {
                    block14: {
                        var8_9 = var1_1.charAt(var3_8);
                        v0 = Character.isSpaceChar(var8_9);
                        if (var9_3 != 0) break block14;
                        if (v0 != 0) break block15;
                        v0 = var6_5 % 8;
                    }
                    if (var9_3 == 0) {
                        if (v0 == 0) {
                            this.value[var4_7] = 0;
                        }
                        v0 = var8_9;
                    }
                    v1 = 49;
                    if (var9_3 != 0) ** GOTO lbl39
                    if (v0 != v1) ** GOTO lbl-1000
                    v2 = var4_7;
                    this.value[v2] = (byte)(this.value[v2] | var5_4);
                    if (var9_3 != 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = var8_9;
                        v1 = 48;
lbl39:
                        // 2 sources

                        if (var9_3 == 0) {
                            if (v0 != v1) {
                                throw new Asn1Exception("Invalid format of bit string");
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        ++var6_5;
                        v0 = var5_4;
                        v1 = 1;
                    }
                    v3 = var5_4 = v0 >> v1;
                    if (var9_3 != 0) break block16;
                    if (v3 != 0) break block15;
                    v3 = 128;
                }
                var5_4 = v3;
                ++var4_7;
            }
            ++var3_8;
lbl55:
            // 2 sources

        } while (var3_8 < var7_6);
        this.numbits = var6_5;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(int var1_1, byte[] var2_2) {
        block4: {
            block5: {
                var5_3 = Asn1Type.a;
                v0 = var1_1;
                if (var5_3 != 0) break block4;
                if (v0 != this.numbits) break block5;
                var3_4 = (var1_1 - 1) / 8 + 1;
                var4_5 = 0;
                if (var5_3 == 0) ** GOTO lbl18
                block0: while (true) {
                    v1 = var2_2[var4_5];
                    do {
                        block7: {
                            block6: {
                                if (var5_3 != 0) break block6;
                                if (v1 == this.value[var4_5]) break block7;
                                v1 = 0;
                            }
                            return (boolean)v1;
                        }
                        ++var4_5;
lbl18:
                        // 2 sources

                        if (var4_5 < var3_4) continue block0;
                        v2 = true;
                    } while (var5_3 != 0);
                    break;
                }
                return v2;
            }
            v0 = 0;
        }
        return (boolean)v0;
    }

    public boolean equals(Asn1BitString asn1BitString) {
        return this.equals(asn1BitString.numbits, asn1BitString.value);
    }

    public int getLength() throws Asn1InvalidLengthException {
        return this.numbits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSet(int n) {
        int n2 = Asn1Type.a;
        int n3 = n / 8;
        int n4 = 1 << 7 - n % 8;
        byte[] byArray = this.value;
        if (n2 == 0) {
            if (byArray == null) return 0 != 0;
            byArray = this.value;
        }
        int n5 = byArray.length;
        if (n2 != 0) return n5 != 0;
        if (n5 < n3) return 0 != 0;
        byte by = this.value[n3];
        boolean bl = by & n4;
        if (n2 != 0) return bl;
        if (!bl) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] toBoolArray() {
        var9_1 = Asn1Type.a;
        var1_2 = new boolean[this.numbits];
        var5_3 = 0;
        var6_4 = 128;
        var7_5 = this.numbits;
        var3_6 = 0;
        if (var9_1 == 0) ** GOTO lbl30
        do {
            var4_8 = this.value[var3_6];
            var6_4 = 128;
            v0 = var7_5;
            if (var9_1 == 0) {
                v0 = v0 < 8 ? var7_5 : 8;
            }
            var2_7 = v0;
            var8_9 = 0;
            if (var9_1 == 0) ** GOTO lbl26
            block1: while (true) {
                v1 = var5_3++;
                v2 = var4_8 & var6_4;
                if (var9_1 == 0) {
                    v2 = v2 == 0 ? 0 : 1;
                }
                var1_2[v1] = v2;
                var6_4 >>= 1;
                do {
                    ++var8_9;
lbl26:
                    // 2 sources

                    if (var8_9 < var2_7) continue block1;
                    var7_5 -= 8;
                } while (var9_1 != 0);
                break;
            }
            ++var3_6;
lbl30:
            // 2 sources

        } while (var3_6 < this.value.length);
        return var1_2;
    }

    /*
     * Unable to fully structure code
     */
    public void set(int var1_1, boolean var2_2) {
        block14: {
            block13: {
                block12: {
                    block11: {
                        block9: {
                            block10: {
                                var7_3 = Asn1Type.a;
                                var3_4 = var1_1 / 8;
                                var4_5 = 1 << 7 - var1_1 % 8;
                                var5_6 = var3_4 + 1;
                                v0 = this.value;
                                if (var7_3 != 0) break block9;
                                if (v0 != null) break block10;
                                this.value = new byte[var5_6];
                                if (var7_3 == 0) break block11;
                            }
                            v0 = this.value;
                        }
                        v1 = v0.length;
                        if (var7_3 != 0) break block12;
                        if (v1 < var5_6) {
                            var6_7 = new byte[var5_6];
                            System.arraycopy(this.value, 0, var6_7, 0, this.value.length);
                            this.value = var6_7;
                        }
                    }
                    v1 = this.value[var3_4];
                }
                var6_8 = v1;
                v2 = var2_2;
                if (var7_3 != 0) ** GOTO lbl29
                if (v2 != 0) {
                    v3 = var6_8 | var4_5;
                } else {
                    v2 = var6_8;
lbl29:
                    // 2 sources

                    v3 = v2 & ~var4_5;
                }
                var6_8 = v3;
                v4 = this;
                if (var7_3 != 0) break block13;
                v4.value[var3_4] = (byte)var6_8;
                if (var1_1 + 1 <= this.numbits) break block14;
                v4 = this;
            }
            v4.numbits = var1_1 + 1;
        }
    }

    public void set(int n) {
        this.set(n, true);
    }

    /*
     * Unable to fully structure code
     */
    public String toHexString() {
        var3_1 = Asn1Type.a;
        var1_2 = new String("");
        var2_3 = 0;
        if (var3_1 == 0) ** GOTO lbl10
        block0: while (true) {
            v0 = var1_2 + Asn1Util.toHexString(this.value[var2_3]);
            do {
                var1_2 = v0;
                ++var2_3;
lbl10:
                // 2 sources

                if (var2_3 < this.value.length) continue block0;
                v0 = var1_2;
            } while (var3_1 != 0);
            break;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        var4_1 = Asn1Type.a;
        var1_2 = this.toBoolArray();
        var2_3 = new String("");
        var3_4 = 0;
        if (var4_1 == 0) ** GOTO lbl16
        block0: while (true) {
            v0 = new StringBuffer();
            v1 = var2_3;
            if (var4_1 == 0) {
                v0 = v0.append(v1);
                v1 = var1_2[var3_4] != false ? "1" : "0";
            }
            v2 = v0.append(v1).toString();
            do {
                var2_3 = v2;
                ++var3_4;
lbl16:
                // 2 sources

                if (var3_4 < var1_2.length) continue block0;
                v2 = var2_3;
            } while (var4_1 != 0);
            break;
        }
        return v2;
    }

    private void a(int n) {
        block4: {
            int n2;
            block2: {
                Asn1BitString asn1BitString;
                block3: {
                    int n3 = Asn1Type.a;
                    this.numbits = n;
                    n2 = (this.numbits + 7) / 8;
                    asn1BitString = this;
                    if (n3 != 0) break block2;
                    if (asn1BitString.value == null) break block3;
                    asn1BitString = this;
                    if (n3 != 0) break block2;
                    if (asn1BitString.value.length >= n2) break block4;
                }
                asn1BitString = this;
            }
            asn1BitString.value = new byte[n2];
        }
    }

    private void b(int n) {
        block6: {
            byte[] byArray;
            byte[] byArray2;
            int n2;
            block5: {
                int n3 = Asn1Type.a;
                this.numbits = n;
                n2 = (this.numbits + 7) / 8;
                byte[] byArray3 = this.value;
                if (n3 == 0) {
                    if (byArray3.length == n2) {
                        return;
                    }
                    byArray3 = this.value;
                }
                byArray2 = byArray3;
                this.value = new byte[n2];
                byArray = byArray2;
                if (n3 != 0) break block5;
                if (byArray == null) break block6;
                byArray = byArray2;
            }
            System.arraycopy(byArray, 0, this.value, 0, Math.min(byArray2.length, n2));
        }
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        asn1BerOutputStream.encodeLength(this.value.length + 1);
        int n = this.numbits % 8;
        if (n != 0) {
            n = 8 - n;
        }
        asn1BerOutputStream.write(n);
        asn1BerOutputStream.write(this.value);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.a);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, int n, int n2) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.a, n, n2);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeInt(this.numbits);
        objectOutputStream.write(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.numbits = objectInputStream.readInt();
        this.a(this.numbits);
        objectInputStream.read(this.value, 0, (this.numbits + 7) / 8);
    }
}

