/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1Boolean
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 1);
    public static final Asn1Boolean TRUE_VALUE = new Asn1Boolean(true);
    public static final Asn1Boolean FALSE_VALUE = new Asn1Boolean(false);
    public transient boolean value;
    private static final long serialVersionUID = 6822741769471077623L;

    public Asn1Boolean() {
        this.value = false;
    }

    public Asn1Boolean(boolean bl) {
        this.value = bl;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean n, int n2) throws Asn1Exception, IOException {
        int n3;
        int n4 = Asn1Type.a;
        int n5 = n;
        if (n4 == 0) {
            if (n5 != 0) {
                this.matchTag(asn1BerDecodeBuffer, TAG);
            }
            n5 = n3 = asn1BerDecodeBuffer.read();
        }
        if (n5 < 0) {
            throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
        }
        asn1BerDecodeBuffer.setTypeCode((short)1);
        int n6 = n3;
        if (n4 == 0) {
            n6 = n6 == 0 ? 0 : 1;
        }
        this.value = n6;
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n = Asn1Type.a;
        int n2 = 1;
        int n3 = this.value;
        if (n == 0) {
            n3 = n3 != 0 ? -1 : 0;
        }
        asn1BerEncodeBuffer.copy((byte)n3);
        int n4 = bl;
        if (n == 0) {
            if (n4 != 0) {
                n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
            }
            n4 = n2;
        }
        return n4;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.value = asn1PerDecodeBuffer.decodeBit();
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        asn1PerEncodeBuffer.encodeBit(this.value);
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        block3: {
            String string2;
            block2: {
                string2 = string;
                if (Asn1Type.a != 0) break block2;
                if (string2 != null) break block3;
                string2 = "BOOLEAN";
            }
            string = string2;
        }
        asn1XerEncoder.encodeNamedValue(this.value ? "true" : "false", string);
    }

    public void encode(Asn1XerEncodeBuffer asn1XerEncodeBuffer) throws Asn1Exception {
        asn1XerEncodeBuffer.encodeNamedValueElement(this.value ? "true" : "false");
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        block4: {
            block5: {
                int n;
                int n2;
                block2: {
                    block3: {
                        n2 = Asn1Type.a;
                        string = string.trim();
                        n = string.compareTo("true");
                        if (n2 != 0) break block2;
                        if (n != 0) break block3;
                        this.value = true;
                        if (n2 == 0) break block4;
                    }
                    n = string.compareTo("false");
                }
                if (n != 0) break block5;
                this.value = false;
                if (n2 == 0) break block4;
            }
            throw new Asn1Exception("Invalid BOOLEAN value");
        }
    }

    public boolean equals(boolean bl) {
        boolean bl2 = this.value;
        if (Asn1Type.a == 0) {
            bl2 = bl2 == bl;
        }
        return bl2;
    }

    public boolean equals(Asn1Boolean asn1Boolean) {
        boolean bl = this.value;
        if (Asn1Type.a == 0) {
            bl = bl == asn1Boolean.value;
        }
        return bl;
    }

    public String toString() {
        return this.value ? "TRUE" : "FALSE";
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        asn1BerOutputStream.encodeLength(1);
        int n = this.value;
        if (Asn1Type.a == 0) {
            n = n != 0 ? -1 : 0;
        }
        asn1BerOutputStream.write(n);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        asn1PerOutputStream.a.encodeBit(this.value);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeBoolean(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readBoolean();
    }
}

