/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1CharSet;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerMessageBuffer;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class Asn1CharString
extends Asn1Type {
    public transient String value;
    protected transient StringBuffer mStringBuffer;
    private transient short e;
    private static final long serialVersionUID = -3999513667217895517L;

    protected Asn1CharString(short s) {
        this.value = null;
        this.e = s;
    }

    protected Asn1CharString(String string, short s) {
        this.value = string;
        this.e = s;
    }

    protected void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        Asn1Tag asn1Tag2;
        int n2;
        int n3 = n2 = bl ? this.matchTag(asn1BerDecodeBuffer, asn1Tag) : n;
        int n4 = 0;
        if (this.mStringBuffer == null) {
            this.mStringBuffer = new StringBuffer();
        }
        if ((asn1Tag2 = asn1BerDecodeBuffer.getLastTag()) != null && asn1Tag2.isConstructed()) {
            int n5 = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n2);
            while (!asn1BerDecodeContext.expired()) {
                int n6 = this.matchTag(asn1BerDecodeBuffer, Asn1OctetString.TAG);
                if (n6 > 0) {
                    this.mStringBuffer.ensureCapacity(n5 += n6);
                    while (n6 > 0) {
                        int n7 = asn1BerDecodeBuffer.read();
                        if (n7 == -1) {
                            throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
                        }
                        this.mStringBuffer.append((char)n7);
                        --n6;
                    }
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (bl && n2 == -9999) {
                this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else {
            if (n3 < 0) {
                throw new Asn1InvalidLengthException();
            }
            this.mStringBuffer.setLength(n3);
            while (n3 > 0) {
                int n8 = asn1BerDecodeBuffer.read();
                if (n8 == -1) {
                    throw new Asn1EndOfBufferException(asn1BerDecodeBuffer);
                }
                this.mStringBuffer.setCharAt(n4++, (char)n8);
                --n3;
            }
        }
        this.value = this.mStringBuffer.toString();
        asn1BerDecodeBuffer.setTypeCode((short)asn1Tag.mIDCode);
    }

    protected int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception {
        int n = this.value.length();
        asn1BerEncodeBuffer.copy(this.value);
        if (bl) {
            n += asn1BerEncodeBuffer.encodeTagAndLength(asn1Tag, n);
        }
        return n;
    }

    protected void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n, int n2, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        int n3;
        int n4 = 0;
        if (this.mStringBuffer == null) {
            this.mStringBuffer = new StringBuffer();
        } else {
            this.mStringBuffer.setLength(0);
        }
        do {
            if ((n3 = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            asn1PerDecodeBuffer.byteAlign();
            this.mStringBuffer.ensureCapacity(n4 += n3);
            asn1PerDecodeBuffer.decodeCharString(n3, n, n2, asn1CharSet, this.mStringBuffer);
        } while (n3 >= 16384);
        this.value = this.mStringBuffer.toString();
        asn1PerDecodeBuffer.setTypeCode(this.e);
    }

    protected void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n, int n2, Asn1CharSet asn1CharSet, int n3, int n4) throws Asn1Exception, IOException {
        if (n4 < 65536) {
            int n5 = (int)asn1PerDecodeBuffer.decodeLength(n3, n4);
            if (this.mStringBuffer == null) {
                this.mStringBuffer = new StringBuffer();
            } else {
                this.mStringBuffer.setLength(0);
            }
            if (n5 > 0) {
                int n6 = asn1CharSet == null ? (asn1PerDecodeBuffer.isAligned() ? n : n2) : asn1CharSet.getNumBitsPerChar(asn1PerDecodeBuffer.isAligned());
                Asn1CharString.a(asn1PerDecodeBuffer, n6, n3, n4);
                this.mStringBuffer.ensureCapacity(n5);
                asn1PerDecodeBuffer.decodeCharString(n5, n, n2, asn1CharSet, this.mStringBuffer);
            }
            this.value = this.mStringBuffer.toString();
            asn1PerDecodeBuffer.setTypeCode(this.e);
        } else {
            this.decode(asn1PerDecodeBuffer, n, n2, asn1CharSet);
        }
    }

    protected void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n, int n2, Asn1CharSet asn1CharSet) throws Asn1Exception, IOException {
        int n3 = this.value.length();
        int n4 = 0;
        while (true) {
            int n5;
            if ((n5 = (int)asn1PerEncodeBuffer.encodeLength(n3)) > 0) {
                asn1PerEncodeBuffer.byteAlign();
                asn1PerEncodeBuffer.encodeCharString(this.value, n5, n4, n, n2, asn1CharSet);
            }
            if ((n3 -= n5) <= 0) break;
            n4 += n5;
        }
        asn1PerEncodeBuffer.encodeLengthEOM(n3);
    }

    protected void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n, int n2, Asn1CharSet asn1CharSet, int n3, int n4) throws Asn1Exception, IOException {
        int n5 = this.value.length();
        if (n5 >= n3 && n5 <= n4) {
            if (n4 < 65536) {
                asn1PerEncodeBuffer.encodeLength(n5, n3, n4);
                if (n5 > 0) {
                    int n6 = asn1CharSet == null ? (asn1PerEncodeBuffer.isAligned() ? n : n2) : asn1CharSet.getNumBitsPerChar(asn1PerEncodeBuffer.isAligned());
                    Asn1CharString.a(asn1PerEncodeBuffer, n6, n3, n4);
                    asn1PerEncodeBuffer.encodeCharString(this.value, n5, 0, n, n2, asn1CharSet);
                }
            } else {
                this.encode(asn1PerEncodeBuffer, n, n2, asn1CharSet);
            }
        } else {
            throw new Asn1ConsVioException("Asn1CharString.length", n5);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.encodeData(this.value);
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        this.value = string;
    }

    public boolean equals(String string) {
        return this.value.equals(string);
    }

    public boolean equals(Asn1CharString asn1CharString) {
        return this.equals(asn1CharString.value);
    }

    public int getLength() throws Asn1InvalidLengthException {
        return this.value.length();
    }

    public String toString() {
        return this.value;
    }

    private static void a(Asn1PerMessageBuffer asn1PerMessageBuffer, int n, int n2, int n3) {
        block6: {
            int n4;
            block9: {
                int n5;
                block10: {
                    int n6;
                    block7: {
                        long l2;
                        long l3;
                        block8: {
                            int n7;
                            block5: {
                                n6 = Asn1Type.a;
                                n7 = asn1PerMessageBuffer.isAligned();
                                if (n6 != 0) break block5;
                                if (n7 == 0) break block6;
                                n7 = n3 * n;
                            }
                            l3 = n7;
                            n5 = 1;
                            n4 = n3;
                            if (n6 != 0) break block7;
                            if (n4 != n2) break block8;
                            long l4 = l3 - 16L;
                            n4 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                            if (n6 != 0) break block9;
                            if (n4 > 0) break block10;
                            n5 = 0;
                            if (n6 == 0) break block10;
                        }
                        n4 = (l2 = l3 - 16L) == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    }
                    if (n6 != 0) break block9;
                    if (n4 < 0) {
                        n5 = 0;
                    }
                }
                n4 = n5;
            }
            if (n4 != 0) {
                asn1PerMessageBuffer.byteAlign();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeUTF(this.value);
        objectOutputStream.writeShort(this.e);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readUTF();
        this.e = objectInputStream.readShort();
    }
}

