/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1MessageBuffer;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class Asn1EncodeBuffer
extends Asn1MessageBuffer {
    protected int mByteIndex;
    protected byte[] mData;
    protected int mSizeIncrement;
    public static final int SIZE_INCREMENT = 1024;

    Asn1EncodeBuffer() {
        this.initBuffer(1024);
    }

    Asn1EncodeBuffer(int n) {
        if (Asn1Type.a == 0) {
            if (n == 0) {
                n = 1024;
            }
            this.initBuffer(n);
        }
    }

    public void binDump(String string) {
        this.binDump(System.out, string);
    }

    public abstract void binDump(PrintStream var1, String var2);

    protected void checkSize(int n) {
        block3: {
            int n2;
            int n3;
            block2: {
                n3 = this.mByteIndex + n;
                n2 = this.mData.length;
                if (Asn1Type.a != 0) break block2;
                if (n3 <= n2) break block3;
                n3 = (n - 1) / this.mSizeIncrement;
                n2 = 1;
            }
            int n4 = n3 + n2;
            int n5 = n4 * this.mSizeIncrement;
            byte[] byArray = new byte[this.mData.length + n5];
            System.arraycopy(this.mData, 0, byArray, 0, this.mByteIndex + 1);
            this.mData = byArray;
        }
    }

    public abstract void copy(byte var1);

    public abstract void copy(byte[] var1) throws Asn1Exception;

    public abstract byte[] getMsgCopy();

    public abstract int getMsgLength();

    public void hexDump() {
        Asn1MessageBuffer.hexDump(this.getInputStream());
    }

    public void hexDump(PrintStream printStream) {
        Asn1MessageBuffer.hexDump(this.getInputStream(), printStream);
    }

    protected void initBuffer(int n) {
        this.mSizeIncrement = n;
        this.mData = new byte[this.mSizeIncrement];
        this.mByteIndex = 0;
    }

    public abstract void reset();

    public abstract void write(OutputStream var1) throws IOException;
}

