/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.Asn1Value;
import com.objsys.asn1j.runtime.Asn1ValueParseException;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.c;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1OctetString
extends Asn1Type
implements Comparable {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 4);
    public transient byte[] value;
    private static final long serialVersionUID = -1633161801793532563L;

    public Asn1OctetString() {
        this.value = null;
    }

    public Asn1OctetString(byte[] byArray) {
        this.value = byArray;
    }

    public Asn1OctetString(byte[] byArray, int n, int n2) {
        block3: {
            byte[] byArray2;
            block2: {
                this.value = new byte[n2];
                byArray2 = byArray;
                if (Asn1Type.a != 0) break block2;
                if (byArray2 == null) break block3;
                byArray2 = byArray;
            }
            System.arraycopy(byArray2, n, this.value, 0, n2);
        }
    }

    public Asn1OctetString(String string) throws Asn1ValueParseException {
        block4: {
            block3: {
                int n;
                block2: {
                    n = Asn1Type.a;
                    if (n != 0) break block2;
                    if (string != null && string.length() != 0) break block3;
                    this.value = new byte[0];
                }
                if (n == 0) break block4;
            }
            this.value = Asn1Value.parseString(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int compareTo(Object var1_1) {
        block17: {
            block16: {
                var7_2 = Asn1Type.a;
                var2_3 = ((Asn1OctetString)var1_1).value;
                v0 = this.value;
                if (var7_2 != 0) ** GOTO lbl9
                if (v0.length < var2_3.length) {
                    v1 = this.value.length;
                } else {
                    v0 = var2_3;
lbl9:
                    // 2 sources

                    v1 = v0.length;
                }
                var3_4 = v1;
                var6_5 = 0;
                if (var7_2 == 0) ** GOTO lbl34
                block0: while (true) {
                    v2 = this.value[var6_5];
                    v3 = 255;
                    do {
                        block15: {
                            block14: {
                                block13: {
                                    var4_6 = v2 & v3;
                                    var5_7 = var2_3[var6_5] & 255;
                                    v4 = var4_6;
                                    v5 = var5_7;
                                    if (var7_2 != 0) break block13;
                                    if (v4 < v5) {
                                        return -1;
                                    }
                                    v4 = var4_6;
                                    if (var7_2 != 0) break block14;
                                    v5 = var5_7;
                                }
                                if (v4 <= v5) break block15;
                                v4 = 1;
                            }
                            return v4;
                        }
                        ++var6_5;
lbl34:
                        // 2 sources

                        if (var6_5 < var3_4) continue block0;
                        v2 = this.value.length;
                        v3 = var2_3.length;
                    } while (var7_2 != 0);
                    break;
                }
                if (var7_2 != 0) break block16;
                if (v2 == v3) {
                    return 0;
                }
                v6 = this.value.length;
                if (var7_2 != 0) break block17;
                v7 = var2_3.length;
            }
            if (v6 < v7) {
                return -1;
            }
            v6 = 1;
        }
        return v6;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        int n2 = bl ? this.matchTag(asn1BerDecodeBuffer, TAG) : n;
        Asn1Tag asn1Tag = asn1BerDecodeBuffer.getLastTag();
        if (asn1Tag != null && asn1Tag.isConstructed()) {
            int n3 = 0;
            int n4 = 0;
            Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n2);
            while (!asn1BerDecodeContext.expired()) {
                int n5 = this.matchTag(asn1BerDecodeBuffer, TAG);
                if (n5 > 0) {
                    n3 += n5;
                    if (n4 == 0) {
                        this.value = new byte[n3];
                    } else {
                        this.b(n3);
                    }
                    asn1BerDecodeBuffer.read(this.value, n4, n5);
                    n4 = n3;
                    continue;
                }
                throw new Asn1Exception(asn1BerDecodeBuffer, "Invalid format of constructed value");
            }
            if (bl && n2 == -9999) {
                this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else if (n2 >= 0) {
            this.value = new byte[n2];
            if (n2 != 0) {
                asn1BerDecodeBuffer.read(this.value);
            }
        } else {
            throw new Asn1InvalidLengthException();
        }
        asn1BerDecodeBuffer.setTypeCode((short)4);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n;
        if (this.value == null) {
            this.value = new byte[0];
        }
        if ((n = this.value.length) != 0) {
            asn1BerEncodeBuffer.copy(this.value);
        }
        if (bl) {
            n += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n);
        }
        return n;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            n2 += n;
            asn1PerDecodeBuffer.byteAlign();
            if (n3 == 0) {
                this.a(n2);
            } else {
                this.b(n2);
            }
            asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, n3, n * 8);
            if (n < 16384) continue;
            n3 = n2;
        } while (n >= 16384);
        if (this.value == null) {
            this.value = new byte[0];
        }
        asn1PerDecodeBuffer.setTypeCode((short)4);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n, int n2) throws Asn1Exception, IOException {
        if (n2 < 65536) {
            int n3 = (int)asn1PerDecodeBuffer.decodeLength(n, n2);
            if (n3 > 0) {
                if (n != n2 || n2 > 2) {
                    asn1PerDecodeBuffer.byteAlign();
                }
                this.a(n3);
                asn1PerDecodeBuffer.decodeBitsToOctetArray(this.value, 0, n3 * 8);
            } else {
                this.value = new byte[0];
            }
        } else {
            this.decode(asn1PerDecodeBuffer);
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        if (this.value == null) {
            this.value = new byte[0];
        }
        asn1PerEncodeBuffer.encodeOctetString(this.value, 0, this.value.length);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n, int n2) throws Asn1Exception, IOException {
        if (this.value == null) {
            this.value = new byte[0];
        }
        if (this.value.length >= n && this.value.length <= n2) {
            if (n2 < 65536) {
                asn1PerEncodeBuffer.encodeLength(this.value.length, n, n2);
                if (this.value.length > 0) {
                    if (n != n2 || n2 > 2) {
                        asn1PerEncodeBuffer.byteAlign();
                    }
                    asn1PerEncodeBuffer.encodeBits(this.value, 0, this.value.length * 8);
                }
            } else {
                this.encode(asn1PerEncodeBuffer);
            }
        } else {
            throw new Asn1ConsVioException("Asn1OctetString.length", this.value.length);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "OCTET_STRING";
        }
        if (this.value.length == 0) {
            asn1XerEncoder.indent();
            asn1XerEncoder.encodeEmptyElement(string);
        } else {
            asn1XerEncoder.encodeStartElement(string);
            asn1XerEncoder.encodeHexStrValue(this.value);
            asn1XerEncoder.encodeEndElement(string);
        }
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        string = string.trim();
        this.value = c.a(string);
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(byte[] var1_1) {
        block4: {
            block5: {
                var3_2 = Asn1Type.a;
                v0 = var1_1.length;
                if (var3_2 != 0) break block4;
                if (v0 != this.value.length) break block5;
                var2_3 = 0;
                if (var3_2 == 0) ** GOTO lbl17
                block0: while (true) {
                    v1 = var1_1[var2_3];
                    do {
                        block7: {
                            block6: {
                                if (var3_2 != 0) break block6;
                                if (v1 == this.value[var2_3]) break block7;
                                v1 = 0;
                            }
                            return (boolean)v1;
                        }
                        ++var2_3;
lbl17:
                        // 2 sources

                        if (var2_3 < var1_1.length) continue block0;
                        v2 = true;
                    } while (var3_2 != 0);
                    break;
                }
                return v2;
            }
            v0 = 0;
        }
        return (boolean)v0;
    }

    public boolean equals(Asn1OctetString asn1OctetString) {
        return this.equals(asn1OctetString.value);
    }

    public int getLength() throws Asn1InvalidLengthException {
        return this.value.length;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.value, 0, this.value.length);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string = new String("");
        if (this.value != null) {
            int n = 0;
            boolean bl = true;
            do {
                if (bl && !(bl = false) && Asn1Type.a == 0) continue;
                string = string + Asn1Util.toHexString(this.value[n]);
                ++n;
            } while (n < this.value.length);
        }
        return string;
    }

    private void a(int n) {
        block3: {
            block2: {
                Asn1OctetString asn1OctetString = this;
                if (Asn1Type.a != 0) break block2;
                if (asn1OctetString.value != null) break block3;
                asn1OctetString = this;
            }
            asn1OctetString.value = new byte[n];
        }
    }

    private void b(int n) {
        block3: {
            byte[] byArray;
            byte[] byArray2;
            block2: {
                byArray2 = this.value;
                this.value = new byte[n];
                byArray = byArray2;
                if (Asn1Type.a != 0) break block2;
                if (byArray == null) break block3;
                byArray = byArray2;
            }
            System.arraycopy(byArray, 0, this.value, 0, byArray2.length);
        }
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        if (this.value == null) {
            this.value = new byte[0];
        }
        asn1BerOutputStream.encodeLength(this.value.length);
        asn1BerOutputStream.write(this.value);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        if (this.value == null) {
            this.value = new byte[0];
        }
        asn1PerOutputStream.a.encodeOctetString(this.value, 0, this.value.length);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, int n, int n2) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.a, n, n2);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = (byte[])objectInputStream.readObject();
    }
}

