/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;

public class Asn1OpenType
extends Asn1OctetString {
    protected transient int mLength;
    protected transient Asn1EncodeBuffer mEncodeBuffer;
    protected transient boolean mTextEncoding;
    private static final String e = "ENCODED DATA";
    private static final long serialVersionUID = 1794928988706612635L;

    public Asn1OpenType() {
        this.mLength = 0;
        this.mTextEncoding = false;
    }

    public Asn1OpenType(byte[] byArray) {
        super(byArray);
        this.mLength = 0;
        this.mTextEncoding = false;
    }

    public Asn1OpenType(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.mLength = 0;
        this.mTextEncoding = false;
    }

    public Asn1OpenType(Asn1EncodeBuffer asn1EncodeBuffer) {
        block4: {
            block3: {
                int n;
                block2: {
                    n = Asn1Type.a;
                    if (n != 0) break block2;
                    if (!(asn1EncodeBuffer instanceof Asn1BerEncodeBuffer)) break block3;
                    this.mLength = asn1EncodeBuffer.getMsgLength();
                    this.mEncodeBuffer = asn1EncodeBuffer;
                }
                if (n == 0) break block4;
            }
            this.value = asn1EncodeBuffer.getMsgCopy();
        }
        this.mTextEncoding = false;
    }

    public Asn1OpenType(int n) {
        this.mLength = n;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        this.value = asn1BerDecodeBuffer.decodeOpenType();
        asn1BerDecodeBuffer.setTypeCode((short)99);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n;
        Asn1OpenType asn1OpenType = this;
        if (Asn1Type.a == 0) {
            if (asn1OpenType.value != null) {
                n = super.encode(asn1BerEncodeBuffer, false);
                return n;
            }
            asn1OpenType = this;
        }
        n = asn1OpenType.mLength;
        return n;
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        asn1PerEncodeBuffer.encodeOpenType(this.value, 0, this.value.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        int n = Asn1Type.a;
        Asn1OpenType asn1OpenType = this;
        if (n == 0) {
            if (asn1OpenType.value != null) {
                try {
                    String string;
                    Asn1OpenType asn1OpenType2 = this;
                    if (n == 0) {
                        if (asn1OpenType2.mTextEncoding) {
                            string = new String(this.value, "UTF-8");
                            return string;
                        }
                        asn1OpenType2 = this;
                    }
                    string = super.toString();
                    return string;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            asn1OpenType = this;
        }
        Asn1EncodeBuffer asn1EncodeBuffer = asn1OpenType.mEncodeBuffer;
        if (n != 0) return asn1EncodeBuffer.toString();
        if (asn1EncodeBuffer == null) return e;
        asn1EncodeBuffer = this.mEncodeBuffer;
        return asn1EncodeBuffer.toString();
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (this.value != null) {
            asn1BerOutputStream.write(this.value);
        }
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        asn1PerOutputStream.encodeOpenType(this.value, 0, this.value.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeInt(this.mLength);
        objectOutputStream.writeBoolean(this.mTextEncoding);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.mLength = objectInputStream.readInt();
        this.mTextEncoding = objectInputStream.readBoolean();
        this.mEncodeBuffer = null;
    }
}

