/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn18BitCharString;
import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.IntHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public abstract class Asn1Time
extends Asn18BitCharString
implements Comparable {
    protected transient int year;
    protected transient int month;
    protected transient int day;
    protected transient int hour;
    protected transient int minute;
    protected transient int second;
    protected transient int secFraction;
    protected transient int diffHour;
    protected transient int diffMin;
    protected transient boolean utcFlag;
    protected transient boolean parsed;
    protected transient boolean derRules;
    public static final int January = 1;
    public static final int Jan = 1;
    public static final int February = 2;
    public static final int Feb = 2;
    public static final int March = 3;
    public static final int Mar = 3;
    public static final int April = 4;
    public static final int Apr = 4;
    public static final int May = 5;
    public static final int June = 6;
    public static final int Jun = 6;
    public static final int July = 7;
    public static final int Jul = 7;
    public static final int August = 8;
    public static final int Aug = 8;
    public static final int September = 9;
    public static final int Sep = 9;
    public static final int October = 10;
    public static final int Oct = 10;
    public static final int November = 11;
    public static final int Nov = 11;
    public static final int December = 12;
    public static final int Dec = 12;
    static short[] f = new short[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long serialVersionUID = 6260627786112948830L;

    public Asn1Time(short s, boolean bl) {
        super(s);
        this.derRules = bl;
        this.init();
    }

    public Asn1Time(String string, short s, boolean bl) {
        super(string, s);
        this.derRules = bl;
        this.init();
    }

    protected void init() {
        this.hour = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.second = 0;
        this.minute = 0;
        this.secFraction = 0;
        this.diffMin = 0;
        this.diffHour = 0;
        boolean bl = this.derRules;
        if (Asn1Type.a == 0) {
            bl = bl;
        }
        this.utcFlag = bl;
    }

    public int getYear() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.year;
        }
        return n;
    }

    public int getMonth() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.month;
        }
        return n;
    }

    public int getDay() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.day;
        }
        return n;
    }

    public int getHour() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.hour;
        }
        return n;
    }

    public int getMinute() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.minute;
        }
        return n;
    }

    public int getSecond() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.second;
        }
        return n;
    }

    public int getFraction() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.secFraction;
        }
        return n;
    }

    public int getDiffHour() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.diffHour;
        }
        return n;
    }

    public int getDiffMinute() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.diffMin;
        }
        return n;
    }

    public int getDiff() throws Asn1Exception {
        int n = this.parsed;
        if (Asn1Type.a == 0) {
            if (n == 0) {
                this.parseString(this.value);
            }
            n = this.diffHour * 60 + this.diffMin;
        }
        return n;
    }

    public boolean getUTC() throws Asn1Exception {
        boolean bl = this.parsed;
        if (Asn1Type.a == 0) {
            if (!bl) {
                this.parseString(this.value);
            }
            bl = this.utcFlag;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public Calendar getTime() {
        var1_1 = Calendar.getInstance();
        v0 = this.utcFlag;
        if (Asn1Type.a != 0) ** GOTO lbl8
        if (v0 != 0) {
            v1 = 0;
        } else {
            v0 = this.diffHour * 3600 * 1000;
lbl8:
            // 2 sources

            v1 = v0 + this.diffMin * 60 * 1000;
        }
        var2_2 = v1;
        var1_1.setTimeZone(new SimpleTimeZone(var2_2, ""));
        var1_1.setLenient(false);
        var1_1.set(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
        var1_1.set(14, this.secFraction * 100);
        var1_1.set(15, var2_2);
        return var1_1;
    }

    public void setDER(boolean bl) {
        this.derRules = bl;
    }

    public void setUTC(boolean bl) throws Asn1Exception {
        boolean bl2 = this.derRules;
        if (Asn1Type.a == 0) {
            if (bl2) {
                return;
            }
            this.safeParseString();
            this.utcFlag = bl;
            bl2 = this.compileString();
        }
    }

    public void setYear(int n) throws Asn1Exception {
        int n2 = Asn1Type.a;
        int n3 = n;
        if (n2 == 0) {
            if (n3 < 0) {
                throw new Asn1Exception("Invalid year value: " + n);
            }
            n3 = this.a(this.day, this.month, n) ? 1 : 0;
        }
        if (n2 == 0) {
            if (n3 == 0) {
                throw new Asn1Exception("Invalid year value: " + n + " for day (" + this.day + ") and month (" + this.month + ")");
            }
            this.safeParseString();
            this.year = n;
            n3 = this.compileString() ? 1 : 0;
        }
    }

    public void setMonth(int n) throws Asn1Exception {
        int n2;
        int n3;
        block7: {
            block8: {
                block6: {
                    int n4;
                    block5: {
                        n3 = Asn1Type.a;
                        n2 = n;
                        n4 = 1;
                        if (n3 != 0) break block5;
                        if (n2 < n4) break block6;
                        n2 = n;
                        if (n3 != 0) break block7;
                        n4 = 12;
                    }
                    if (n2 <= n4) break block8;
                }
                throw new Asn1Exception("Invalid month value: " + n);
            }
            n2 = this.a(this.day, n, this.year) ? 1 : 0;
        }
        if (n3 == 0) {
            if (n2 == 0) {
                throw new Asn1Exception("Invalid month value: " + n + " for day (" + this.day + ") and year (" + this.year + ")");
            }
            this.safeParseString();
            this.month = n;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(int n, int n2, int n3) {
        int n4;
        int n5;
        block7: {
            block8: {
                int n6;
                int n7;
                block9: {
                    block11: {
                        block10: {
                            block13: {
                                block12: {
                                    n5 = Asn1Type.a;
                                    boolean bl = n;
                                    if (n5 != 0) return bl;
                                    if (bl <= false) return true;
                                    n4 = n2;
                                    if (n5 == 0) {
                                        if (n4 <= 0) {
                                            return true;
                                        }
                                        n4 = n3;
                                    }
                                    if (n5 != 0) break block7;
                                    if (n4 < 0) break block8;
                                    n4 = n2;
                                    if (n5 != 0) break block7;
                                    if (n4 <= 0) break block8;
                                    n7 = f[n2];
                                    int n6 = n2;
                                    n6 = 2;
                                    if (n5 != 0) break block9;
                                    if (n4 != n6) break block10;
                                    n4 = n3 % 4;
                                    if (n5 != 0) break block11;
                                    if (n4 != 0) break block10;
                                    n4 = n3 % 100;
                                    if (n5 != 0) break block12;
                                    if (n4 != 0) break block13;
                                    n4 = n3 % 400;
                                }
                                if (n5 != 0) break block11;
                                if (n4 != 0) break block10;
                            }
                            ++n7;
                        }
                        n4 = n;
                    }
                    if (n5 != 0) return n4 != 0;
                    n6 = 1;
                }
                if (n4 < n6) return 0 != 0;
                n4 = n;
                if (n5 != 0) return n4 != 0;
                if (n4 > n7) return 0 != 0;
                return true;
            }
            n4 = n2;
        }
        if (n5 != 0) return n4 != 0;
        if (n4 <= 0) return 0 != 0;
        int n8 = n;
        n8 = f[n2];
        if (n5 == 0) {
            if (n4 <= n8) {
                return true;
            }
            n4 = n2;
            if (n5 != 0) return n4 != 0;
            n8 = 2;
        }
        if (n4 != n8) return 0 != 0;
        n4 = n;
        if (n5 != 0) return n4 != 0;
        if (n4 > f[n2] + 1) return 0 != 0;
        return true;
    }

    public void setDay(int n) throws Asn1Exception {
        block5: {
            int n2;
            block6: {
                block3: {
                    int n3;
                    block4: {
                        int n4;
                        block2: {
                            n3 = Asn1Type.a;
                            n2 = n;
                            n4 = 1;
                            if (n3 != 0) break block2;
                            if (n2 < n4) break block3;
                            n2 = n;
                            if (n3 != 0) break block4;
                            n4 = 31;
                        }
                        if (n2 > n4) break block3;
                        n2 = this.a(n, this.month, this.year) ? 1 : 0;
                    }
                    if (n3 != 0) break block5;
                    if (n2 != 0) break block6;
                }
                throw new Asn1Exception("Invalid day value: " + n + " for month (" + this.month + ") and year (" + this.year + ")");
            }
            this.safeParseString();
            this.day = n;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    public void setHour(int n) throws Asn1Exception {
        block4: {
            int n2;
            block5: {
                block3: {
                    int n3;
                    block2: {
                        n3 = Asn1Type.a;
                        n2 = n;
                        if (n3 != 0) break block2;
                        if (n2 < 0) break block3;
                        n2 = n;
                    }
                    if (n3 != 0) break block4;
                    if (n2 <= 23) break block5;
                }
                throw new Asn1Exception("Invalid hour value: " + n);
            }
            this.safeParseString();
            this.hour = n;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    public void setMinute(int n) throws Asn1Exception {
        block4: {
            int n2;
            block5: {
                block3: {
                    int n3;
                    block2: {
                        n3 = Asn1Type.a;
                        n2 = n;
                        if (n3 != 0) break block2;
                        if (n2 < 0) break block3;
                        n2 = n;
                    }
                    if (n3 != 0) break block4;
                    if (n2 <= 59) break block5;
                }
                throw new Asn1Exception("Invalid minute value: " + n);
            }
            this.safeParseString();
            this.minute = n;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    public void setSecond(int n) throws Asn1Exception {
        block4: {
            int n2;
            block5: {
                block3: {
                    int n3;
                    block2: {
                        n3 = Asn1Type.a;
                        n2 = n;
                        if (n3 != 0) break block2;
                        if (n2 < 0) break block3;
                        n2 = n;
                    }
                    if (n3 != 0) break block4;
                    if (n2 <= 59) break block5;
                }
                throw new Asn1Exception("Invalid second value: " + n);
            }
            this.safeParseString();
            this.second = n;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    public void setFraction(int n) throws Asn1Exception {
        block4: {
            int n2;
            block5: {
                block3: {
                    int n3;
                    block2: {
                        n3 = Asn1Type.a;
                        n2 = n;
                        if (n3 != 0) break block2;
                        if (n2 < 0) break block3;
                        n2 = n;
                    }
                    if (n3 != 0) break block4;
                    if (n2 <= 9) break block5;
                }
                throw new Asn1Exception("Invalid fraction value: " + n);
            }
            this.safeParseString();
            this.secFraction = n;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    public void setTime(Calendar calendar) throws Asn1Exception {
        int n;
        block42: {
            block41: {
                int n2;
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                block32: {
                                                    block31: {
                                                        block30: {
                                                            block29: {
                                                                block28: {
                                                                    block27: {
                                                                        block26: {
                                                                            block25: {
                                                                                n = Asn1Type.a;
                                                                                this.clear();
                                                                                if (n != 0) break block25;
                                                                                if (!calendar.isSet(1)) break block26;
                                                                                this.year = calendar.get(1);
                                                                            }
                                                                            if (n == 0) break block27;
                                                                        }
                                                                        throw new Asn1Exception("Invalid Calendar value: no year");
                                                                    }
                                                                    if (!calendar.isSet(2)) break block28;
                                                                    this.month = calendar.get(2) + 1;
                                                                    if (n == 0) break block29;
                                                                }
                                                                throw new Asn1Exception("Invalid Calendar value: no month");
                                                            }
                                                            if (!calendar.isSet(5)) break block30;
                                                            this.day = calendar.get(5);
                                                            if (n == 0) break block31;
                                                        }
                                                        throw new Asn1Exception("Invalid Calendar value: no day");
                                                    }
                                                    if (!calendar.isSet(11)) break block32;
                                                    this.hour = calendar.get(11);
                                                    if (n == 0) break block33;
                                                }
                                                throw new Asn1Exception("Invalid Calendar value: no hours");
                                            }
                                            if (!calendar.isSet(12)) break block34;
                                            this.minute = calendar.get(12);
                                            if (n == 0) break block35;
                                        }
                                        this.minute = 0;
                                    }
                                    if (!calendar.isSet(13)) break block36;
                                    this.second = calendar.get(13);
                                    if (n == 0) break block37;
                                }
                                this.second = 0;
                            }
                            if (!calendar.isSet(14)) break block38;
                            this.secFraction = calendar.get(14) / 100;
                            if (n == 0) break block39;
                        }
                        this.secFraction = 0;
                    }
                    n2 = calendar.isSet(15);
                    if (n != 0) break block40;
                    if (n2 == 0) break block41;
                    n2 = calendar.get(15);
                }
                int n3 = n2;
                this.diffHour = n3 / 3600000;
                this.diffMin = n3 % 3600000 / 60000;
                if (n == 0) break block42;
            }
            this.diffMin = 0;
            this.diffHour = 0;
        }
        boolean bl = this.derRules;
        if (n == 0) {
            bl = bl;
        }
        this.utcFlag = bl;
        this.compileString();
    }

    public void setDiffHour(int n) throws Asn1Exception {
        block4: {
            int n2;
            block5: {
                block3: {
                    int n3;
                    block2: {
                        int n4 = Asn1Type.a;
                        n2 = n;
                        n3 = -12;
                        if (n4 != 0) break block2;
                        if (n2 < n3) break block3;
                        n2 = n;
                        if (n4 != 0) break block4;
                        n3 = 12;
                    }
                    if (n2 <= n3) break block5;
                }
                throw new Asn1Exception("Invalid diffhour value: " + n);
            }
            this.safeParseString();
            this.diffHour = n;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    public void setDiff(int n, int n2) throws Asn1Exception {
        block14: {
            int n3;
            block12: {
                Asn1Time asn1Time;
                block13: {
                    int n4;
                    int n5;
                    block11: {
                        int n6;
                        block9: {
                            block10: {
                                block8: {
                                    block7: {
                                        n5 = Asn1Type.a;
                                        n4 = n;
                                        n6 = -12;
                                        if (n5 != 0) break block7;
                                        if (n4 < n6) break block8;
                                        n4 = n;
                                        n6 = 12;
                                    }
                                    if (n5 != 0) break block9;
                                    if (n4 <= n6) break block10;
                                }
                                throw new Asn1Exception("Invalid diffhour value: " + n);
                            }
                            n4 = Math.abs(n2);
                            if (n5 != 0) break block11;
                            n6 = 59;
                        }
                        if (n4 > n6) {
                            throw new Asn1Exception("Invalid diffminute value: " + n2);
                        }
                        this.safeParseString();
                        asn1Time = this;
                        n3 = n;
                        if (n5 != 0) break block12;
                        asn1Time.diffHour = n3;
                        n4 = n;
                    }
                    if (n4 >= 0) break block13;
                    this.diffMin = -Math.abs(n2);
                    if (n5 == 0) break block14;
                }
                asn1Time = this;
                n3 = Math.abs(n2);
            }
            asn1Time.diffMin = n3;
        }
        this.compileString();
    }

    public void setDiff(int n) throws Asn1Exception {
        int n2 = Math.abs(n);
        if (Asn1Type.a == 0) {
            if (n2 > 720) {
                throw new Asn1Exception("Invalid diff value: " + n);
            }
            this.safeParseString();
            this.diffHour = n / 60;
            this.diffMin = n % 60;
            n2 = this.compileString() ? 1 : 0;
        }
    }

    public void clear() {
        this.hour = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.diffMin = 0;
        this.diffHour = 0;
        this.second = 0;
        this.minute = 0;
        this.secFraction = 0;
        boolean bl = this.derRules;
        if (Asn1Type.a == 0) {
            bl = bl;
        }
        this.utcFlag = bl;
        this.parsed = true;
        this.value = "";
    }

    public boolean equals(Object object) {
        int n = Asn1Type.a;
        boolean bl = object instanceof Asn1Time;
        if (n == 0) {
            if (bl) {
                return this.getTime().equals(((Asn1Time)object).getTime());
            }
            bl = object instanceof Calendar;
        }
        if (n == 0) {
            if (bl) {
                return this.getTime().equals((Calendar)object);
            }
            bl = false;
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n = object instanceof Calendar;
        if (Asn1Type.a == 0) {
            if (n != 0) {
                return (int)(this.getTime().getTime().getTime() - ((Calendar)object).getTime().getTime());
            }
            n = (int)(this.getTime().getTime().getTime() - ((Asn1Time)object).getTime().getTime().getTime());
        }
        return n;
    }

    public abstract void parseString(String var1) throws Asn1Exception;

    protected abstract boolean compileString();

    protected static int parseInt(String string, IntHolder intHolder, int n) {
        int n2 = intHolder.value + n;
        if (Asn1Type.a == 0) {
            if (n2 > string.length()) {
                throw new IndexOutOfBoundsException();
            }
            n2 = Integer.parseInt(string.substring(intHolder.value, intHolder.value += n));
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    protected void putInteger(int var1_1, int var2_2) {
        block4: {
            block2: {
                block3: {
                    var7_3 = Asn1Type.a;
                    var3_4 = String.valueOf(var2_2);
                    v0 = var4_5 = var3_4.length();
                    v1 = var1_1;
                    if (var7_3 != 0) break block2;
                    if (v0 >= v1) break block3;
                    var5_6 = var4_5;
                    var6_7 = false;
                    if (var7_3 == 0) ** GOTO lbl14
                    do {
                        this.mStringBuffer.append('0');
                        ++var5_6;
lbl14:
                        // 2 sources

                    } while (var5_6 < var1_1);
                    break block4;
                }
                v0 = var4_5;
                v1 = var1_1;
            }
            if (v0 > v1) {
                var3_4 = var3_4.substring(var4_5 - var1_1);
            }
        }
        this.mStringBuffer.append(var3_4);
    }

    protected static char charAt(String string, int n) {
        char c2 = n;
        if (Asn1Type.a == 0) {
            if (c2 >= string.length()) {
                return '\u0000';
            }
            c2 = string.charAt(n);
        }
        return c2;
    }

    protected void safeParseString() {
        block4: {
            try {
                Asn1Time asn1Time = this;
                if (Asn1Type.a == 0) {
                    if (asn1Time.parsed) break block4;
                    asn1Time = this;
                }
                asn1Time.parseString(this.value);
            }
            catch (Asn1Exception asn1Exception) {
                // empty catch block
            }
        }
    }

    protected void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        this.parsed = false;
        super.decode(asn1BerDecodeBuffer, bl, n, asn1Tag);
        this.setDER(asn1BerDecodeBuffer instanceof Asn1DerDecodeBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception {
        int n = Asn1Type.a;
        this.safeParseString();
        int n2 = asn1BerEncodeBuffer instanceof Asn1DerEncodeBuffer;
        int n3 = this.derRules;
        if (n != 0) return n3;
        if (n3 != n2) {
            this.setDER(n2 != 0);
            n3 = this.compileString();
            if (n != 0) return n3;
            if (n3 == 0) {
                throw new Asn1Exception("Time string could not be generated.");
            }
        }
        n3 = super.encode(asn1BerEncodeBuffer, bl, asn1Tag);
        return n3;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.parsed = false;
        super.decode(asn1PerDecodeBuffer);
        this.setDER(true);
    }

    /*
     * Unable to fully structure code
     */
    public void encode(Asn1PerEncodeBuffer var1_1) throws Asn1Exception, IOException {
        var2_2 = Asn1Type.a;
        this.safeParseString();
        v0 = this;
        if (var2_2 == 0) {
            if (!v0.derRules) {
                this.setDER(true);
                v0 = this;
                if (var2_2 == 0) {
                    if (!v0.compileString()) {
                        throw new Asn1Exception("Time string could not be generated.");
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                v0 = this;
            }
        }
        super.encode(var1_1);
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl, Asn1Tag asn1Tag) throws Asn1Exception, IOException {
        this.safeParseString();
        asn1BerOutputStream.encodeCharString(this.value, bl, asn1Tag);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.a);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(this.year);
        objectOutputStream.writeByte(this.month);
        objectOutputStream.writeByte(this.day);
        objectOutputStream.writeByte(this.hour);
        objectOutputStream.writeByte(this.minute);
        objectOutputStream.writeByte(this.second);
        objectOutputStream.writeByte(this.secFraction);
        objectOutputStream.writeByte(this.diffHour);
        objectOutputStream.writeByte(this.diffMin);
        objectOutputStream.writeBoolean(this.utcFlag);
        objectOutputStream.writeBoolean(this.parsed);
        objectOutputStream.writeBoolean(this.derRules);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.year = objectInputStream.readShort();
        this.month = objectInputStream.read();
        this.day = objectInputStream.read();
        this.hour = objectInputStream.read();
        this.minute = objectInputStream.read();
        this.second = objectInputStream.read();
        this.secFraction = objectInputStream.read();
        this.diffHour = objectInputStream.read();
        this.diffMin = objectInputStream.read();
        this.utcFlag = objectInputStream.readBoolean();
        this.parsed = objectInputStream.readBoolean();
        this.derRules = objectInputStream.readBoolean();
    }
}

