/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1CharString;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Asn1UTF8String
extends Asn1CharString {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 12);

    public Asn1UTF8String() {
        super((short)12);
    }

    public Asn1UTF8String(String string) {
        super(string, (short)12);
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        int n2 = bl ? this.matchTag(asn1BerDecodeBuffer, TAG) : n;
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        asn1OctetString.decode(asn1BerDecodeBuffer, false, n2);
        this.value = new String(asn1OctetString.value, "UTF8");
        if (bl && n2 == -9999) {
            this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
        }
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n = 0;
        try {
            byte[] byArray = this.value.getBytes("UTF8");
            n = byArray.length;
            asn1BerEncodeBuffer.copy(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
        }
        if (bl) {
            n += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n);
        }
        return n;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        do {
            if ((n = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            asn1PerDecodeBuffer.byteAlign();
            byArray = n3 == 0 ? this.a(n2) : this.a(byArray, n2 += n);
            asn1PerDecodeBuffer.decodeBitsToOctetArray(byArray, n3, n * 8);
            if (n < 16384) continue;
            n3 = n2;
        } while (n >= 16384);
        this.value = new String(byArray, "UTF8");
        asn1PerDecodeBuffer.setTypeCode((short)12);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, int n, int n2) throws Asn1Exception, IOException {
        if (n2 < 65536) {
            int n3 = (int)asn1PerDecodeBuffer.decodeLength(n, n2);
            if (n3 > 0) {
                asn1PerDecodeBuffer.byteAlign();
                byte[] byArray = this.a(n3);
                asn1PerDecodeBuffer.decodeBitsToOctetArray(byArray, 0, n3 * 8);
                this.value = new String(byArray, "UTF8");
                asn1PerDecodeBuffer.setTypeCode((short)12);
            }
        } else {
            this.decode(asn1PerDecodeBuffer);
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception {
        byte[] byArray = null;
        try {
            byArray = this.value.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
            return;
        }
        int n = byArray.length;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = (int)asn1PerEncodeBuffer.encodeLength(n)) > 0) {
                asn1PerEncodeBuffer.byteAlign();
                asn1PerEncodeBuffer.encodeBits(byArray, n2, n3 * 8);
            }
            if ((n -= n3) <= 0) break;
            n2 += n3;
        }
        asn1PerEncodeBuffer.encodeLengthEOM(n);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, int n, int n2) throws Asn1Exception {
        byte[] byArray = null;
        try {
            byArray = this.value.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
            return;
        }
        if (byArray.length >= n && byArray.length <= n2) {
            if (n2 < 65536) {
                asn1PerEncodeBuffer.encodeLength(byArray.length, n, n2);
                if (byArray.length > 0) {
                    asn1PerEncodeBuffer.byteAlign();
                    asn1PerEncodeBuffer.encodeBits(byArray, 0, byArray.length * 8);
                }
            } else {
                this.encode(asn1PerEncodeBuffer);
            }
        } else {
            throw new Asn1ConsVioException("Asn1UTF8String.length", byArray.length);
        }
    }

    private byte[] a(int n) {
        return new byte[n];
    }

    private byte[] a(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = byArray;
        if (Asn1Type.a == 0) {
            if (byArray3 != null) {
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            }
            byArray3 = byArray2;
        }
        return byArray3;
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        try {
            byte[] byArray = this.value.getBytes("UTF8");
            if (bl) {
                asn1BerOutputStream.encodeTag(TAG);
            }
            asn1BerOutputStream.encodeLength(byArray.length);
            asn1BerOutputStream.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.a);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, int n, int n2) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.a, n, n2);
        asn1PerOutputStream.a(false);
    }
}

