/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedWithParams;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBeanDescription
extends BeanDescription {
    protected final AnnotatedClass _classInfo;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected TypeBindings _bindings;

    public BasicBeanDescription(JavaType type, AnnotatedClass ac, AnnotationIntrospector ai) {
        super(type);
        this._classInfo = ac;
        this._annotationIntrospector = ai;
    }

    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._classInfo.findMethod(name, paramTypes);
    }

    public Object instantiateBean(boolean fixAccess) {
        AnnotatedConstructor ac = this._classInfo.getDefaultConstructor();
        if (ac == null) {
            return null;
        }
        if (fixAccess) {
            ac.fixAccess();
        }
        try {
            return ((Constructor)ac.getAnnotated()).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + t.getClass().getName() + ") " + t.getMessage(), t);
        }
    }

    public TypeBindings bindingsForBeanType() {
        if (this._bindings == null) {
            this._bindings = new TypeBindings(this._type);
        }
        return this._bindings;
    }

    @Override
    public LinkedHashMap<String, AnnotatedMethod> findGetters(VisibilityChecker<?> visibilityChecker, Collection<String> ignoredProperties) {
        LinkedHashMap<String, AnnotatedMethod> results = new LinkedHashMap<String, AnnotatedMethod>();
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            AnnotatedMethod old;
            if (am.getParameterCount() != 0) continue;
            String propName = this._annotationIntrospector.findGettablePropertyName(am);
            if (propName != null) {
                if (propName.length() == 0 && (propName = this.okNameForAnyGetter(am, am.getName())) == null) {
                    propName = am.getName();
                }
            } else {
                propName = am.getName();
                if (propName.startsWith("get")) {
                    if (!visibilityChecker.isGetterVisible(am)) continue;
                    propName = this.okNameForGetter(am, propName);
                } else {
                    if (!visibilityChecker.isIsGetterVisible(am)) continue;
                    propName = this.okNameForIsGetter(am, propName);
                }
                if (propName == null || this._annotationIntrospector.hasAnyGetterAnnotation(am)) continue;
            }
            if (ignoredProperties != null && ignoredProperties.contains(propName) || (old = results.put(propName, am)) == null) continue;
            String oldDesc = old.getFullName();
            String newDesc = am.getFullName();
            throw new IllegalArgumentException("Conflicting getter definitions for property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
        }
        return results;
    }

    public AnnotatedMethod findJsonValueMethod() {
        AnnotatedMethod found = null;
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            if (!this._annotationIntrospector.hasAsValueAnnotation(am)) continue;
            if (found != null) {
                throw new IllegalArgumentException("Multiple methods with active 'as-value' annotation (" + found.getName() + "(), " + am.getName() + ")");
            }
            if (!ClassUtil.hasGetterSignature(am.getAnnotated())) {
                throw new IllegalArgumentException("Method " + am.getName() + "() marked with an 'as-value' annotation, but does not have valid getter signature (non-static, takes no args, returns a value)");
            }
            found = am;
        }
        return found;
    }

    public Constructor<?> findDefaultConstructor() {
        AnnotatedConstructor ac = this._classInfo.getDefaultConstructor();
        if (ac == null) {
            return null;
        }
        return ac.getAnnotated();
    }

    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> candidates = this._classInfo.getStaticMethods();
        if (candidates.isEmpty()) {
            return candidates;
        }
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod am : candidates) {
            if (!this.isFactoryMethod(am)) continue;
            result.add(am);
        }
        return result;
    }

    public Constructor<?> findSingleArgConstructor(Class<?> ... argTypes) {
        for (AnnotatedConstructor ac : this._classInfo.getConstructors()) {
            if (ac.getParameterCount() != 1) continue;
            Class<?> actArg = ac.getParameterClass(0);
            for (Class<?> expArg : argTypes) {
                if (expArg != actArg) continue;
                return ac.getAnnotated();
            }
        }
        return null;
    }

    public Method findFactoryMethod(Class<?> ... expArgTypes) {
        for (AnnotatedMethod am : this._classInfo.getStaticMethods()) {
            if (!this.isFactoryMethod(am)) continue;
            Class<?> actualArgType = am.getParameterClass(0);
            for (Class<?> expArgType : expArgTypes) {
                if (!actualArgType.isAssignableFrom(expArgType)) continue;
                return am.getAnnotated();
            }
        }
        return null;
    }

    protected boolean isFactoryMethod(AnnotatedMethod am) {
        Class<?> rt = am.getRawType();
        if (!this.getBeanClass().isAssignableFrom(rt)) {
            return false;
        }
        if (this._annotationIntrospector.hasCreatorAnnotation(am)) {
            return true;
        }
        return "valueOf".equals(am.getName());
    }

    public List<String> findCreatorPropertyNames() {
        ArrayList<String> names = null;
        for (int i = 0; i < 2; ++i) {
            List<AnnotatedWithParams> l = i == 0 ? this.getConstructors() : this.getFactoryMethods();
            for (AnnotatedWithParams creator : l) {
                String name;
                int argCount = creator.getParameterCount();
                if (argCount < 1 || (name = this._annotationIntrospector.findPropertyNameForParam(creator.getParameter(0))) == null) continue;
                if (names == null) {
                    names = new ArrayList<String>();
                }
                names.add(name);
                for (int p = 1; p < argCount; ++p) {
                    names.add(this._annotationIntrospector.findPropertyNameForParam(creator.getParameter(p)));
                }
            }
        }
        if (names == null) {
            return Collections.emptyList();
        }
        return names;
    }

    public LinkedHashMap<String, AnnotatedField> findSerializableFields(VisibilityChecker<?> vchecker, Collection<String> ignoredProperties) {
        return this._findPropertyFields(vchecker, ignoredProperties, true);
    }

    public JsonSerialize.Inclusion findSerializationInclusion(JsonSerialize.Inclusion defValue) {
        return this._annotationIntrospector.findSerializationInclusion(this._classInfo, defValue);
    }

    @Override
    public LinkedHashMap<String, AnnotatedMethod> findSetters(VisibilityChecker<?> vchecker) {
        LinkedHashMap<String, AnnotatedMethod> results = new LinkedHashMap<String, AnnotatedMethod>();
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            AnnotatedMethod old;
            if (am.getParameterCount() != 1) continue;
            String propName = this._annotationIntrospector.findSettablePropertyName(am);
            if (propName != null) {
                if (propName.length() == 0 && (propName = this.okNameForSetter(am)) == null) {
                    propName = am.getName();
                }
            } else if (!vchecker.isSetterVisible(am) || (propName = this.okNameForSetter(am)) == null) continue;
            if ((old = results.put(propName, am)) == null) continue;
            if (old.getDeclaringClass() == am.getDeclaringClass()) {
                String oldDesc = old.getFullName();
                String newDesc = am.getFullName();
                throw new IllegalArgumentException("Conflicting setter definitions for property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
            }
            results.put(propName, old);
        }
        return results;
    }

    public AnnotatedMethod findAnySetter() throws IllegalArgumentException {
        AnnotatedMethod found = null;
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            if (!this._annotationIntrospector.hasAnySetterAnnotation(am)) continue;
            if (found != null) {
                throw new IllegalArgumentException("Multiple methods with 'any-setter' annotation (" + found.getName() + "(), " + am.getName() + ")");
            }
            int pcount = am.getParameterCount();
            if (pcount != 2) {
                throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + am.getName() + "(): takes " + pcount + " parameters, should take 2");
            }
            Class<?> type = am.getParameterClass(0);
            if (type != String.class && type != Object.class) {
                throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + am.getName() + "(): first argument not of type String or Object, but " + type.getName());
            }
            found = am;
        }
        return found;
    }

    public AnnotatedMethod findAnyGetter() throws IllegalArgumentException {
        AnnotatedMethod found = null;
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            if (!this._annotationIntrospector.hasAnyGetterAnnotation(am)) continue;
            if (found != null) {
                throw new IllegalArgumentException("Multiple methods with 'any-getter' annotation (" + found.getName() + "(), " + am.getName() + ")");
            }
            Class<?> type = am.getRawType();
            if (!Map.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("Invalid 'any-getter' annotation on method " + am.getName() + "(): return type is not instance of java.util.Map");
            }
            found = am;
        }
        return found;
    }

    public Map<String, AnnotatedMember> findBackReferenceProperties() {
        AnnotationIntrospector.ReferenceProperty prop;
        HashMap<String, AnnotatedMethod> result = null;
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            if (am.getParameterCount() != 1 || (prop = this._annotationIntrospector.findReferenceType(am)) == null || !prop.isBackReference()) continue;
            if (result == null) {
                result = new HashMap<String, AnnotatedMethod>();
            }
            if (result.put(prop.getName(), am) == null) continue;
            throw new IllegalArgumentException("Multiple back-reference properties with name '" + prop.getName() + "'");
        }
        for (AnnotatedField af : this._classInfo.fields()) {
            prop = this._annotationIntrospector.findReferenceType(af);
            if (prop == null || !prop.isBackReference()) continue;
            if (result == null) {
                result = new HashMap();
            }
            if (result.put(prop.getName(), (AnnotatedMethod)((Object)af)) == null) continue;
            throw new IllegalArgumentException("Multiple back-reference properties with name '" + prop.getName() + "'");
        }
        return result;
    }

    public LinkedHashMap<String, AnnotatedField> findDeserializableFields(VisibilityChecker<?> vchecker, Collection<String> ignoredProperties) {
        return this._findPropertyFields(vchecker, ignoredProperties, false);
    }

    public String okNameForAnyGetter(AnnotatedMethod am, String name) {
        String str = this.okNameForIsGetter(am, name);
        if (str == null) {
            str = this.okNameForGetter(am, name);
        }
        return str;
    }

    public String okNameForGetter(AnnotatedMethod am, String name) {
        if (name.startsWith("get")) {
            if ("getCallbacks".equals(name) ? this.isCglibGetCallbacks(am) : "getMetaClass".equals(name) && this.isGroovyMetaClassGetter(am)) {
                return null;
            }
            return this.mangleGetterName(am, name.substring(3));
        }
        return null;
    }

    public String okNameForIsGetter(AnnotatedMethod am, String name) {
        if (name.startsWith("is")) {
            Class<?> rt = am.getRawType();
            if (rt != Boolean.class && rt != Boolean.TYPE) {
                return null;
            }
            return this.mangleGetterName(am, name.substring(2));
        }
        return null;
    }

    protected String mangleGetterName(Annotated a, String basename) {
        return BasicBeanDescription.manglePropertyName(basename);
    }

    protected boolean isCglibGetCallbacks(AnnotatedMethod am) {
        String pname;
        Class<?> rt = am.getRawType();
        if (rt == null || !rt.isArray()) {
            return false;
        }
        Class<?> compType = rt.getComponentType();
        Package pkg = compType.getPackage();
        return pkg != null && ((pname = pkg.getName()).startsWith("net.sf.cglib") || pname.startsWith("org.hibernate.repackage.cglib"));
    }

    protected boolean isGroovyMetaClassSetter(AnnotatedMethod am) {
        Class<?> argType = am.getParameterClass(0);
        Package pkg = argType.getPackage();
        return pkg != null && pkg.getName().startsWith("groovy.lang");
    }

    protected boolean isGroovyMetaClassGetter(AnnotatedMethod am) {
        Class<?> rt = am.getRawType();
        if (rt == null || rt.isArray()) {
            return false;
        }
        Package pkg = rt.getPackage();
        return pkg != null && pkg.getName().startsWith("groovy.lang");
    }

    public String okNameForSetter(AnnotatedMethod am) {
        String name = am.getName();
        if (name.startsWith("set")) {
            if ((name = this.mangleSetterName(am, name.substring(3))) == null) {
                return null;
            }
            if ("metaClass".equals(name) && this.isGroovyMetaClassSetter(am)) {
                return null;
            }
            return name;
        }
        return null;
    }

    protected String mangleSetterName(Annotated a, String basename) {
        return BasicBeanDescription.manglePropertyName(basename);
    }

    public LinkedHashMap<String, AnnotatedField> _findPropertyFields(VisibilityChecker<?> vchecker, Collection<String> ignoredProperties, boolean forSerialization) {
        LinkedHashMap<String, AnnotatedField> results = new LinkedHashMap<String, AnnotatedField>();
        for (AnnotatedField af : this._classInfo.fields()) {
            AnnotatedField old;
            String propName;
            String string = propName = forSerialization ? this._annotationIntrospector.findSerializablePropertyName(af) : this._annotationIntrospector.findDeserializablePropertyName(af);
            if (propName != null) {
                if (propName.length() == 0) {
                    propName = af.getName();
                }
            } else {
                if (!vchecker.isFieldVisible(af)) continue;
                propName = af.getName();
            }
            if (ignoredProperties != null && ignoredProperties.contains(propName) || (old = results.put(propName, af)) == null || old.getDeclaringClass() != af.getDeclaringClass()) continue;
            String oldDesc = old.getFullName();
            String newDesc = af.getFullName();
            throw new IllegalArgumentException("Multiple fields representing property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
        }
        return results;
    }

    public static String manglePropertyName(String basename) {
        char lower;
        char upper;
        int len = basename.length();
        if (len == 0) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < len && (upper = basename.charAt(i)) != (lower = Character.toLowerCase(upper)); ++i) {
            if (sb == null) {
                sb = new StringBuilder(basename);
            }
            sb.setCharAt(i, lower);
        }
        return sb == null ? basename : sb.toString();
    }

    public static String descFor(AnnotatedElement elem) {
        if (elem instanceof Class) {
            return "class " + ((Class)elem).getName();
        }
        if (elem instanceof Method) {
            Method m = (Method)elem;
            return "method " + m.getName() + " (from class " + m.getDeclaringClass().getName() + ")";
        }
        if (elem instanceof Constructor) {
            Constructor ctor = (Constructor)elem;
            return "constructor() (from class " + ctor.getDeclaringClass().getName() + ")";
        }
        return "unknown type [" + elem.getClass() + "]";
    }
}

