/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.xml.FromXmlParser;
import org.codehaus.jackson.xml.StaxUtil;
import org.codehaus.jackson.xml.ToXmlGenerator;

public class XmlFactory
extends JsonFactory {
    static final int DEFAULT_XML_PARSER_FEATURE_FLAGS = FromXmlParser.Feature.collectDefaults();
    static final int DEFAULT_XML_GENERATOR_FEATURE_FLAGS = ToXmlGenerator.Feature.collectDefaults();
    protected int _xmlParserFeatures = DEFAULT_XML_PARSER_FEATURE_FLAGS;
    protected int _xmlGeneratorFeatures = DEFAULT_XML_GENERATOR_FEATURE_FLAGS;
    protected XMLInputFactory _xmlInputFactory;
    protected XMLOutputFactory _xmlOutputFactory;

    public XmlFactory() {
        this(null);
    }

    public XmlFactory(ObjectCodec oc) {
        this(oc, null, null);
    }

    public XmlFactory(ObjectCodec oc, XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        super(oc);
        if (xmlIn == null) {
            xmlIn = XMLInputFactory.newInstance();
        }
        if (xmlOut == null) {
            xmlOut = XMLOutputFactory.newInstance();
        }
        xmlOut.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        this._xmlInputFactory = xmlIn;
        this._xmlOutputFactory = xmlOut;
    }

    public final XmlFactory configure(FromXmlParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public XmlFactory enable(FromXmlParser.Feature f) {
        this._xmlParserFeatures |= f.getMask();
        return this;
    }

    public XmlFactory disable(FromXmlParser.Feature f) {
        this._xmlParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(FromXmlParser.Feature f) {
        return (this._xmlParserFeatures & f.getMask()) != 0;
    }

    public final XmlFactory configure(ToXmlGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public XmlFactory enable(ToXmlGenerator.Feature f) {
        this._xmlGeneratorFeatures |= f.getMask();
        return this;
    }

    public XmlFactory disable(ToXmlGenerator.Feature f) {
        this._xmlGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(ToXmlGenerator.Feature f) {
        return (this._xmlGeneratorFeatures & f.getMask()) != 0;
    }

    public void setXMLInputFactory(XMLInputFactory f) {
        this._xmlInputFactory = f;
    }

    public void setXMLOutputFactory(XMLOutputFactory f) {
        this._xmlOutputFactory = f;
    }

    public ToXmlGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return new ToXmlGenerator(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createJsonGenerator(Writer out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return new ToXmlGenerator(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createJsonGenerator(File f, JsonEncoding enc) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        return new ToXmlGenerator(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    protected FromXmlParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return null;
    }

    protected FromXmlParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return null;
    }

    protected FromXmlParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return null;
    }

    protected XMLStreamWriter _createXmlWriter(OutputStream out) throws IOException {
        try {
            return this._xmlOutputFactory.createXMLStreamWriter(out, "UTF-8");
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected XMLStreamWriter _createXmlWriter(Writer w) throws IOException {
        try {
            return this._xmlOutputFactory.createXMLStreamWriter(w);
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(e);
        }
    }
}

