-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.1.47-community


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;



--
-- Create schema insight
--

CREATE DATABASE IF NOT EXISTS insight;
-- CREATE USER 'insight'@'localhost' IDENTIFIED BY 'insight';
-- GRANT ALL PRIVILEGES ON insight.* to 'insight'@'localhost';

USE insight;


--
-- Definition of table `config_color`
--

DROP TABLE IF EXISTS `config_color`;
CREATE TABLE `config_color` (
  `color_id` int(11) NOT NULL AUTO_INCREMENT,
  `color_code` varchar(8) DEFAULT NULL,
  `color_name` varchar(45) NOT NULL,
  PRIMARY KEY (`color_id`),
  UNIQUE KEY `unq_config_color_code` (`color_code`),
  UNIQUE KEY `color_code` (`color_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


--
-- Definition of table `cmts_details`
--
DROP TABLE IF EXISTS `cmts_details`;
CREATE TABLE  `cmts_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cmts_name` varchar(20) NOT NULL,
  `device_id` int(11) NOT NULL,
  `color_code` varchar(12) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_cmts_details_1` (`device_id`),
  CONSTRAINT `FK_cmts_details_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store cmts details';
--
-- Definition of table `config_custom_color`
--

DROP TABLE IF EXISTS `config_custom_color`;
CREATE TABLE `config_custom_color` (
  `color_id` int(11) NOT NULL AUTO_INCREMENT,
  `color_code` varchar(8) DEFAULT NULL,
  `color_name` varchar(45) DEFAULT NULL,
  `color_rank` int(11) DEFAULT NULL,
  PRIMARY KEY (`color_id`),
  UNIQUE KEY `unq_custom_color_code` (`color_code`),
  UNIQUE KEY `config_custom_color_color_rank_uk` (`color_rank`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Definition of table `config_service_color`
--

DROP TABLE IF EXISTS `config_service_color`;
CREATE TABLE `config_service_color` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `color_code` varchar(8) NOT NULL,
  `service_name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_service_color_code` (`color_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Definition of table `config_system_param`
--

DROP TABLE IF EXISTS `config_system_param`;
CREATE TABLE `config_system_param` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(50) NOT NULL,
  `item` varchar(100) NOT NULL,
  `type` int(11) NOT NULL,
  `allowed_values` varchar(400) DEFAULT NULL,
  `selected_values` varchar(400) NOT NULL,
  `validation` varchar(200) DEFAULT NULL,
  `readonly` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `unq_config_system_item` (`item`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Definition of table `custom_layout`
--

DROP TABLE IF EXISTS `custom_layout`;
CREATE TABLE `custom_layout` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) DEFAULT NULL,
  `logo` tinyint(3) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `sub_title` LONGTEXT DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `chart_type` int(11) DEFAULT NULL,
  `is_table` tinyint(3) DEFAULT NULL,
  `legend` tinyint(3) DEFAULT NULL,
  `parameters` tinyint(3) DEFAULT NULL,
  `locale` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE, 
   KEY `FK_custom_layout_1` (`report_id`),
  CONSTRAINT `FK_custom_layout_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

--
-- Definition of table `dashboard_widget`
--

DROP TABLE IF EXISTS `dashboard_widget`;
CREATE TABLE `dashboard_widget` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `X_Axis` int(11) DEFAULT NULL,
  `Y_Axis` int(11) DEFAULT NULL,
  `Width` int(11) DEFAULT NULL,
  `Height` int(11) DEFAULT NULL,
  `chartType` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Definition of table `device`
--

DROP TABLE IF EXISTS `device`;
CREATE TABLE  `device` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(15) NOT NULL,
  `hostname` varchar(15) DEFAULT NULL,
  `device_type_id` int(11) DEFAULT NULL,
  `total_link` smallint(6) NOT NULL DEFAULT '2',
  `is_manageable` tinyint(1) DEFAULT '0',
  `location` varchar(50) DEFAULT NULL,
  `description` varchar(50) DEFAULT NULL,
  `remote_db_id` int(11) NOT NULL,
  `is_monitored` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `color_code` varchar(45) DEFAULT NULL,
  `label` varchar(45) DEFAULT NULL,
  `is_deleted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `ip_address` (`ip_address`,`remote_db_id`),
  KEY `device_type_id` (`device_type_id`) USING BTREE,
  KEY `FK_device_2` (`remote_db_id`),
  CONSTRAINT `device_ibfk_1` FOREIGN KEY (`device_type_id`) REFERENCES `device_type` (`ID`),
  CONSTRAINT `FK_device_2` FOREIGN KEY (`remote_db_id`) REFERENCES `remote_db_param` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='To store the information of control engine devices .';

--
-- Definition of table `device_service_tree_mapping`
--

DROP TABLE IF EXISTS `device_service_tree_mapping`;
CREATE TABLE  `device_service_tree_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '    ',
  `device_id` int(11) NOT NULL DEFAULT '0',
  `is_default_id` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `FK_device_service_tree_mapping_1` (`device_id`),
  CONSTRAINT `FK_device_service_tree_mapping_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8  COMMENT='To store service tree mapping of a network';



--
-- Definition of table `device_type`
--

DROP TABLE IF EXISTS `device_type`;
CREATE TABLE `device_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `model_number` varchar(45) NOT NULL,
  `description` varchar(45) DEFAULT NULL,
  `color_code` varchar(8) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `model_number` (`model_number`),
  UNIQUE KEY `model_number_2` (`model_number`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Definition of table `device_physical_link`
--

DROP TABLE IF EXISTS `device_physical_link`;
CREATE TABLE  `device_physical_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `physical_link_id` int(10) unsigned NOT NULL,
  `device_id` int(11) NOT NULL, 
  `color_code` varchar(12) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_device_physical_link_1` (`device_id`),
  CONSTRAINT `FK_device_physical_link_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
--
-- Definition of table `device_virtual_link`
--

DROP TABLE IF EXISTS `device_virtual_link`;
CREATE TABLE `device_virtual_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(45) DEFAULT NULL,
  `direction` tinyint(3) DEFAULT '0',
  `category` int(11) NOT NULL DEFAULT '1',
  `parent_id` int(11) DEFAULT NULL,
  `vlink_id` int(11) NOT NULL DEFAULT '0',
  `color_code` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_device_virtual_link_1` (`device_id`),
  CONSTRAINT `FK_device_virtual_link_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


--
-- Definition of table `favorite_reports`
--



DROP TABLE IF EXISTS `favorite_reports`;
CREATE TABLE  `favorite_reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `report_id` int(11) NOT NULL,
  `last_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` varchar(45) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Index_4` (`user_id`,`report_id`),
  KEY `FK_favorite_reports_2` (`report_id`),
  CONSTRAINT `FK_favorite_reports_2` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_favorite_reports_1` FOREIGN KEY (`user_id`) REFERENCES `user_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8;



--
-- Definition of table `local_ini_values`
--
DROP TABLE IF EXISTS `local_ini_values`;
CREATE TABLE  `local_ini_values` (
  `time_stamp` datetime DEFAULT NULL,
  `se_ip` varchar(20) DEFAULT NULL,
  `value_type` smallint(6) DEFAULT NULL,
  `value_key` varchar(80) DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `remote_db_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Definition of table `network`
--
DROP TABLE IF EXISTS `network`;
CREATE TABLE  `network` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `remote_db_id` int(11) NOT NULL,
  `sm_ip_address` varchar(124) DEFAULT NULL,
  `topology_group_id` int(11) DEFAULT NULL,
  `default_service_tree_id` int(11) DEFAULT NULL,
  `custom_service_tree_id` int(11) DEFAULT NULL,
  `master_device_id` int(11) DEFAULT NULL,
  `cmts_aware` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `networkName` (`name`),
  KEY `FK_network_5` (`remote_db_id`),
  KEY `network_ibfk_1` (`topology_group_id`),
  CONSTRAINT `FK_network_5` FOREIGN KEY (`remote_db_id`) REFERENCES `remote_db_param` (`id`),
  CONSTRAINT `network_ibfk_1` FOREIGN KEY (`topology_group_id`) REFERENCES `topology_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='to store configured network infromation';


--
-- Definition of table `network_cmts`
--

DROP TABLE IF EXISTS `network_cmts`;
CREATE TABLE `network_cmts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `network_id` int(11) NOT NULL,
  `cmts_id` int(11) NOT NULL DEFAULT '0',
  `color_code` varchar(12) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_network_cmts_2` (`cmts_id`),
  KEY `FK_network_cmts_1` (`network_id`),
  CONSTRAINT `FK_network_cmts_1` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_network_cmts_2` FOREIGN KEY (`cmts_id`) REFERENCES `device_virtual_link` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;


--
-- Definition of table `network_device_item`
--

DROP TABLE IF EXISTS `network_device_item`;
CREATE TABLE  `network_device_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `network_id` int(11) NOT NULL DEFAULT '0',
  `device_id` int(11) NOT NULL DEFAULT '0',
  `is_master` tinyint(1) NOT NULL DEFAULT '0',
  `color_code` varchar(10) NOT NULL DEFAULT '#000000',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `FK_network_device_item_1` (`network_id`),
  KEY `FK_network_device_item_2` (`device_id`),
  CONSTRAINT `FK_network_device_item_2` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_network_device_item_1` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;


--
-- Definition of table `network_device_service_tree_mapping`
--

DROP TABLE IF EXISTS `network_device_service_tree_mapping`;
CREATE TABLE  `network_device_service_tree_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '	',
  `device_id` int(11) NOT NULL DEFAULT '0',
  `is_default_id` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `FK_network_device_service_tree_mapping_1` (`device_id`),
  CONSTRAINT `FK_network_device_service_tree_mapping_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='To store service tree mapping of a network';

--
-- Definition of table `network_device_type`
--

DROP TABLE IF EXISTS `network_device_type`;
CREATE TABLE `network_device_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `network_id` int(11) NOT NULL DEFAULT '0',
  `device_type_id` int(11) NOT NULL DEFAULT '0',
  `color_code` varchar(45) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_network_device_type_2` (`device_type_id`),
  KEY `FK_network_device_type_1` (`network_id`),
  CONSTRAINT `FK_network_device_type_1` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;




--
-- Definition of table `network_package`
--

DROP TABLE IF EXISTS `network_package`;
CREATE TABLE `network_package` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `network_id` int(11) NOT NULL DEFAULT '0',
  `package_id` int(11) NOT NULL DEFAULT '0',
  `color_code` varchar(45) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_network_package_2` (`package_id`),
  KEY `FK_network_package_1` (`network_id`),
  CONSTRAINT `FK_network_package_1` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_network_package_2` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;



--
-- Definition of table `network_rdr_filter`
--

DROP TABLE IF EXISTS `network_rdr_filter`;
CREATE TABLE `network_rdr_filter` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RDRFilterID` int(11) DEFAULT NULL,
  `NetworkID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_Network_RDR_Filter_Network_Details_T1` (`NetworkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Store the selected topic filter for a particular network.';

--
-- Definition of table `network_report_filter`
--

DROP TABLE IF EXISTS `network_report_filter`;
CREATE TABLE `network_report_filter` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(50) DEFAULT NULL,
  `is_selected` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `network_id` int(11) NOT NULL DEFAULT '0',
  `description` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `network_report_filter_ibfk_1` (`network_id`),
  CONSTRAINT `network_report_filter_ibfk_1` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='store information about the filter applicable for a netwok';


--
-- Definition of table `network_service_tree`
--

DROP TABLE IF EXISTS `network_service_tree`;
CREATE TABLE  `network_service_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '		',
  `service_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `device_service_tree_id` int(11) NOT NULL,
  `parent_service_id` int(11) NOT NULL,
  `color_code` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_network_service_tree_1` (`device_service_tree_id`),
  CONSTRAINT `FK_network_service_tree_1` FOREIGN KEY (`device_service_tree_id`) REFERENCES `network_device_service_tree_mapping` (`id`) ON DELETE CASCADE
)  ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='To store the infromation of services.';



--
-- Definition of table `network_zone`
--

DROP TABLE IF EXISTS `network_zone`;
CREATE TABLE `network_zone` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `network_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) NOT NULL DEFAULT '0',
  `color_code` varchar(45) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_network_zone_2` (`zone_id`),
  KEY `FK_network_zone_1` (`network_id`),
  CONSTRAINT `FK_network_zone_1` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_network_zone_2` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)  ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;


--
-- Definition of table `package_visibility_filter`
--

DROP TABLE IF EXISTS `package_visibility_filter`;
CREATE TABLE `package_visibility_filter` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `VisibilityID` int(11) NOT NULL,
  `PackageID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_package_visi_ftr_t_visi_rights_ftr_id` (`VisibilityID`),
  KEY `package_visibility_filter_ibfk_2` (`PackageID`),
  KEY `FK166C058CFD598362` (`PackageID`),
  KEY `FK166C058C9508AFA2` (`VisibilityID`),
  CONSTRAINT `package_visibility_filter_ibfk_1` FOREIGN KEY (`VisibilityID`) REFERENCES `visibility_rights_filter` (`ID`) ON DELETE CASCADE,
  CONSTRAINT `package_visibility_filter_ibfk_2` FOREIGN KEY (`PackageID`) REFERENCES `packages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;



--
-- Definition of table `packages`
--

DROP TABLE IF EXISTS `packages`;
CREATE TABLE  `packages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_name` varchar(50) DEFAULT NULL,
  `package_usage_counter` int(11) NOT NULL DEFAULT '0',
  `deviceid` int(11) DEFAULT NULL,
  `color_code` varchar(15) DEFAULT NULL,
  `isselected` tinyint(1) DEFAULT '1',
  `packageid` int(255) unsigned DEFAULT '0',
  PRIMARY KEY (`id`,`package_usage_counter`) USING BTREE,
  KEY `packages_ibfk_1` (`deviceid`),
  CONSTRAINT `packages_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `device` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


--
-- Definition of table `profile_capability_rights`
--

DROP TABLE IF EXISTS `profile_capability_rights`;
CREATE TABLE `profile_capability_rights` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `CapabilityID` int(11) NOT NULL,
  `ProfileID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_profile_capability_righsts_t_profileID_user_profile_id` (`ProfileID`),
  KEY `fk_profile_capability_rights_t_capabilityID_capability_t_id` (`CapabilityID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `remote_db_param`
--

DROP TABLE IF EXISTS `remote_db_param`;
CREATE TABLE `remote_db_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT ' ',
  `db_schema` varchar(20) NOT NULL DEFAULT 'apricot',
  `db_schema_version` varchar(20) NOT NULL DEFAULT '3.5.1',
  `db_ipaddress` varchar(15) NOT NULL DEFAULT ' 0.0.0.0' COMMENT 'IPAddress of remote db.',
  `db_port` varchar(5) NOT NULL DEFAULT '3306' COMMENT 'Port address of remote db.		',
  `db_username` varchar(50) NOT NULL DEFAULT ' ' COMMENT 'dbuser name ',
  `db_password` varchar(20) NOT NULL DEFAULT ' ' COMMENT 'dbuser password',
  `status` tinyint(1) DEFAULT '0' COMMENT 'DB is in connected state or not.					',
  `timestamp_status` bigint(20) DEFAULT NULL COMMENT 'When Last db sink was successful.',
  `min_conn` int(11) NOT NULL DEFAULT '2' COMMENT 'Number of minmum connection.',
  `max_conn` int(11) NOT NULL DEFAULT '10' COMMENT 'Maximum connection number',
  `timeout_conn` int(11) NOT NULL DEFAULT '25' COMMENT 'Connection timeout.(in seconds)',
  `idle_duration` int(11) NOT NULL DEFAULT '20' COMMENT 'Idle timeout for a connection.(in minute)',
  `description` varchar(128) DEFAULT NULL,
  `db_type` int(10) unsigned NOT NULL DEFAULT '0',
  `synchronize_auto` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `synchronize_time` varchar(10) DEFAULT NULL,
  `alarm_state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='to store remote db configuration parameter.';



--
-- Definition of table `report_dashboard_widget`
--

DROP TABLE IF EXISTS `report_dashboard_widget`;
CREATE TABLE `report_dashboard_widget` (
  `widget_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `widget_label` varchar(255) NOT NULL,
   CONSTRAINT pk_rpt_wid_widget_id PRIMARY KEY (`widget_id`),
   INDEX ind_rpt_wid_widget_id (widget_id),
   CONSTRAINT FOREIGN KEY `fk_rpt_wid_widget_id` (widget_id) REFERENCES report_definition(id)
   ON DELETE CASCADE,
   INDEX ind_rpt_wid_user_id (user_id),
   CONSTRAINT FOREIGN KEY `fk_rpt_wid_user_id` (user_id) REFERENCES user_details(id)
   ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8 COMMENT='To store report dashboard widget details';



--
-- Definition of table `report_dashboard_window_properties`
--

DROP TABLE IF EXISTS `report_dashboard_window_properties`;
CREATE TABLE `report_dashboard_window_properties` (
  `widget_id` int(11) NOT NULL,
  `x` int(11) DEFAULT 0,
  `y` int(11) DEFAULT 0,
  `width` int(11) DEFAULT 0,
  `height` int(11) DEFAULT 0,
   CONSTRAINT pk_rpt_wid_props_widget_id PRIMARY KEY (`widget_id`),
   INDEX ind_rpt_wid_props_widget_id (widget_id),
   CONSTRAINT FOREIGN KEY `fk_rpt_wid__props_widget_id` (widget_id) REFERENCES report_dashboard_widget(widget_id)
   ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8 COMMENT='To store report dashboard widget window properties details';



--
-- Definition of table `report_def_custom_param`
--

DROP TABLE IF EXISTS `report_def_custom_param`;
CREATE TABLE `report_def_custom_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `param_value` varchar(4096) DEFAULT NULL,
  `param_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ind_cust_prm_rpt` (`report_id`),
  KEY `fk_report_def_custom_param_1` (`report_id`),
  CONSTRAINT `fk_report_def_custom_param_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store custom parameters for report';


--
-- Definition of table `report_def_service`
--

DROP TABLE IF EXISTS `report_def_service`;
CREATE TABLE `report_def_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `service_type` varchar(45) NOT NULL,
  `service_node_selection` varchar(1024) DEFAULT NULL,
  `service_in_clause_ids` varchar(1024) DEFAULT NULL,
  `show_top_services` tinyint(1) DEFAULT '0',
  `show_other_compositions` tinyint(1) DEFAULT '0',
  `top_services_to_show` int(11) DEFAULT NULL,
  `expanded_node_ids` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ind_rpt_service` (`report_id`),
  CONSTRAINT `fk_report_def_service_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store custom parameters for report';



--
-- Definition of table `report_def_topology`
--

DROP TABLE IF EXISTS `report_def_topology`;
CREATE TABLE `report_def_topology` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `topology_type` varchar(20) NOT NULL,
  `tolpology_node_selections` varchar(1024) DEFAULT NULL,
  `topology_in_clause_ids` varchar(1024) DEFAULT NULL,
  `show_links` tinyint(1) NOT NULL DEFAULT '0',
  `physical_link` tinyint(1) DEFAULT '0',
  `expanded_node_ids` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ind_rpt_service` (`report_id`),
  KEY `fk_report_def_topology_1` (`report_id`),
  CONSTRAINT `fk_report_def_topology_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='to store the topology tree selection for a particualr report';

--
-- Definition for report_def_topology_plink
--
DROP TABLE IF EXISTS `report_def_topology_plink`;
CREATE TABLE `report_def_topology_plink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `device_ip` varchar(15) NOT NULL,
  `link_id` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ind_rpt_service` (`report_id`),
  KEY `fk_report_def_topology_plink_1` (`report_id`),
  CONSTRAINT `fk_report_def_topology_plink_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12538 DEFAULT CHARSET=utf8 COMMENT='to store the link ids for a particular report';

--
-- Definition for report_def_topology_vlink
--
DROP TABLE IF EXISTS `report_def_topology_vlink`;
CREATE TABLE `report_def_topology_vlink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `device_ip` varchar(15) NOT NULL,
  `vlink_id` varchar(5) DEFAULT NULL,
  `cmts_id` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ind_rpt_service` (`report_id`),
  KEY `fk_report_def_topology_vlink_1` (`report_id`),
  CONSTRAINT `fk_report_def_topology_vlink_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12538 DEFAULT CHARSET=utf8 COMMENT='to store the vlink ids for a particular report';

--
-- Definition of table `report_definition`
--

DROP TABLE IF EXISTS `report_definition`;
CREATE TABLE `report_definition` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `network_id` int(11) NOT NULL,
  `topic_id` varchar(50) NOT NULL,
  `leading_input_type` int(3) DEFAULT NULL,
  `custom_name` varchar(100) DEFAULT NULL,
  `default_name` varchar(100) NOT NULL,
  `chart_type` int(11) NOT NULL DEFAULT '1',
  `description` varchar(1024) DEFAULT NULL,
  `persist_record` tinyint(1) DEFAULT '1',
  `template_report_id` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `network_id` (`network_id`),
  CONSTRAINT `network_id` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store report definiation and attributes';


--
-- Definition of table `report_duration`
--

DROP TABLE IF EXISTS `report_duration`;
CREATE TABLE `report_duration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `duration_type` int(11) DEFAULT 2,
  `last_time` int(11) DEFAULT 0 ,
  `last_time_unit` int(11) DEFAULT 0 ,
  `aggregation` int(11) DEFAULT 0 ,
  `start_date` TIMESTAMP NULL DEFAULT NULL,
  `end_date` TIMESTAMP NULL DEFAULT NULL,
  `use_device_time_zone` tinyint(1) DEFAULT '0',
  `last_time_selected` tinyint(1) DEFAULT '0',
   CONSTRAINT chk_rpt_dur_duration_type  CHECK (duration_type in (1,2)),
   CONSTRAINT chk_rpt_dur_last_time_unit CHECK (last_time_unit in (0,1,2)),
   CONSTRAINT chk_rpt_dur_aggregation CHECK (aggregation in (0,1,2,3,4,5,6)),
   CONSTRAINT pk_rpt_dur_id PRIMARY KEY (`id`),
   INDEX ind_rpt_dur_report_id (report_id),
   CONSTRAINT FOREIGN KEY `fk_rpt_dur_report_id` (report_id) REFERENCES report_definition (id)
   ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8 COMMENT='To store report duration filter details';



--
-- Definition of table `report_gallery`
--

DROP TABLE IF EXISTS `report_gallery`;
CREATE TABLE `report_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reportid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `temporary` tinyint(1) NOT NULL DEFAULT '0',
  `creationDate` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `fileType` int(11) NOT NULL DEFAULT '1',
  `custom_name` varchar(100) DEFAULT NULL,
  `default_name` varchar(100) NOT NULL,
  `chart_type` int(11) NOT NULL DEFAULT '1',
  `description` varchar(1024) NOT NULL DEFAULT '',
  `network_id` int(11) NOT NULL,
  `topic_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `report_gallery_ibfk_1` (`userid`),
  KEY `report_gallery_ibfk_2` (`network_id`),
  CONSTRAINT `report_gallery_ibfk_1` FOREIGN KEY (`userid`) REFERENCES `user_details` (`id`) ON DELETE CASCADE,
   CONSTRAINT `report_gallery_ibfk_2` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED;


--
-- Definition of table `report_lead_param`
--

DROP TABLE IF EXISTS `report_lead_param`;
CREATE TABLE `report_lead_param` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Leading_Input` varchar(50) DEFAULT NULL,
  `Leading_InputPath` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `report_monitor_group`
--

DROP TABLE IF EXISTS `report_monitor_group`;
CREATE TABLE `report_monitor_group` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `report_schedule`
--

DROP TABLE IF EXISTS `report_schedule`;
CREATE TABLE `report_schedule` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '	',
  `ValidFrom` bigint(20) DEFAULT NULL COMMENT '	',
  `LastRunOn` bigint(20) DEFAULT NULL,
  `IsEnabled` tinyint(1) DEFAULT NULL,
  `CreationOn` bigint(20) NOT NULL,
  `RequencyType` int(11) NOT NULL,
  `ReportDef_ID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_Report_Schedule_T_Report_Defination_T1` (`ReportDef_ID`),
  CONSTRAINT `ReportDef_ID` FOREIGN KEY (`ID`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;


--
-- Definition of table `report_subscriber_group`
--

DROP TABLE IF EXISTS `report_subscriber_group`;
CREATE TABLE `report_subscriber_group` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `report_topic`
--

DROP TABLE IF EXISTS `report_topic`;
CREATE TABLE `report_topic` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '	',
  `Monitor_GroupID` int(11) NOT NULL,
  `Usages_GroupID` int(11) NOT NULL,
  `Subscriber_GroupID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_rpt_topic_t_rpt_monitor_group_T1` (`Monitor_GroupID`),
  KEY `fk_rpt_topic_t_rpt_usages_group_t1` (`Usages_GroupID`),
  KEY `fk_rpt_topic_t_rpt_sub_group_t1` (`Subscriber_GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='	';



--
-- Definition of table `report_usages_group`
--

DROP TABLE IF EXISTS `report_usages_group`;
CREATE TABLE `report_usages_group` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `report_user`
--

DROP TABLE IF EXISTS `report_user`;
CREATE TABLE `report_user` (
  `ID` int(11) NOT NULL,
  `UserID` int(11) NOT NULL,
  `ReportDef_ID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_Report_User_T_Report_Defination_T1` (`ReportDef_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `report_view_filter`
--

DROP TABLE IF EXISTS `report_view_filter`;
CREATE TABLE `report_view_filter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `report_view_type` int(11) DEFAULT 1,
  `selected_values` varchar(1024) DEFAULT NULL ,
   CONSTRAINT chk_rpt_view_fltr_report_view_type  CHECK (report_view_type in (1,2,3)),
   CONSTRAINT pk_rpt_view_fltr_id PRIMARY KEY (`id`),
   INDEX ind_rpt_view_fltr_report_id (report_id),
   CONSTRAINT FOREIGN KEY `fk_rpt_view_fltr_report_id` (report_id) REFERENCES report_definition (id)
   ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8 COMMENT='To store report view filter details';



--
-- Definition of table `schedule_reports`
--


DROP TABLE IF EXISTS `schedule_reports`;
CREATE TABLE `schedule_reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `report_id` int(11) NOT NULL,
  `dashboard` tinyint(4) DEFAULT NULL,
  `email_destination` tinyint(4) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `email_addresses` varchar(60) DEFAULT NULL,
  `custom_layout_id` int(11) DEFAULT NULL,
  `export_format` int(11) DEFAULT '0',
  `destination` varchar(255) DEFAULT NULL,
  `dashboard_suffix` varchar(45) DEFAULT NULL,
  `frequency` int(11) DEFAULT NULL,
  `last_run_status` varchar(45) DEFAULT NULL,
  `last_run_time` timestamp NULL DEFAULT NULL,
  `is_paused` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `FK_schedule_reports_2` (`report_id`),
  KEY `FK_schedule_reports_3` (`custom_layout_id`),
  KEY `FK_schedule_reports_1` (`user_id`),
  CONSTRAINT `FK_schedule_reports_1` FOREIGN KEY (`user_id`) REFERENCES `user_details` (`id`),
  CONSTRAINT `FK_schedule_reports_2` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_schedule_reports_3` FOREIGN KEY (`custom_layout_id`) REFERENCES `custom_layout` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1033 DEFAULT CHARSET=utf8;
--
-- Definition of table `seq`
--

DROP TABLE IF EXISTS `seq`;
CREATE TABLE `seq` (
  `val` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `service_tree`
--
DROP TABLE IF EXISTS `service_tree`;

CREATE TABLE  `service_tree` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '		',
  `service_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `device_service_tree_id` int(11) NOT NULL,
  `parent_service_id` int(11) NOT NULL,
  `color_code` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_service_tree_1` (`device_service_tree_id`),
  CONSTRAINT `FK_service_tree_1` FOREIGN KEY (`device_service_tree_id`) REFERENCES `device_service_tree_mapping` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='To store the infromation of services.';

--
-- Definition of table `statistics`
--

DROP TABLE IF EXISTS `statistics`;
CREATE TABLE `statistics` (
  `stat_id` varchar(60) NOT NULL DEFAULT '0',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `value` int(11) NOT NULL DEFAULT '0',
  `alarm_state` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `topic_details`
--

DROP TABLE IF EXISTS `topic_details`;
CREATE TABLE `topic_details` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '	',
  `TopicName` varchar(128) DEFAULT NULL,
  `ParentID` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store topic and sub topic details .';



--
-- Definition of table `topic_visibility_filter`
--

DROP TABLE IF EXISTS `topic_visibility_filter`;
CREATE TABLE `topic_visibility_filter` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `VisibilityID` int(11) NOT NULL,
  `TopicID` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_rpt_visi_filter_t_visiid_visi_rights_filter_id` (`VisibilityID`),
  KEY `fk_topic_visi_filter_t_topic_details_t1` (`TopicID`),
  CONSTRAINT `topic_visibility_filter_ibfk_1` FOREIGN KEY (`VisibilityID`) REFERENCES `visibility_rights_filter` (`ID`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `topology_group`
--

DROP TABLE IF EXISTS `topology_group`;
CREATE TABLE `topology_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(50) NOT NULL,
  `group_desc` varchar(128) DEFAULT NULL,
  `group_parent_id` int(11) NOT NULL,
  `color_id` varchar(128) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='To store customized topology groups infromation.';





--
-- Definition of table `topology_group_details`
--

DROP TABLE IF EXISTS `topology_group_details`;
CREATE TABLE `topology_group_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topology_group_id` int(11) NOT NULL,
  `device_id` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_Toplogy_Group_Details_Topology_Group1` (`topology_group_id`) USING BTREE,
  KEY `fk_Toplogy_Group_Details_Device_Details_T1` (`device_id`) USING BTREE,
  CONSTRAINT `FK_topology_group_details_1` FOREIGN KEY (`topology_group_id`) REFERENCES `topology_group` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `FK_topology_group_details_2` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='to store deviceID and topology group id mapping';


--
-- Definition of table `user_accountgroup_mapping`
--

DROP TABLE IF EXISTS `user_accountgroup_mapping`;
CREATE TABLE `user_accountgroup_mapping` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` int(11) NOT NULL,
  `UserGroupID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_user_actgroup_mapping_t_userid_user_details_t_id` (`UserID`),
  KEY `fk_user_actgroup_mapping_t_userid_user_group_t_ID` (`UserGroupID`),
  KEY `FK55AF9F5E5E8A709` (`UserID`),
  KEY `FK55AF9F5EFDE570F` (`UserGroupID`),
  CONSTRAINT `FK55AF9F5E5E8A709` FOREIGN KEY (`UserID`) REFERENCES `user_details` (`id`),
  CONSTRAINT `FK55AF9F5EFDE570F` FOREIGN KEY (`UserGroupID`) REFERENCES `user_group` (`ID`),
  CONSTRAINT `user_accountgroup_mapping_ibfk_1` FOREIGN KEY (`UserID`) REFERENCES `user_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `user_accountgroup_mapping_ibfk_2` FOREIGN KEY (`UserGroupID`) REFERENCES `user_group` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



--
-- Definition of table `user_details`
--

DROP TABLE IF EXISTS `user_details`;
CREATE TABLE `user_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createdbyid` int(11) NOT NULL,
  `profileid` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `authstring` varchar(50) NOT NULL,
  `fullname` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `telephone` varchar(16) DEFAULT NULL,
  `locale` varchar(10) DEFAULT NULL,
  `user_preferenceid` int(11) DEFAULT NULL,
  `notification_flag` tinyint(1) DEFAULT '1',
  `timezoneid` int(11) DEFAULT NULL,
  `subscriber_filter` varchar(50) DEFAULT NULL,
  `description` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `fk_user_details_t_userprefid_user_pref_t_id` (`profileid`),
  KEY `timezoneid` (`timezoneid`),
  KEY `FKB7C889CEE6715119` (`profileid`),
  CONSTRAINT `FKB7C889CEE6715119` FOREIGN KEY (`profileid`) REFERENCES `user_profile` (`ID`),
  CONSTRAINT `user_details_ibfk_1` FOREIGN KEY (`profileid`) REFERENCES `user_profile` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Definition of table `user_group`
--

DROP TABLE IF EXISTS `user_group`;
CREATE TABLE `user_group` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL COMMENT 'user group name',
  `Description` varchar(128) DEFAULT NULL COMMENT 'group description flag',
  `isReportSharingAllowed` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'report sharing flag',
  `createdBy_ID` int(11) NOT NULL COMMENT 'userid of user who is creating this group',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`),
  UNIQUE KEY `Name_2` (`Name`),
  KEY `fk_User_Group_T_User_Details_T1` (`createdBy_ID`),
  KEY `FKD970E22017BD81FE` (`ID`),
  CONSTRAINT `user_group_ibfk_1` FOREIGN KEY (`createdBy_ID`) REFERENCES `user_details` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store insight v2 user group details.';


--
-- Definition of table `user_profile`
--

DROP TABLE IF EXISTS `user_profile`;
CREATE TABLE `user_profile` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(128) DEFAULT NULL,
  `CreatedBy_ID` int(11) NOT NULL COMMENT 'userid of user who is creating this profile.\n',
  `Concurrent_Session` smallint(6) NOT NULL COMMENT 'total concurrent session allowed.',
  `created_roles` tinyint(1) NOT NULL DEFAULT '0',
  `view_roles` tinyint(1) NOT NULL DEFAULT '0',
  `fullglobal_settings` tinyint(1) NOT NULL DEFAULT '0',
  `limitedglobal_settings` tinyint(1) NOT NULL DEFAULT '0',
  `create_report` tinyint(1) NOT NULL DEFAULT '0',
  `runexisting_report` tinyint(1) NOT NULL DEFAULT '0',
  `export_report` tinyint(1) NOT NULL DEFAULT '0',
  `schedule_report` tinyint(1) NOT NULL DEFAULT '0',
  `email_report` tinyint(1) NOT NULL DEFAULT '0',
  `share_favorite` tinyint(1) NOT NULL DEFAULT '0',
  `viewpublic_gallery` tinyint(1) NOT NULL DEFAULT '0',
  `publishto_publicgallery` tinyint(1) NOT NULL DEFAULT '0',
  `module_report_wizard` tinyint(1) NOT NULL DEFAULT '0',
  `module_my_favourite` tinyint(1) NOT NULL DEFAULT '0',
  `module_report_gallery` tinyint(1) NOT NULL DEFAULT '0',
  `module_account_mgmt` tinyint(1) NOT NULL DEFAULT '0',
  `module_global_settings` tinyint(1) NOT NULL DEFAULT '0',
  `create_account_group` tinyint(1) NOT NULL DEFAULT '0',
  `create_visibility` tinyint(1) NOT NULL DEFAULT '0',
  `create_account` tinyint(1) NOT NULL DEFAULT '0',
  `module_monitoring` tinyint(1) NOT NULL DEFAULT '0',
  `module_network` tinyint(1) NOT NULL DEFAULT '0',
  `monitor_application` tinyint(1) NOT NULL DEFAULT '0',
  `define_network` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`),
  KEY `fk_User_Profile_T_User_Details_T1` (`CreatedBy_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='To store insight v2 user profile information';


--
-- Definition of table `user_visibility_rights`
--

DROP TABLE IF EXISTS `user_visibility_rights`;
CREATE TABLE `user_visibility_rights` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` int(11) NOT NULL,
  `VisibilityID` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `fk_user_visibility_right_t_userID_user_details_t_id` (`UserID`),
  KEY `VisibilityID` (`VisibilityID`),
  KEY `FKD1CC54509508AFA2` (`VisibilityID`),
  KEY `FKD1CC5450E5E8A709` (`UserID`),
  CONSTRAINT `user_visibility_rights_ibfk_1` FOREIGN KEY (`VisibilityID`) REFERENCES `visibility_rights_filter` (`ID`) ON DELETE CASCADE,
  CONSTRAINT `user_visibility_rights_ibfk_2` FOREIGN KEY (`UserID`) REFERENCES `user_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;


--
-- Definition of table `visibility_rights_filter`
--

DROP TABLE IF EXISTS `visibility_rights_filter`;
CREATE TABLE  `visibility_rights_filter` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '        ',
  `SubscriberFilter` varchar(128) DEFAULT NULL COMMENT 'subscriber filter expression',
  `NetworkID` int(11) NOT NULL,
  `VisibilityName` varchar(50) DEFAULT NULL,
  `Description` varchar(50) DEFAULT NULL,
  `createdById` int(11) NOT NULL,
  `subscriberFilterEnable` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `VisibilityName` (`VisibilityName`),
  KEY `NetworkID` (`NetworkID`),
  KEY `NetworkID_2` (`NetworkID`),
  CONSTRAINT `visibility_rights_filter_ibfk_1` FOREIGN KEY (`NetworkID`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;


--
-- Definition of table `zones`
--

DROP TABLE IF EXISTS `zones`;
CREATE TABLE  `zones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zoneid` int(10) unsigned NOT NULL,
  `zone_name` varchar(50) NOT NULL,
  `zone_usages_counter` int(10) unsigned DEFAULT '0',
  `deviceid` int(11) NOT NULL DEFAULT '0',
  `color_code` varchar(12) DEFAULT NULL,
  `isselected` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `zones_ibfk_1` (`deviceid`),
  CONSTRAINT `zones_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `device` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='to store zone information';

--
-- Definition of table `report_protocol`
--

DROP TABLE IF EXISTS `report_protocol`;
CREATE TABLE `report_protocol` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `selected_protocol` varchar(50) NOT NULL,
  `service_ids` varchar(2048) DEFAULT NULL,
  `selected_smtp_option` varchar(50) DEFAULT NULL,
  `selected_pop_option` varchar(50) DEFAULT NULL,
  `rtsp_hostname_pattern` varchar(50) DEFAULT NULL,
  `retrieve_empty_rtsp_host` tinyint(1) DEFAULT '0',
  `http_signature` LONGTEXT DEFAULT NULL,
  `http_hostname_pattern` varchar(50) DEFAULT NULL,
  `retrieve_empty_http_host` tinyint(1) DEFAULT '0',
  `selected_nntp_option` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ind_rpt_proto_report_id` (`report_id`),
  CONSTRAINT `fk_rpt_proto_report_id` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='To store report protocol options';

--
-- Definition of function `getSequence`
--

DROP TABLE IF EXISTS `system_log`;
CREATE TABLE  `system_log` (
  `Message` varchar(2024) DEFAULT NULL,
  `Class` varchar(512) NOT NULL,
  `Priority` varchar(10) NOT NULL,
  `Log_Date` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74097 DEFAULT CHARSET=utf8 COMMENT='to store system level log messages';

DROP FUNCTION IF EXISTS `getSequence`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='' */ $$
CREATE FUNCTION `getSequence`() RETURNS int(11)
BEGIN
update seq set val=LAST_INSERT_ID(val+1);
return LAST_INSERT_ID();
END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
