-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.1.47-community


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;



USE insight;

--
-- Definition of table `authentication_modes`
--

DROP TABLE IF EXISTS `authentication_modes`;
CREATE TABLE authentication_modes (
 id tinyint(4) NOT NULL,
  name varchar(255) NOT NULL,
   enabled boolean,
   PRIMARY KEY (`id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Definition of table `authentication_server`
--

DROP TABLE IF EXISTS `authentication_server`;
CREATE TABLE `authentication_server` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `connection_status` boolean,    
  `description` varchar(255),
  `host` varchar(255) NOT NULL,
  `port` int(5) DEFAULT NULL,
  `secret_key` varchar(255),
  `authentication_order` int(3) DEFAULT NULL,
  `authentication_mode` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `FK_authentication_server_1` FOREIGN KEY (`authentication_mode`) REFERENCES `authentication_modes`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- alter table 'user_details' to add authentication_mode field
--

ALTER TABLE `user_details` ADD COLUMN `authentication_mode` TINYINT(4) AFTER `description`,
 ADD CONSTRAINT `FK_authentication_mode` FOREIGN KEY `FK_authentication_mode` (`authentication_mode`)
    REFERENCES `authentication_modes` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT;



--
-- Definition of table `application_tree`
--

DROP TABLE IF EXISTS `application_tree`;
CREATE TABLE  `application_tree` (
  `node_id` int(11) NOT NULL AUTO_INCREMENT,
  `node_type` int(10) unsigned NOT NULL DEFAULT '111',
  `label` varchar(128) NOT NULL DEFAULT '',
  `application_tag` bigint(20) unsigned DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `color_code` varchar(12) DEFAULT NULL,
  `p2p` smallint(6) NOT NULL DEFAULT '-1',
  `tunnel` smallint(6) NOT NULL DEFAULT '-1',
  `encrypted` smallint(6) NOT NULL DEFAULT '-1',
  `device_application_tree_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`node_id`),
  KEY `FK_application_tree_1` (`device_application_tree_id`) USING BTREE,
  CONSTRAINT `FK_application_tree_1` FOREIGN KEY (`device_application_tree_id`) REFERENCES `device_service_tree_mapping` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store application tree information';


--
-- Definition of table `device_family`
--


DROP TABLE IF EXISTS `device_family`;
CREATE TABLE  `device_family` (
  `id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `label` varchar(10) NOT NULL,
  `ini_table_name` varchar(25) NOT NULL,
  `vlink_ini_table_name` varchar(25) DEFAULT NULL,
  `supported_cm_versions` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store device family information';


--
-- Definition of table `config_color`
--

-- alter table config_color
-- add column `device_family` smallint(5) unsigned,
-- add CONSTRAINT `FK_device_3` FOREIGN KEY `FK_device_3` (`device_family`) REFERENCES `device_family` (`id`);


alter table device
add column `device_family` smallint(5) unsigned default 1,
add CONSTRAINT `FK_device_4` FOREIGN KEY `FK_device_4` (`device_family`) REFERENCES `device_family` (`id`);


--
-- Definition of table `device_type`
--

alter table `device_type`
add column `device_family` smallint(5) unsigned default 1,
add CONSTRAINT `FK_device_type_1` FOREIGN KEY `FK_device_type_1` (`device_family`) REFERENCES `device_family` (`id`) ON DELETE CASCADE;


DELIMITER $$

DROP PROCEDURE IF EXISTS `AddColumn` $$
CREATE PROCEDURE `AddColumn`(dbName text ,tableName text ,fieldName text ,fieldDef text)
BEGIN
declare count int(10);
set count=(SELECT COUNT(*) FROM information_schema.COLUMNS WHERE column_name=fieldName and table_name=tableName and table_schema=dbName);
IF count = 0 THEN
set @ddl=CONCAT('ALTER TABLE ',dbName,'.',tableName,
			' ADD COLUMN ',fieldName,' ',fieldDef);
		prepare stmt from @ddl;
		execute stmt;
End If;


END $$

DELIMITER ;

CALL AddColumn(Database(), 'report_gallery', 'original_report_id', 'int(11) DEFAULT 0');

--
-- Definition of table `local_nf_ini_values`
--

DROP TABLE IF EXISTS `local_nf_ini_values`;
CREATE TABLE  `local_nf_ini_values` (
  `time_stamp` datetime DEFAULT NULL,
  `se_ip` varchar(20) DEFAULT NULL,
  `value_type` smallint(6) DEFAULT NULL,
  `value_key` varchar(80) DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `remote_db_id` int(11) NOT NULL DEFAULT '1',
  KEY `FK_local_nf_ini_values_1` (`remote_db_id`),
  CONSTRAINT `FK_local_nf_ini_values_1` FOREIGN KEY (`remote_db_id`) REFERENCES `remote_db_param` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


alter table network
add column  `interfaces_last_sync_at` varchar(128) DEFAULT 0;
	

--
-- Definition of table `network_device_interface`
--

DROP TABLE IF EXISTS `network_device_interface`;
CREATE TABLE  `network_device_interface` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `interface_id` int(11) NOT NULL,
  `label` varchar(50) NOT NULL DEFAULT '""',
  `direction` tinyint(3) unsigned DEFAULT NULL,
  `device_id` int(11) NOT NULL,
  `monitored` tinyint(4) NOT NULL,
  `network_id` int(11) NOT NULL,
  `color_code` varchar(12) DEFAULT NULL,
  `description` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_network_device_interface_1` (`device_id`),
  KEY `FK_network_device_interface_2` (`network_id`),
  CONSTRAINT `FK_network_device_interface_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_network_device_interface_2` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='to store ASR device interface ';


--
-- Definition of table `network_application_tree`
--

DROP TABLE IF EXISTS `network_application_tree`;
CREATE TABLE `network_application_tree` (
  `node_id` int(11) NOT NULL AUTO_INCREMENT,
  `network_application_tree_id` int(11) NOT NULL DEFAULT '0',
  `node_type` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `p2p_technology` tinyint(2) DEFAULT NULL,
  `encrypted` tinyint(2) DEFAULT NULL,
  `tunneled` tinyint(2) DEFAULT NULL,
  `color_code` varchar(45) DEFAULT NULL,
  `label` varchar(100) DEFAULT NULL,
  `application_tag` BIGINT(20) DEFAULT NULL,
  PRIMARY KEY (`node_id`),
  KEY `FK_network_application_tree_1` (`network_application_tree_id`)  
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store network application tree ';

--
-- Definition for report_def_toplogy_interface
--
DROP TABLE IF EXISTS `report_def_topology_interface`;
CREATE TABLE `report_def_topology_interface` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` int(11) NOT NULL,
  `device_ip` varchar(15) NOT NULL,
  `interface_id` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ind_rpt_topology_interface` (`report_id`),
  KEY `fk_report_def_topology_plink_1` (`report_id`),
  CONSTRAINT `fk_report_def_topology_interface_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12538 DEFAULT CHARSET=utf8 COMMENT='to store the interface ids for a particular report';


--
-- Definition for report_def_application
--
DROP TABLE IF EXISTS `report_def_application`;
CREATE TABLE `report_def_application` (
  `report_id` INTEGER(11) NOT NULL DEFAULT 0,
  `category_filters` text,
  `sub_category_filters` text,
  `application_group_filters` text,
  `application_name_filters` text,
  `selected_application_ids` text,
  `p2p_technology` varchar(25),
  `tunneled` varchar(25),
  `encrypted` varchar(25),
  `granularity` varchar(25),
  PRIMARY KEY (`report_id`),
  KEY `ind_rpt_service` (`report_id`),
  KEY `FK_report_def_application_1` (`report_id`),
  CONSTRAINT `FK_report_def_application_1` FOREIGN KEY (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='store the application tree selection for a report';


--
-- Definition of table `remote_db_param`
--


alter TABLE  `remote_db_param`
add column `device_family` smallint(5) unsigned default 1,
add column `interface_sync_duration` int(10) unsigned default 5, 
add CONSTRAINT `FK_remote_db_param_1` FOREIGN KEY `FK_remote_db_param_1` (`device_family`) REFERENCES `device_family` (`id`);


ALTER TABLE `remote_db_param` 
MODIFY COLUMN `db_schema` VARCHAR(125) ;



--
-- Definition of table 'config_application_color'
--

DROP TABLE IF EXISTS `config_application_color`;
CREATE TABLE  `config_application_color` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `label` varchar(128) NOT NULL,
  `color_code` varchar(12) NOT NULL,
  `node_type` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store default color of application tree node';


--
-- Definition of table 'version'
--
DROP TABLE IF EXISTS `version`;
create table version (
id MEDIUMINT NOT NULL AUTO_INCREMENT,
version_number varchar(255),
version_desc varchar(255),
version_date timestamp,
PRIMARY KEY (id));

-- This stored procedure AddColumnInAssocReport add column in all tables whose name starts with temp_associated_report as prefix. 

DELIMITER $$

DROP PROCEDURE IF EXISTS `AddColumnInAssocReport` $$
CREATE PROCEDURE `AddColumnInAssocReport`(dbName text ,fieldName text ,fieldDef text)
BEGIN
DECLARE assoc_table_name VARCHAR(255) DEFAULT "";
DECLARE record_not_found INTEGER DEFAULT 0;

DECLARE assoc_cur CURSOR FOR SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE
TABLE_SCHEMA=dbName AND TABLE_NAME like '%temp_associated_report%';
      DECLARE CONTINUE HANDLER FOR NOT FOUND SET record_not_found = 1;
	Open assoc_cur;
			the_loop: LOOP
                FETCH assoc_cur INTO assoc_table_name;
				IF record_not_found THEN
				      LEAVE the_loop;
        END IF;
				set @ddl=CONCAT('ALTER TABLE ',dbName,'.',assoc_table_name,
						' ADD COLUMN ',fieldName,' ',fieldDef);
				prepare stmt from @ddl;
				execute stmt;
          END LOOP the_loop;
	CLOSE assoc_cur;
END $$

DELIMITER ;
-- it would add column granularity in all tables whose name starts with temp_associated_report as prefix. 
CALL AddColumnInAssocReport(database(),'granularity', 'varchar(25)');


--
-- Changing the data type for report_durtion table's date fields.
create table temp_report_duration as
select id, report_id, duration_type, last_time, last_time_unit, aggregation,
unix_timestamp(start_date) as start_date, unix_timestamp(end_date) as end_date,
use_device_time_zone,last_time_selected  from report_duration;

delete from report_duration;

ALTER TABLE `report_duration` MODIFY COLUMN `start_date` BIGINT(13) unsigned DEFAULT NULL;
ALTER TABLE `report_duration` MODIFY COLUMN `end_date` BIGINT(13) unsigned DEFAULT NULL;

insert into report_duration select * from temp_report_duration;

drop table temp_report_duration;

-- Report Duration Changes end.

-- Alter Statements to remove the on delete cascade from report_definition table
ALTER TABLE `report_definition` DROP FOREIGN KEY `network_id`;
ALTER TABLE `report_definition` ADD CONSTRAINT `network_id` FOREIGN KEY `network_id` (`network_id`)
REFERENCES `network` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION;