-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.1.47-community


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


USE insight;

--
-- Definition of table `topology_view`
--

DROP TABLE IF EXISTS `topology_view`;
CREATE TABLE `topology_view` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `network_id` int(50),
  `topology_label` varchar(128) DEFAULT NULL,
  `is_selected` tinyint(1),
    PRIMARY KEY (`id`),
	CONSTRAINT `FK_topology_group_item_1` FOREIGN KEY (`network_id`) REFERENCES `network` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='To store customized topology views infromation.';


-- Schema for device VRF table

DROP TABLE IF EXISTS `device_vrf_details`;
CREATE TABLE `device_vrf_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vrf_id` int(11) NOT NULL,
  `label` varchar(50) NOT NULL DEFAULT '""',
  `device_id` int(11) NOT NULL,
  `device_long_ip` bigint(21)  NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_ device_vrf_details _1` (`device_id`),
  CONSTRAINT `FK_device_vrf_details_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='to store VRF ids ';



DROP TABLE IF EXISTS `interface_topology_group`;
CREATE TABLE  `interface_topology_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `interface_group_name` varchar(50) NOT NULL,
  `interface_group_desc` varchar(128) DEFAULT NULL,
  `interface_group_parent_id` int(11) NOT NULL,
  `color_id` varchar(12) NOT NULL,
  `pref_selected` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `monitored_selected` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='To store customized interface topology groups infromation.';

DROP TABLE IF EXISTS `interface_topology_group_details`;
CREATE TABLE  `interface_topology_group_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `interface_topology_group_id` int(11) NOT NULL,
  `interface_device_id` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `fk_Interface_Toplogy_Group_Details_Topology_Group1` (`interface_topology_group_id`) USING BTREE,
  CONSTRAINT `FK_Interface_topology_group_details_1` FOREIGN KEY (`interface_topology_group_id`) REFERENCES `interface_topology_group` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='to store interface deviceID and topology group id mapping';


 ALTER TABLE network
 DROP COLUMN `interfaces_last_sync_at`;
 
 ALTER TABLE `network`
 ADD COLUMN `interface_topology_group_id` INTEGER default 0;
 
 
 ALTER TABLE `network_device_item`
 ADD COLUMN `pref_selected` tinyint(3) unsigned NOT NULL default 1;
 
  ALTER TABLE `remote_db_param`
 ADD COLUMN `interfaces_last_sync_at` BIGINT default 0;
 
DROP TABLE IF EXISTS `device_interface`;
CREATE TABLE  `device_interface` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `interface_id` int(11) NOT NULL,
  `label` varchar(128) NOT NULL DEFAULT '""',
  `direction` tinyint(3) unsigned DEFAULT NULL,
  `device_id` int(11) NOT NULL,
  `monitored` tinyint(4) NOT NULL,
  `color_code` varchar(12) DEFAULT NULL,
  `description` varchar(50) NOT NULL,
  `ip_address` varchar(15) DEFAULT '10.10.10.111',
  PRIMARY KEY (`id`),
  KEY `FK_device_interface_1` (`device_id`),
  CONSTRAINT `FK_device_interface_1` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='to store ASR device interface ';


--
-- Added for Network Upgradation

create table temp_network_device_interface as
select n.id, n.interface_id, n.label, n.direction, n.device_id, n.monitored,
n.color_code, n.description ,d.ip_address,n.network_id from network_device_interface  n, device d  where  n.device_id=d.id ;

insert into device_interface select id, interface_id, label, direction, device_id, monitored,
color_code, description ,ip_address from temp_network_device_interface;

DROP TABLE IF EXISTS `network_device_interface`;
CREATE TABLE  `network_device_interface` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `network_id` int(11) NOT NULL,
  `interface_id` int(11) NOT NULL,
  `device_id` int(11)  DEFAULT NULL,
  `monitored_selected` tinyint(3) unsigned NOT NULL,
  `pref_selected` tinyint(3) unsigned NOT NULL,
  `color_code` varchar(12) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_network_device_interface_2` (`network_id`),
  KEY `FK_network_device_interface_1` (`interface_id`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='to store ASR device interface ';


DELIMITER $$

DROP PROCEDURE IF EXISTS `InsertInterfaceTopology` $$
CREATE PROCEDURE `InsertInterfaceTopology`()
BEGIN
			DECLARE net_id INTEGER DEFAULT 0;
			DECLARE int_topology_group_id INTEGER DEFAULT 0;
			DECLARE   device_interface_id INTEGER DEFAULT 0;
			DECLARE   interface_id INTEGER DEFAULT 0;
			DECLARE   device_id INTEGER DEFAULT 0;
			DECLARE   color_code varchar(12) DEFAULT null;
			DECLARE   monitored INTEGER DEFAULT 0;

			DECLARE b INTEGER DEFAULT 0;
			DECLARE record_not_found INTEGER DEFAULT 0;

      DECLARE cur2 CURSOR FOR SELECT distinct d.interface_id,d.device_id,d.color_code,d.monitored
      FROM device_interface d,temp_network_device_interface t
      where d.device_id=t.device_id and d.interface_id=t.interface_id and t.network_id=network_id and t.direction = d.direction;


			DECLARE cur1 CURSOR FOR SELECT DISTINCT network_id FROM temp_network_device_interface ;
			DECLARE CONTINUE HANDLER FOR NOT FOUND SET record_not_found = 1;

			OPEN cur1;
				first_read_loop: LOOP
				FETCH cur1 INTO net_id;

				IF record_not_found THEN
					LEAVE first_read_loop;
				END IF;

				insert into interface_topology_group select n.id, n.name,n.description,-1,"#FF0000",1,1 from network n where n.id=net_id;

				SELECT id INTO int_topology_group_id from interface_topology_group where interface_group_name= (select name from network where id=net_id);

				update network set interface_topology_group_id = int_topology_group_id where id=net_id;

      		OPEN cur2;
				second_read_loop: LOOP
				FETCH cur2 INTO interface_id,device_id,color_code,monitored;
				IF record_not_found THEN
					LEAVE second_read_loop;
				END IF;
				
 			SELECT d.id into device_interface_id
       FROM device_interface d
       where d.device_id=device_id and d.interface_id=interface_id limit 1;

				    insert into interface_topology_group_details(interface_topology_group_id,interface_device_id)
            values (int_topology_group_id,device_interface_id);
				    insert into network_device_interface(network_id,interface_id,device_id,monitored_selected,pref_selected,color_code) values (net_id,interface_id,device_id,1,1,color_code);

			  END LOOP second_read_loop;
			  CLOSE cur2;


			  END LOOP first_read_loop;
		  CLOSE cur1;
		 END $$

DELIMITER ;

call InsertInterfaceTopology();

drop table temp_network_device_interface;

DELIMITER $$

DROP PROCEDURE IF EXISTS `InsertTopologyView_Group` $$
CREATE PROCEDURE `InsertTopologyView_Group`()
BEGIN
			DECLARE netid INTEGER DEFAULT 0;			
			DECLARE int_top_id INTEGER DEFAULT 0;			
			DECLARE device_family_id INTEGER DEFAULT 0;	

			DECLARE record_not_fnd INTEGER DEFAULT 0;
			DECLARE cur CURSOR FOR SELECT DISTINCT id,interface_topology_group_id FROM network;
			DECLARE CONTINUE HANDLER FOR NOT FOUND SET record_not_fnd = 1;

			OPEN cur;
				read_loop: LOOP
				FETCH cur INTO netid,int_top_id;
				
				IF record_not_fnd THEN
					LEAVE read_loop;
				END IF;

				SELECT device_family into device_family_id from remote_db_param where id= (select remote_db_id from network where id=netid);
				IF device_family_id = 2 THEN
					INSERT INTO `topology_view` (`network_id`,`topology_label`,`is_selected`) VALUES
					 (netid,'devices',0),
					 (netid,'customTopology',1),
					 (netid,'customInterfaceTopology',0);
				END IF;
				
				
				IF int_top_id = 0 and device_family_id = 2 THEN						
					insert into interface_topology_group select n.id, n.name,n.description,-1,"#FF0000",1,1 from network n where n.id=netid;
					update network n set interface_topology_group_id = n.id where id=netid;
				END IF;	
				
				
				
			  END LOOP read_loop;
		  CLOSE cur;
		 END $$
DELIMITER ;

call InsertTopologyView_Group();



DELIMITER $$

DROP PROCEDURE IF EXISTS `updateLastRuntime` $$
CREATE PROCEDURE `updateLastRuntime`()
BEGIN
			DECLARE last_run varchar(12) DEFAULT null;
			DECLARE s_id INTEGER DEFAULT 0;
			DECLARE record_not_fnd INTEGER DEFAULT 0;
			DECLARE cur CURSOR FOR SELECT id, last_run_status FROM schedule_reports;
			DECLARE CONTINUE HANDLER FOR NOT FOUND SET record_not_fnd = 1;
			
			OPEN cur;
				read_loop: LOOP
				FETCH cur INTO s_id,last_run;
				
				IF record_not_fnd THEN
					LEAVE read_loop;
				END IF;

				IF last_run = "Never Run" THEN											
					update schedule_reports s set last_run_time =null where id=s_id;
				END IF;								
				
			  END LOOP read_loop;
		  CLOSE cur;
END $$
DELIMITER ;

call updateLastRuntime();



ALTER TABLE `device`
 ADD COLUMN `aggregation_interval` smallint(5) default 0;
 
 ALTER TABLE `topology_group`
 ADD COLUMN `pref_selected` tinyint(3) unsigned NOT NULL DEFAULT '1',ADD COLUMN `monitored_selected` tinyint(3) unsigned NOT NULL DEFAULT '1';
 
 ALTER TABLE `topology_group_details`
 ADD COLUMN `pref_selected` tinyint(3) unsigned NOT NULL DEFAULT '1',ADD COLUMN `monitored_selected` tinyint(3) unsigned NOT NULL DEFAULT '1';

ALTER TABLE `report_def_application` MODIFY COLUMN `granularity` VARCHAR(100) DEFAULT NULL;
ALTER TABLE `report_def_topology` MODIFY COLUMN `topology_type` VARCHAR(100) DEFAULT NULL;

-- Merge Changes -----
ALTER TABLE custom_layout MODIFY COLUMN description TEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL;
ALTER TABLE report_definition MODIFY COLUMN description TEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL;
ALTER TABLE report_def_topology MODIFY COLUMN topology_in_clause_ids TEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL;
ALTER TABLE schedule_reports MODIFY COLUMN description TEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL;
CALL AddColumn(Database(), 'visibility_rights_filter', 'packageFilterEnable', 'TINYINT(3)  DEFAULT 0');

-- Alter Statements for report topology tables --
ALTER TABLE `report_def_topology_interface` DROP FOREIGN KEY `fk_report_def_topology_interface_1`;

ALTER TABLE `report_def_topology_interface` ADD CONSTRAINT `fk_report_def_topology_interface_1` FOREIGN KEY `fk_report_def_topology_interface_1` (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE NO ACTION;

ALTER TABLE `report_def_topology_plink` DROP FOREIGN KEY `fk_report_def_topology_plink_1`;

ALTER TABLE `report_def_topology_plink` ADD CONSTRAINT `fk_report_def_topology_plink_1` FOREIGN KEY `fk_report_def_topology_plink_1` (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE NO ACTION;

ALTER TABLE `report_def_topology_vlink` DROP FOREIGN KEY `fk_report_def_topology_vlink_1`;

ALTER TABLE `report_def_topology_vlink` ADD CONSTRAINT `fk_report_def_topology_vlink_1` FOREIGN KEY `fk_report_def_topology_vlink_1` (`report_id`) REFERENCES `report_definition` (`id`) ON DELETE NO ACTION;

-- Alter Statements for report topology tables end ---

-- Alter Table for report_gallery --
ALTER TABLE `report_gallery` MODIFY COLUMN `id` INT(11) NOT NULL;
ALTER TABLE `report_gallery` MODIFY COLUMN `id` INT(11) NOT NULL DEFAULT 0;

-- Alter Table for device to store sampling_interval--
ALTER TABLE `device` ADD COLUMN `sampling_interval` INTEGER DEFAULT 1 ;

-- Alter Table for user_profile to store share_role--
ALTER TABLE `user_profile` ADD COLUMN `share_role` BOOLEAN NOT NULL;

-- Alter Table for report_def_topology_vlink to store label--    
CALL AddColumn(Database(), 'report_def_topology_vlink', 'label', 'VARCHAR(100)');

-- Alter Table for custom_layout to store createdBy value (true or false) --   
ALTER TABLE `custom_layout` ADD COLUMN `createdBy` BOOLEAN;