#!/bin/sh
#if [ -f .conf/user_answers.txt ]; then
#	rm -f .conf/user_answers.txt
#fi

checkschemavalidity(){
	
	schema_len=$(echo ${#NEW_DB_SCHEMA_NAME})
	
	mysql -uroot -p$INSTALLED_MYSQL_ROOT_PASSWORD $NEW_DB_SCHEMA_NAME < .pkgrpm/quit.sql > /dev/null 2>&1 				
		if [ $? -eq 0 ]; then
			echo "MSG : schema [ $NEW_DB_SCHEMA_NAME ] already exists."					
			return;
		fi

		if [ $schema_len -ge 17 ];then 
		echo "MSG: Database schema name length should be less than or equal to 16. "
		return;
		fi
	echo "true"
}

createSQLFiles()
{
	old_db_name=DB
	new_db_name=$1
	old_quartz_db_name=QUARTZ
	new_quartz_db_name=$2
	old_root_password=password
	new_root_password=$3
	old_user_name=MYSQL_USER
	new_user_name=$4

	sed -e s:$old_quartz_db_name:$new_quartz_db_name:g .pkgrpm/user_mysql.sql > .pkgrpm/user_mysql_$new_db_name.sql

	if [ "${old_root_password}" != "${new_root_password}" ]; then
		sed -e s:$old_root_password:$new_root_password:g .pkgrpm/user_mysql_$new_db_name.sql > .pkgrpm/temp_user_mysql_$new_db_name.sql
		mv .pkgrpm/temp_user_mysql_$new_db_name.sql .pkgrpm/user_mysql_$new_db_name.sql
	fi

	sed -e s:$old_user_name:$new_user_name:g .pkgrpm/user_mysql_$new_db_name.sql > .pkgrpm/temp_user_mysql_$new_db_name.sql
	mv .pkgrpm/temp_user_mysql_$new_db_name.sql .pkgrpm/user_mysql_$new_db_name.sql

	sed -e s:$old_db_name:$new_db_name:g .pkgrpm/user_mysql_$new_db_name.sql > .pkgrpm/temp_user_mysql_$new_db_name.sql
	mv .pkgrpm/temp_user_mysql_$new_db_name.sql .pkgrpm/user_mysql_$new_db_name.sql

       	sed -e s:$old_quartz_db_name:$new_quartz_db_name:g .pkgrpm/delete_schema.sql > .pkgrpm/delete_schema_$new_db_name.sql

	sed -e s:$old_user_name:$new_user_name:g .pkgrpm/delete_schema_$new_db_name.sql > .pkgrpm/temp_delete_schema_$new_db_name.sql
	mv .pkgrpm/temp_delete_schema_$new_db_name.sql .pkgrpm/delete_schema_$new_db_name.sql

	sed -e s:$old_db_name:$new_db_name:g .pkgrpm/delete_schema_$new_db_name.sql > .pkgrpm/temp_delete_schema_$new_db_name.sql
	mv .pkgrpm/temp_delete_schema_$new_db_name.sql .pkgrpm/delete_schema_$new_db_name.sql

	if [ "insight" != "${new_db_name}" ]; then
		insight_ver=`cat .pkgrpm/tbl_ver.txt | grep -w insight_files | cut -d '=' -f 2`
		if [ ${#insight_ver} -ne 0 ]; then
			IFSsave="$IFS"
			IFS=,
			insight_vers=( $insight_ver )
			IFS="$IFSsave"
			for((i=0;i<${#insight_vers[@]};i++))
			do
				if [ -f .pkgrpm/insight_${insight_vers[i]}.sql ]; then
				sed -e s:insight:$new_db_name:g .pkgrpm/insight_${insight_vers[i]}.sql > .pkgrpm/${new_db_name}_${insight_vers[i]}.sql	
				fi
			done
		fi
	fi

	if [ "insight" != "$new_quartz_db_name" ]; then
		quartz_ver=`cat .pkgrpm/tbl_ver.txt | grep -w quartz_files | cut -d '=' -f 2`
		if [ ${#quartz_ver} -ne 0 ]; then
			IFSsave="$IFS"
			IFS=,
			quartz_vers=( $quartz_ver )
			IFS="$IFSsave"
			for((i=0;i<${#quartz_vers[@]};i++))
			do
				if [ -f .pkgrpm/quartz_${quartz_vers[i]}.sql ]; then
				sed -e s:insight_quartz:$new_quartz_db_name:g .pkgrpm/quartz_${quartz_vers[i]}.sql > .pkgrpm/${new_quartz_db_name}_${quartz_vers[i]}.sql
				fi
			done
		fi
	fi

	data_ver=`cat .pkgrpm/tbl_ver.txt | grep -w system_data_files | cut -d '=' -f 2`
	if [ ${#data_ver} -ne 0 ]; then
		IFSsave="$IFS"
		IFS=,
		data_vers=( $data_ver )
		IFS="$IFSsave"
		for((i=0;i<${#data_vers[@]};i++))
		do
			if [ -f .pkgrpm/system_data_${data_vers[i]}.sql ]; then
			sed -e s:insight:$new_db_name:g .pkgrpm/system_data_${data_vers[i]}.sql > .pkgrpm/system_data_${new_db_name}_${data_vers[i]}.sql
			fi
		done
	fi

}
if [ -f .conf/user_answers.txt ]; then 
SILENT_INSTALLATION=`cat .conf/user_answers.txt | grep -w SILENT_INSTALLATION | cut -d '=' -f 2`
fi
if [ ${#SILENT_INSTALLATION} -eq 0 ]; then

/usr/java/jre1.6.0_22/bin/java -version 2>&1 |cat  > jre
contr=(`more jre | awk '{print $3}' |grep \"1 | sed -e s:\"::g`)
jre=(`echo ${contr:0:3}`)
if [ "$jre" = "1.6" ]; then

	IS_OPEN_JAVA=`/usr/java/jre1.6.0_22/bin/java -version 2>&1 | grep -i "Open"`
	if [ ${#IS_OPEN_JAVA} -eq 0 ]; then
		echo " "
	else
		echo "Warning : Existing Open JDK/JRE package found on the System. Please remove it before before proceeding with the installation of Insight Reporter!"
		echo "Use 'rpm -e {library}' command to uninstall the package!"
		exit 1
	fi
	
	IS_SUN_JAVA=`/usr/java/jre1.6.0_22/bin/java -version 2>&1 | grep -i "HotSpot"`
	if [ ${#IS_SUN_JAVA} -eq 0 ]; then
		echo "MSG : Sun Java HotSpot(TM) JRE6 is required"
		echo -n "INPUT : Do you want to install JRE6? [Y/N] (default Y): "
		read INSTALL_JRE
		if [ "$INSTALL_JRE" = "N" -o "$INSTALL_JRE" = "n" ]; then
			echo "INSTALL_JRE=N" >> .conf/user_answers.txt
		else
			echo "INSTALL_JRE=Y" >> .conf/user_answers.txt
		fi
	else
		echo "JAVA_HOME=/usr/java/jre1.6.0_22" >> .conf/profile
	fi
else
	echo "MSG : Sun Java HotSpot(TM) JRE6 is required"
	echo -n "INPUT : Do you want to install JRE6? [Y/N] (default Y): "
	read INSTALL_JRE
	if [ "$INSTALL_JRE" = "N" -o "$INSTALL_JRE" = "n" ]; then
		echo "INSTALL_JRE=N" >> .conf/user_answers.txt
	else
		echo "INSTALL_JRE=Y" >> .conf/user_answers.txt
	fi
fi
fi
if [ ${#SILENT_INSTALLATION} -eq 0 ]; then
version_number=`cat .pkgrpm/tbl_ver.txt | grep -w version_number | cut -d '=' -f 2`
rc_number=`cat .pkgrpm/tbl_ver.txt | grep -w rc_number | cut -d '=' -f 2`

mysql --version >/dev/null 2>&1
if [ $? -eq 0 ]; then
	contr=(`mysql --version | awk '{print $5}' | sed s:,::g`)
	controllo=(`echo ${contr:0:3}`)
	if [ "$controllo" = "5.6" ]; then
	#if [ "$controllo" = "5.1" ]; then
		if [ -f .pkgrpm/silent_user_answers.txt ]; then 
			DEFAULT_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
			INSTALLED_MYSQL_ROOT_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`
		fi
	
		echo -n "INPUT : An existing v5.6 installation MySQL was found on your system. Do you want to use it to install Cisco Insightv$version_number $rc_number? [Y/N] (default Y): "
		#echo -n "INPUT : An existing v5.1 installation MySQL was found on your system. Do you want to use it to install Cisco Insightv$version_number $rc_number? [Y/N] (default Y): "
		read USE_INSTALLED_MYSQL
		if [ "$USE_INSTALLED_MYSQL" = "N" -o "$USE_INSTALLED_MYSQL" = "n" ]; then
			echo "USE_INSTALLED_MYSQL=N" >> .conf/user_answers.txt
		else
			echo "USE_INSTALLED_MYSQL=Y" >> .conf/user_answers.txt
			#echo -n "INPUT : Enter the root password for MySQL: "
			#stty -echo
			#read INSTALLED_MYSQL_ROOT_PASSWORD
			#stty echo

version_comment=`query="SHOW VARIABLES WHERE Variable_name='version_comment'"
mysql -uroot -p$INSTALLED_MYSQL_ROOT_PASSWORD --skip-column-names << eof
$query
eof`
if [ $? -ne 0 ];then
	echo "MSG : Installation was unable to connect to MySql server due to one of the following reasons"
	echo "1. Firewall is enabled and not configured to allow access to port 3306"
	echo "2. SE Linux is enabled and blocking access to port 3306"
	echo "3. MySql root password is not compatible with Insight reporter."
	exit 1;
fi
				
				echo "$version_comment" | grep 'MySQL Enterprise Server' &> /dev/null
				if [ $? == 0 ]; then
					echo ""
					echo "DEFAULT_ID=$DEFAULT_PASSWORD" >> .conf/user_answers.txt
					echo -n "INPUT : Enter schema name for insight local database(default is insight):"
					read NEW_DB_SCHEMA_NAME		
			
					value="false"
					while [ "true"  != "$value" ]
					do
					if [ ${#NEW_DB_SCHEMA_NAME} -eq 0 ]; then
						NEW_DB_SCHEMA_NAME="insight"				
					fi
						value=$(checkschemavalidity)	
					if [  "$value" != "true" ];then 
						echo "$value"
						echo -n "INPUT : Enter schema name for insight local database(default is insight):"
						read NEW_DB_SCHEMA_NAME			
					fi

					done
					echo "NEW_DB_SCHEMA_NAME=$NEW_DB_SCHEMA_NAME" >> .conf/user_answers.txt		
			
					echo "NEW_QUARTZ_DB_SCHEMA_NAME=${NEW_DB_SCHEMA_NAME}_quartz" >> .conf/user_answers.txt
					createSQLFiles "$NEW_DB_SCHEMA_NAME" "${NEW_DB_SCHEMA_NAME}_quartz" "$INSTALLED_MYSQL_ROOT_PASSWORD" "$NEW_DB_SCHEMA_NAME"
				else
					echo "An existing MySQL installation is detected on your system which is not compatible with Cisco Insight Reporter. Please use MySQL Enterprise Server - Advanced Edition (Commercial) only packaged with installation package."
					exit 1;				
				fi
			
		fi	
		
	fi
	
else

	var=`rpm -qa | grep mysql`
	if [ $? -eq 0 ]; then
		echo "Warning : Existing MySQL package found on the System. Please remove it before before proceeding with the installation of Insight Reporter!"
		echo "MySQL Package: $var"
		echo "Use 'rpm -e {library}' command to uninstall the package!"
		exit 1
	fi

	echo -n "INPUT : Do you want to install MySQL server? [Y/N] (default Y): "
	read INSTALL_MYSQL
	if [ "$INSTALL_MYSQL" = "N" -o "$INSTALL_MYSQL" = "n" ]; then
		echo "INSTALL_MYSQL=N" >> .conf/user_answers.txt
	else
		echo "INSTALL_MYSQL=Y" >> .conf/user_answers.txt
		until [ ${#MYSQL_DATA_DIR} -ne 0 ]
		do
			echo -n "INPUT : Enter MySQL data directory applicable for your installation(example /home/mysql-data/): "
			read MYSQL_DATA_DIR
			if [ ${#MYSQL_DATA_DIR} -eq 0 ]; then
				echo "MSG : Please enter a valid value of the MySQL data directory"
			else
				echo "MYSQL_DATA_DIR=$MYSQL_DATA_DIR" >> .conf/user_answers.txt
				break
			fi
		done
		createSQLFiles "insight" "insight_quartz" "password" "insight_admin"
	fi
 fi
 else
 NEW_DB_SCHEMA_NAME=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
 NEW_QUARTZ_DB_SCHEMA_NAME=`cat .conf/user_answers.txt | grep -w NEW_QUARTZ_DB_SCHEMA_NAME | cut -d '=' -f 2`
 DEFAULT_PASSWORD=`cat .conf/user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
 INSTALLED_MYSQL_ROOT_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`
 #INSTALLED_MYSQL_ROOT_PASSWORD=`cat .conf/user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
 createSQLFiles "$NEW_DB_SCHEMA_NAME" "$NEW_QUARTZ_DB_SCHEMA_NAME" "$INSTALLED_MYSQL_ROOT_PASSWORD" "$NEW_DB_SCHEMA_NAME"
fi
