#!/bin/sh

if [ -f insight.sql ]; then
if [ -r insight.sql ]; then
echo ""
else
echo "MSG : Cannot delete sql file"
exit 1
fi
fi

if [ -f insight_quartz.sql ]; then
if [ -r insight_quartz.sql ]; then
echo ""
else
echo "MSG : Cannot delete sql file"
exit 1
fi
fi

usrname=`cat .backup/properties/insight.properties | grep -w jdbc.username | cut -d '=' -f 2`
passwrd=`cat .backup/properties/insight.properties | grep -w jdbc.password | cut -d '=' -f 2`
if [ ${#passwrd} -ne 0 ]; then

	INSIGHT_DB=`cat .conf/user_answers.txt | grep -w INSIGHT_DB | cut -d '=' -f 2`
	INSIGHT_QUARTZ_DB=`cat .conf/user_answers.txt | grep -w INSIGHT_QUARTZ_DB | cut -d '=' -f 2`
	if [ ${#INSIGHT_DB} -ne 0 ]; then
		/usr/bin/mysqldump --user=$usrname --password=$passwrd $INSIGHT_DB > .backup/db/insight.sql
		/usr/bin/mysqldump --user=$usrname --password=$passwrd  $INSIGHT_QUARTZ_DB > .backup/db/insight_quartz.sql
	else
		echo "MSG : Insight database not found"
		exit 1
	fi
else
	echo "MSG : Mysql root password is not valid in insight.properties"
	exit 1
fi

