#!/bin/bash
mysql --version >/dev/null 2>&1
if [ $? -eq 0 ]; then
	contr=(`mysql --version | awk '{print $5}' | sed s:,::g`)
	controllo=(`echo ${contr:0:3}`)
	if [ "$controllo" \< "5.6" ]; then	
	#if [ "$controllo" \< "5.1" ]; then			
		echo "Warning : Installed MySql version is not compatible with this Insight release. You need to upgrade MySql server to 5.6. "
		echo "Upgrade will remove existing users in MySql server except Insight user:"
		echo -n "Do you want to upgrade MySql Server to 5.6.? [Y/N] (default Y): "
		read INSTALL_MSQ
		
		
		if [ "$INSTALL_MSQ" = "N" -o "$INSTALL_MSQ" = "n" ]; then
			echo "Now exiting"
			exit 1
		else
		echo "Enter  MySql root password"
		stty -echo
		read MSQ_PASS
		stty echo
		
		version_comment=`query="SHOW VARIABLES WHERE Variable_name='version_comment'"
mysql -uroot -p$MSQ_PASS --skip-column-names << eof
$query
eof`

if [ $? -ne 0 ]; then
		echo "MSG : Installation was unable to connect to MySql server due to one of the following reasons"
		echo "1. Firewall is enabled and not configured to allow access to port 3306"
		echo "2. SE Linux is enabled and blocking access to port 3306"
		echo "3. Invalid MySql root password"
		exit 1
	fi
		#rm -rf /root/.mysql_secret
		#echo "# The random password set for the root user at Tue Feb 18 11:57:15 2014 (local time):$MSQ_PASS" > /root/.mysql_secret
		
		usrname=`cat .backup/properties/insight.properties | grep -w jdbc.username | cut -d '=' -f 2`
		passwrd=`cat .backup/properties/insight.properties | grep -w jdbc.password | cut -d '=' -f 2`	
		
		update_schema=`query="UPDATE device SET device_type_id ='1' WHERE device_type_id <>'1'"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names $insight_db<< eof
$query
eof`

		echo "MSG : Model type has been changed to 'SCE' successfully ."
		
		/etc/init.d/mysql stop
			#echo "Client"
		CLIENT_NAME=`rpm -qa | grep  MySQL| grep -w client`

		#echo "Server"
		SERVER_NAME=`rpm -qa | grep  MySQL| grep -w server`

		if [ ${#CLIENT_NAME} -ne 0 ]; then
			echo "Uninstalling Client: $CLIENT_NAME"
			rpm -e --nodeps $CLIENT_NAME
		fi


		if [ ${#SERVER_NAME} -ne 0 ]; then
			echo "Uninstalling Server(Will take some time): $SERVER_NAME"
			rpm -e --nodeps $SERVER_NAME
		fi
		
		rm -rf /root/.mysql_secret
		mysql_client=`ls .pkgrpm/|grep "MySQL-client*"`
		mysql_server=`ls .pkgrpm/|grep "MySQL-server*"`
		rpm -ivh .pkgrpm/$mysql_client
		rpm -ivh .pkgrpm/$mysql_server
		/etc/init.d/mysql start
		
		if [ $? -ne 0 ]; then
					rpm -e MySQL-server-advanced-5.6.13-1.rhel5.x86_64
					rpm -e MySQL-client-advanced-5.6.13-1.rhel5.x86_64
					#rpm -e MySQL-client-advanced-5.1.51-1.rhel5
					#rpm -e MySQL-server-advanced-5.1.51-1.rhel5
					rm -rf $ans
					rm -rf /var/run/mysqld/
					rm -rf /var/lib/mysql/
					rm -f /var/log/mysqld.log
					rm -f /etc/my.cnf
					rm -rf /root/.mysql_secret
					rm -f /usr/my.cnf
					MYSQL_EXISTS=`cat /etc/passwd | grep -w mysql`
					if [ ${#MYSQL_EXISTS} -ne 0 ]; then
						userdel -rf mysql > /dev/null 2>&1
					fi
					echo "MSG : Installation was unable to start mysql daemon due to one of the following reasons"
					echo "1. Firewall is enabled and not configured to allow access to port 3306"
					echo "2. SE Linux is enabled and blocking access to port 3306"
					echo "3. Socket already in use"
					exit 1
				fi
			sleep 3
		DEFAULT_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
		NEW_MYSQL_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`
		#NEW_MYSQL_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
		stty echo
		#echo "NEW_MYSQL_PASSWORD: $NEW_MYSQL_PASSWORD"
		change_password=`query="set password = PASSWORD('$NEW_MYSQL_PASSWORD')"
mysql -uroot -p$MSQ_PASS --connect-expired-password << eof
$query
eof`		

echo "Running Mysql upgrade....."
mysql_upgrade -uroot -p$NEW_MYSQL_PASSWORD > .conf/MysqlUpgrade.txt

update_password=`query="UPDATE mysql.user SET Password=PASSWORD('$NEW_MYSQL_PASSWORD') WHERE User='root'"
mysql -uroot -p$NEW_MYSQL_PASSWORD  << eof
$query
eof`
	
grant_access=`query="GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED BY '$NEW_MYSQL_PASSWORD' WITH GRANT OPTION"
mysql -uroot -p$NEW_MYSQL_PASSWORD  << eof
$query
eof`
		
		echo "INSTALLED_MYSQL_ROOT_PASSWORD=$NEW_MYSQL_PASSWORD" >> .conf/user_answers.txt		
		fi
	fi
#else	
		#echo "ERROR : Installed Cisco Insight Reporter is corrupted due to one of the following reasons, please install fresh copy of Cisco Insight Reporter."
		#echo "1. MySql is not installed or Installed MySql is older version (less than 5.1)."
		#echo "2. JRE6 is not installed."
		#exit 1;
fi

/usr/java/jre1.6.0_22/bin/java -version 2>&1 |cat  > jre
contr=(`more jre | awk '{print $3}' |grep \"1 | sed -e s:\"::g`)
jre=(`echo ${contr:0:3}`)

if [ "$jre" = "1.6" ]; then
	IS_SUN_JAVA=`/usr/java/jre1.6.0_22/bin/java -version 2>&1 | grep -i "HotSpot"`
	if [ ${#IS_SUN_JAVA} -eq 0 ]; then		
		echo "ERROR : Installed Cisco Insight Reporter is corrupted due to one of the following reasons, please install fresh copy of Cisco Insight Reporter."
		echo "1. either MySql is not installed or Installed MySql is older version (less than 5.1)."
		echo "2. Java HotSpot(TM) JRE6 is not installed."
		exit 1;
	fi
else	
		echo "ERROR : Installed Cisco Insight Reporter is corrupted due to one of the following reasons, please install fresh copy of Cisco Insight Reporter."
		echo "1. either MySql is not installed or Installed MySql is older version (less than 5.1)."
		echo "2. Java HotSpot(TM) JRE6 is not installed."
		exit 1;
fi
