#!/bin/sh


mysql --version >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		contr=(`mysql --version | awk '{print $5}' | sed s:,::g`)
		controllo=(`echo ${contr:0:3}`)
		if [ "$controllo" = "5.6" ]; then
		#if [ "$controllo" = "5.1" ]; then
			RIS=`cat .conf/user_answers.txt | grep -w USE_INSTALLED_MYSQL | cut -d '=' -f 2`
			if [ "$RIS" = "N" -o "$RIS" = "n" ]; then
				echo "MSG : MySql is required to complete the installation of Cisco Insight. Please refer to the Installation guide for further details. Now exiting."
				exit 1
			else
				DEFAULT_PASSWORD=`cat .conf/user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
				passwd=`echo $DEFAULT_PASSWORD | base64 --decode -i`
				#passwd=`cat .conf/user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
				#echo "password: $passwd"
				if [ ${#passwd} -ne 0 ]; then
					#mysqladmin --user=root --password=$passwd version > /dev/null 2>&1
					if [ $? -ne 0 ]; then
						echo "MSG : Installation was unable to connect to MySql server due to one of the following reasons"
						echo "1. Firewall is enabled and not configured to allow access to port 3306"
						echo "2. SE Linux is enabled and blocking access to port 3306"
						echo "3. Invalid MySql root password"
						exit 1
					fi
					newdbschema=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
					newquartzdbschema=`cat .conf/user_answers.txt | grep -w NEW_QUARTZ_DB_SCHEMA_NAME | cut -d '=' -f 2`

					mysql --user=root --password=$passwd < .pkgrpm/user_mysql_${newdbschema}.sql
					
					insight_ver=`cat .pkgrpm/tbl_ver.txt | grep -w insight_files | cut -d '=' -f 2`
					if [ ${#insight_ver} -ne 0 ]; then
						IFSsave="$IFS"
						IFS=,
						insight_vers=( $insight_ver )
						IFS="$IFSsave"
						for((i=0;i<${#insight_vers[@]};i++))
						do
							if [ -f .pkgrpm/${newdbschema}_${insight_vers[i]}.sql ]; then
							mysql --user=root --password=$passwd < .pkgrpm/${newdbschema}_${insight_vers[i]}.sql
							fi
						done
					fi

					quartz_ver=`cat .pkgrpm/tbl_ver.txt | grep -w quartz_files | cut -d '=' -f 2`
					if [ ${#quartz_ver} -ne 0 ]; then
						IFSsave="$IFS"
						IFS=,
						quartz_vers=( $quartz_ver )
						IFS="$IFSsave"
						for((i=0;i<${#quartz_vers[@]};i++))
						do
							if [ -f .pkgrpm/${newquartzdbschema}_${quartz_vers[i]}.sql ]; then
							mysql --user=root --password=$passwd < .pkgrpm/${newquartzdbschema}_${quartz_vers[i]}.sql
							fi
						done
					fi

					data_ver=`cat .pkgrpm/tbl_ver.txt | grep -w system_data_files | cut -d '=' -f 2`
					if [ ${#data_ver} -ne 0 ]; then
						IFSsave="$IFS"
						IFS=,	
						data_vers=( $data_ver )
						IFS="$IFSsave"
						for((i=0;i<${#data_vers[@]};i++))
						do
							if [ -f .pkgrpm/system_data_${newdbschema}_${data_vers[i]}.sql ]; then
							mysql --user=root --password=$passwd < .pkgrpm/system_data_${newdbschema}_${data_vers[i]}.sql
							fi
						done
					fi
										

	SILENT_INSTALLATION=`cat .conf/user_answers.txt | grep -w SILENT_INSTALLATION | cut -d '=' -f 2`
	CREATE_REMOTE_DB=`cat .conf/user_answers.txt | grep -w CREATE_REMOTE_DB | cut -d '=' -f 2`
					
#if [ ${#SILENT_INSTALLATION} -eq 1 -a $CREATE_REMOTE_DB = "Y" ]; then
if [ ${#SILENT_INSTALLATION} -eq 1 ]; then
	if [ $CREATE_REMOTE_DB = "Y" ]; then
		mysql --user=root --password=$passwd < .pkgrpm/default_remote_db.sql
	fi				
fi						
					echo "DB_USER=$newdbschema" >> .conf/profile
					echo "DB_PASSWORD=$newdbschema" >> .conf/profile
					echo "DB_SCHEMA=$newdbschema" >> .conf/profile
					echo "QUARTZ_DB_SCHEMA=$newquartzdbschema" >> .conf/profile
					echo "MYSQL_BIN=/usr/bin" >> .conf/profile
					NEWUSER=`cat .conf/user_answers.txt | grep -w CREATE_NEW_USER | cut -d '=' -f 2`
					DEFAULT_PASSWORD=`cat .conf/user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
					MYSQL_USER_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`
					#MYSQL_USER_PASSWORD=`cat .conf/user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
					echo "DEFAULT_ID="$DEFAULT_PASSWORD" " >> uninstall.sh
					echo "MYSQL_ROOT_PASSWORD=\`echo \$DEFAULT_ID | base64 --decode -i\` ">> uninstall.sh
					echo "mysql --user=root --password=\$MYSQL_ROOT_PASSWORD < /home/$NEWUSER/Insight/bin/delete_schema_${newdbschema}.sql > /dev/null 2>&1" >> uninstall.sh
				
					
					echo "INFO : Cisco Insight schema created successfully"
				else
					echo "MSG : Please enter valid mysql root password."
					exit 1 
				fi
			fi
		else
			echo "An existing MySQL installation is detected on your system which is not compatible with Cisco Insight Reporter. Please use MySQL version 5.6 or uninstall the existing MySQL and rerun the Insight installation. Now exiting."
			#echo "An existing MySQL installation is detected on your system which is not compatible with Cisco Insight Reporter. Please use MySQL version 5.1 or uninstall the existing MySQL and rerun the Insight installation. Now exiting."
			exit 1
		fi
	else
		RIS1=`cat .conf/user_answers.txt | grep -w INSTALL_MYSQL | cut -d '=' -f 2`
		if [ "$RIS1" = "N" -o "$RIS1" = "n" ]; then
			echo "MSG : MySql is required to complete the installation of Cisco Insight. Please refer to the installation guide for further details. Now exiting."
			exit 1
		else
			
				
				ans=`cat .conf/user_answers.txt | grep -w MYSQL_DATA_DIR | cut -d '=' -f 2`
				rm -rf /root/.mysql_secret	
				rm -f /usr/my.cnf
				
				mysql_client=`ls .pkgrpm/|grep "MySQL-client*"`
				mysql_server=`ls .pkgrpm/|grep "MySQL-server*"`
				rpm -ivh .pkgrpm/$mysql_client
				rpm -ivh .pkgrpm/$mysql_server
				
				/etc/init.d/mysql start
				
				if [ $? -ne 0 ]; then
					rpm -e MySQL-server-advanced-5.6.13-1.rhel5.x86_64
					rpm -e MySQL-client-advanced-5.6.13-1.rhel5.x86_64
					#rpm -e MySQL-client-advanced-5.1.51-1.rhel5
					#rpm -e MySQL-server-advanced-5.1.51-1.rhel5
					rm -rf $ans
					rm -rf /var/run/mysqld/
					rm -rf /var/lib/mysql/
					rm -f /var/log/mysqld.log
					rm -f /etc/my.cnf
					rm -rf /root/.mysql_secret
					rm -f /usr/my.cnf
					MYSQL_EXISTS=`cat /etc/passwd | grep -w mysql`
					if [ ${#MYSQL_EXISTS} -ne 0 ]; then
						userdel -rf mysql > /dev/null 2>&1
					fi
					echo "MSG : Installation was unable to start mysql daemon due to one of the following reasons"
					echo "1. Firewall is enabled and not configured to allow access to port 3306"
					echo "2. SE Linux is enabled and blocking access to port 3306"
					echo "3. Socket already in use"
					exit 1
				fi
				sleep 3
				
				#/etc/init.d/mysql stop
				#mysqld_safe --skip-grant-tables &
				#PID=$!
				#echo "$PID"
				#sleep 3
				#kill -9 $PID
				
				#mysql -uroot < .pkgrpm/change_paswd.sql
				
				#/etc/init.d/mysql stop
				#/etc/init.d/mysql start
				DEFAULT_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
				NEW_MYSQL_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`
				#NEW_MYSQL_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
				stty echo
				#echo "NEW_MYSQL_PASSWORD: $NEW_MYSQL_PASSWORD"
				if [ -f /root/.mysql_secret ]; then
				DEFAULT_MYSQL_PASSWORD=`cat /root/.mysql_secret | grep -w password | cut -d ':' -f 4 | tr -d ' '`
				else
				DEFAULT_MYSQL_PASSWORD=$MSQ_PASS
				RUN_UPGRADE=true
				fi
				

				#if [ ${#DEFAULT_MYSQL_PASSWORD} -ne 0 ]; then
					#echo "MSG : Setting default password to previous password"
					
				#fi
				#echo "**************** DEFAULT_MYSQL_PASSWORD ****** $DEFAULT_MYSQL_PASSWORD"
				#change_password=`query="set password = PASSWORD($NEW_MYSQL_PASSWORD)" mysql -uroot -p$DEFAULT_MYSQL_PASSWORD --connect-expired-password << eof $query	eof`
				
				#grant_access=`query="GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED BY $NEW_MYSQL_PASSWORD WITH GRANT OPTION"	mysql -uroot -p$NEW_MYSQL_PASSWORD --skip-column-names << eof $query eof`
	#echo "Changing mysql password************************"
change_password=`query="set password = PASSWORD('$NEW_MYSQL_PASSWORD')"
mysql -uroot -p$DEFAULT_MYSQL_PASSWORD --connect-expired-password << eof
$query
eof`		

if [ ${#RUN_UPGRADE} -ne 0 ]; then

echo "Running Mysql upgrade....."
mysql_upgrade -uroot -p$NEW_MYSQL_PASSWORD

fi 

				echo "DEFAULT_ID=$DEFAULT_PASSWORD" >> .conf/user_answers.txt
				
				#mysqladmin -u root -h localhost password $NEW_MYSQL_PASSWORD
				#mysqladmin --user=root --password=$NEW_MYSQL_PASSWORD version > /dev/null 2>&1
				if [ $? -ne 0 ]; then
					/etc/init.d/mysql stop
					rpm -e MySQL-server-advanced-5.6.13-1.rhel5.x86_64
					rpm -e MySQL-client-advanced-5.6.13-1.rhel5.x86_64
					#rpm -e MySQL-client-advanced-5.1.51-1.rhel5
					#rpm -e MySQL-server-advanced-5.1.51-1.rhel5
					rm -rf $ans
					rm -rf /var/run/mysqld/
					rm -rf /var/lib/mysql/
					rm -f /var/log/mysqld.log
					rm -f /etc/my.cnf
					rm -rf /root/.mysql_secret
					MYSQL_EXISTS=`cat /etc/passwd | grep -w mysql`
					if [ ${#MYSQL_EXISTS} -ne 0 ]; then
						userdel -rf mysql > /dev/null 2>&1
					fi
					echo "MSG : Installation was unable to connect to MySql server due to one of the following reasons"
					echo "1. Firewall is enabled and not configured to allow access to port 3306"
					echo "2. SE Linux is enabled and blocking access to port 3306"
					echo "3. Invalid MySql root password"
					exit 1
				fi
				
					mysql --user=root --password=$NEW_MYSQL_PASSWORD < .pkgrpm/user_mysql_insight.sql
					newdbschema=insight
					newquartzdbschema=insight_quartz

					insight_ver=`cat .pkgrpm/tbl_ver.txt | grep -w insight_files | cut -d '=' -f 2`
					if [ ${#insight_ver} -ne 0 ]; then
						IFSsave="$IFS"
						IFS=,
						insight_vers=( $insight_ver )
						IFS="$IFSsave"
						for((i=0;i<${#insight_vers[@]};i++))
						do
							if [ -f .pkgrpm/${newdbschema}_${insight_vers[i]}.sql ]; then
							mysql --user=root --password=$NEW_MYSQL_PASSWORD < .pkgrpm/${newdbschema}_${insight_vers[i]}.sql
							fi
						done
					fi

					quartz_ver=`cat .pkgrpm/tbl_ver.txt | grep -w quartz_files | cut -d '=' -f 2`
					if [ ${#quartz_ver} -ne 0 ]; then
						IFSsave="$IFS"
						IFS=,
						quartz_vers=( $quartz_ver )
						IFS="$IFSsave"
						for((i=0;i<${#quartz_vers[@]};i++))
						do
							if [ -f .pkgrpm/${newquartzdbschema}_${quartz_vers[i]}.sql ]; then
							mysql --user=root --password=$NEW_MYSQL_PASSWORD < .pkgrpm/${newquartzdbschema}_${quartz_vers[i]}.sql
							fi
						done
					fi

					data_ver=`cat .pkgrpm/tbl_ver.txt | grep -w system_data_files | cut -d '=' -f 2`
					if [ ${#data_ver} -ne 0 ]; then
						IFSsave="$IFS"
						IFS=,	
						data_vers=( $data_ver )
						IFS="$IFSsave"
						for((i=0;i<${#data_vers[@]};i++))
						do
							if [ -f .pkgrpm/system_data_${newdbschema}_${data_vers[i]}.sql ]; then
							mysql --user=root --password=$NEW_MYSQL_PASSWORD < .pkgrpm/system_data_${newdbschema}_${data_vers[i]}.sql
							fi
						done
					fi
					

				echo "DB_USER=insight_admin" >> .conf/profile
				echo "DB_PASSWORD=insight_admin" >> .conf/profile
				echo "DB_SCHEMA=insight" >> .conf/profile
				echo "QUARTZ_DB_SCHEMA=insight_quartz" >> .conf/profile
				/sbin/chkconfig --add mysql
				/sbin/chkconfig --level 23456 mysql on
				echo "MYSQL_BIN=/usr/bin" >> .conf/profile
				echo "echo \"INFO : In order to remove Insight Reporter, you need to execute the uninstall.sh script located under [user home directory]/Insight/bin.\""
				
				echo "DEFAULT_ID="$DEFAULT_PASSWORD" " >> uninstall.sh
				echo "MYSQL_ROOT_PASSWORD=\`echo \$DEFAULT_ID | base64 --decode -i\` ">> uninstall.sh
				echo "mysql --user=root --password=$MYSQL_ROOT_PASSWORD < delete_schema_insight.sql > /dev/null 2>&1" >> uninstall.sh
				#echo "if [ \$# -ne 0 ]; then" >> uninstall.sh
				#echo "if [ \`echo \$* | tr [:upper:] [:lower:] | grep -c \"mysql\"\` -eq 1 ]; then" >> uninstall.sh
				#echo "/etc/init.d/mysql stop" >> uninstall.sh
				#echo "rpm -e MySQL-client-advanced-5.6.13-1.el6.x86_64.rpm" >> uninstall.sh
				#echo "rpm -e MySQL-server-advanced-5.6.13-1.rhel5.x86_64" >> uninstall.sh
				#echo "rpm -e MySQL-client-advanced-5.1.51-1.rhel5" >> uninstall.sh
				#echo "rpm -e MySQL-server-advanced-5.1.51-1.rhel5" >> uninstall.sh
				#echo "rm -f /etc/my.cnf" >> uninstall.sh
				#echo "rm -rf $ans" >> uninstall.sh
				#echo "rm -rf /var/lib/mysql" >> uninstall.sh
				#echo "rm -rf /var/run/mysqld" >> uninstall.sh
				#echo "rm -rf /var/log/mysqld.log" >> uninstall.sh
				#echo "MYSQL_EXISTS=\`cat /etc/passwd | grep -w mysql\`" >> uninstall.sh
				#echo "if [ \${#MYSQL_EXISTS} -ne 0 ]; then" >> uninstall.sh
				#echo "userdel -rf mysql > /dev/null 2>&1" >> uninstall.sh
				#echo "fi" >> uninstall.sh
				#echo "fi" >> uninstall.sh
				#echo "fi" >> uninstall.sh
		fi
	fi
