#!/bin/sh
#if [ -f .conf/user_answers.txt ]; then
#	rm -f .conf/user_answers.txt
#fi

createSQLFiles()
{
	old_db_name=DB
	new_db_name=$1
	old_quartz_db_name=QUARTZ
	new_quartz_db_name=$2
	old_root_password=password
	new_root_password=$3
	old_user_name=MYSQL_USER
	new_user_name=$4

	if [ "insight" != "${new_db_name}" ]; then
	    sed -e s:insight:$new_db_name:g .pkgrpm/insight.sql > .pkgrpm/$new_db_name.sql
	fi

	sed -e s:insight:$new_db_name:g .pkgrpm/system_data.sql > .pkgrpm/system_data_$new_db_name.sql

	if [ "insight" != "${new_db_name}" ]; then
        	sed -e s:insight_quartz:$new_quartz_db_name:g .pkgrpm/quartz.sql > .pkgrpm/$new_quartz_db_name.sql
	else
		cp -f .pkgrpm/quartz.sql .pkgrpm/$new_quartz_db_name.sql
	fi

	sed -e s:$old_quartz_db_name:$new_quartz_db_name:g .pkgrpm/user_mysql.sql > .pkgrpm/user_mysql_$new_db_name.sql

	if [ "${old_root_password}" != "${new_root_password}" ]; then
		sed -e s:$old_root_password:$new_root_password:g .pkgrpm/user_mysql_$new_db_name.sql > .pkgrpm/temp_user_mysql_$new_db_name.sql
		mv .pkgrpm/temp_user_mysql_$new_db_name.sql .pkgrpm/user_mysql_$new_db_name.sql
	fi

	sed -e s:insight:$new_db_name:g .pkgrpm/update_system_data.sql > .pkgrpm/update_system_data_$new_db_name.sql
	if [ "insight" != "${new_db_name}" ]; then
	    sed -e s:insight:$new_db_name:g .pkgrpm/update_insight.sql > .pkgrpm/update_$new_db_name.sql
	fi



if [ "insight" != "${new_db_name}" ]; then
insight_ver=`cat .pkgrpm/tbl_ver.txt | grep -w insight_files | cut -d '=' -f 2`
if [ ${#insight_ver} -ne 0 ]; then
IFSsave="$IFS"
IFS=,
insight_vers=( $insight_ver )
IFS="$IFSsave"
for((i=0;i<${#insight_vers[@]};i++))
do
	sed -e s:insight:$new_db_name:g .pkgrpm/insight_${insight_vers[i]}.sql > .pkgrpm/$new_db_name_${insight_vers[i]}.sql
done
fi
fi

if [ "insight" != "${new_db_name}" ]; then
quartz_ver=`cat .pkgrpm/tbl_ver.txt | grep -w quartz_files | cut -d '=' -f 2`
if [ ${#quartz_ver} -ne 0 ]; then
IFSsave="$IFS"
IFS=,
quartz_vers=( $quartz_ver )
IFS="$IFSsave"
for((i=0;i<${#quartz_vers[@]};i++))
do
	sed -e s:insight_quartz:$new_quartz_db_name:g .pkgrpm/quartz_${quartz_vers[i]}.sql > .pkgrpm/$new_quartz_db_name_${quartz_vers[i]}.sql
done
fi
fi

data_ver=`cat .pkgrpm/tbl_ver.txt | grep -w system_data_files | cut -d '=' -f 2`
if [ ${#data_ver} -ne 0 ]; then
IFSsave="$IFS"
IFS=,
data_vers=( $data_ver )
IFS="$IFSsave"
for((i=0;i<${#data_vers[@]};i++))
do
	sed -e s:insight:$new_db_name:g .pkgrpm/system_data_${data_vers[i]}.sql > .pkgrpm/system_data_$new_db_name_${data_vers[i]}.sql
done
fi



	sed -e s:$old_user_name:$new_user_name:g .pkgrpm/user_mysql_$new_db_name.sql > .pkgrpm/temp_user_mysql_$new_db_name.sql
	mv .pkgrpm/temp_user_mysql_$new_db_name.sql .pkgrpm/user_mysql_$new_db_name.sql

	sed -e s:$old_db_name:$new_db_name:g .pkgrpm/user_mysql_$new_db_name.sql > .pkgrpm/temp_user_mysql_$new_db_name.sql
	mv .pkgrpm/temp_user_mysql_$new_db_name.sql .pkgrpm/user_mysql_$new_db_name.sql

       	sed -e s:$old_quartz_db_name:$new_quartz_db_name:g .pkgrpm/delete_schema.sql > .pkgrpm/delete_schema_$new_db_name.sql

	sed -e s:$old_user_name:$new_user_name:g .pkgrpm/delete_schema_$new_db_name.sql > .pkgrpm/temp_delete_schema_$new_db_name.sql
	mv .pkgrpm/temp_delete_schema_$new_db_name.sql .pkgrpm/delete_schema_$new_db_name.sql

	sed -e s:$old_db_name:$new_db_name:g .pkgrpm/delete_schema_$new_db_name.sql > .pkgrpm/temp_delete_schema_$new_db_name.sql
	mv .pkgrpm/temp_delete_schema_$new_db_name.sql .pkgrpm/delete_schema_$new_db_name.sql
}

/usr/java/jre1.6.0_22/bin/java -version 2>&1 |cat  > jre
contr=(`more jre | awk '{print $3}' |grep \"1 | sed -e s:\"::g`)
jre=(`echo ${contr:0:3}`)
if [ "$jre" = "1.6" ]; then
	IS_SUN_JAVA=`/usr/java/jre1.6.0_22/bin/java -version 2>&1 | grep -i "HotSpot"`
	if [ ${#IS_SUN_JAVA} -eq 0 ]; then
		echo "Sun Java HotSpot(TM) JRE6 is required."
		echo -n "Do you want to install JRE6? [Y/N] (default Y): "
		read INSTALL_JRE
		if [ "$INSTALL_JRE" = "N" -o "$INSTALL_JRE" = "n" ]; then
			echo "INSTALL_JRE=N" >> .conf/user_answers.txt
		else
			echo "INSTALL_JRE=Y" >> .conf/user_answers.txt
		fi
	else
		echo "JAVA_HOME=/usr/java/jre1.6.0_22" >> .conf/profile
	fi
else
	echo "Sun Java HotSpot(TM) JRE6 is required."
	echo -n "Do you want to install JRE6? [Y/N] (default Y): "
	read INSTALL_JRE
	if [ "$INSTALL_JRE" = "N" -o "$INSTALL_JRE" = "n" ]; then
		echo "INSTALL_JRE=N" >> .conf/user_answers.txt
	else
		echo "INSTALL_JRE=Y" >> .conf/user_answers.txt
	fi
fi

mysql --version >/dev/null 2>&1
if [ $? -eq 0 ]; then
	contr=(`mysql --version | awk '{print $5}' | sed s:,::g`)
	controllo=(`echo ${contr:0:3}`)
	if [ "$controllo" \> "5.1" -o "$controllo" = "5.1" ]; then
		echo -n "An existing v5.1 MySQL installation was found on your system. Do you want to use it to install Cisco Insight? [Y/N] (default Y): "
		read USE_INSTALLED_MYSQL
		if [ "$USE_INSTALLED_MYSQL" = "N" -o "$USE_INSTALLED_MYSQL" = "n" ]; then
			echo "USE_INSTALLED_MYSQL=N" >> .conf/user_answers.txt
		else
			echo "USE_INSTALLED_MYSQL=Y" >> .conf/user_answers.txt
			echo -n "Enter the root password for MySQL: "
			read INSTALLED_MYSQL_ROOT_PASSWORD
			echo "INSTALLED_MYSQL_ROOT_PASSWORD=$INSTALLED_MYSQL_ROOT_PASSWORD" >> .conf/user_answers.txt
			echo -n "Enter schema name for insight local database:"
			read NEW_DB_SCHEMA_NAME
			if [ ${#NEW_DB_SCHEMA_NAME} -eq 0 ]; then
				echo "Please enter a valid value of the database schema"
				exit 1
			else
				mysql -uroot -p$INSTALLED_MYSQL_ROOT_PASSWORD $NEW_DB_SCHEMA_NAME < .pkgrpm/quit.sql > /dev/null 2>&1 
				if [ $? -eq 0 ]; then
					echo "$NEW_DB_SCHEMA_NAME already exists. Please enter some other valid database schema name"
					exit 1
				fi
				echo "NEW_DB_SCHEMA_NAME=$NEW_DB_SCHEMA_NAME" >> .conf/user_answers.txt
			fi
			
			
			echo "NEW_QUARTZ_DB_SCHEMA_NAME=${NEW_DB_SCHEMA_NAME}_quartz" >> .conf/user_answers.txt
			createSQLFiles "$NEW_DB_SCHEMA_NAME" "${NEW_DB_SCHEMA_NAME}_quartz" "$INSTALLED_MYSQL_ROOT_PASSWORD" "$NEW_DB_SCHEMA_NAME"
		fi
	fi
else
	echo -n "Do you want to install MySQL server? [Y/N] (default Y): "
	read INSTALL_MYSQL
	if [ "$INSTALL_MYSQL" = "N" -o "$INSTALL_MYSQL" = "n" ]; then
		echo "INSTALL_MYSQL=N" >> .conf/user_answers.txt
	else
		echo "INSTALL_MYSQL=Y" >> .conf/user_answers.txt
		until [ ${#MYSQL_DATA_DIR} -ne 0 ]
		do
			echo -n "Enter MySQL data directory applicable for your installation(example /opt/mysql-data): "
			read MYSQL_DATA_DIR
			if [ ${#MYSQL_DATA_DIR} -eq 0 ]; then
				echo "Please enter a valid value of the MySQL data directory"
			else
				echo "MYSQL_DATA_DIR=$MYSQL_DATA_DIR" >> .conf/user_answers.txt
				break
			fi
		done
		createSQLFiles "insight" "insight_quartz" "password" "insight_admin"
	fi

fi
