#!/bin/sh


mysql --version >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		contr=(`mysql --version | awk '{print $5}' | sed s:,::g`)
		controllo=(`echo ${contr:0:3}`)
		if [ "$controllo" \> "5.1" -o "$controllo" = "5.1" ]; then
			RIS=`cat .conf/user_answers.txt | grep -w USE_INSTALLED_MYSQL | cut -d '=' -f 2`
			if [ "$RIS" = "N" -o "$RIS" = "n" ]; then
				echo "The installation of Cisco Insight database schema is required to continue. Please refer to the Installation guide for further details. Now exiting."
				exit 1
			else	
				passwd=`cat .conf/user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
				if [ ${#passwd} -ne 0 ]; then
					mysqladmin --user=root --password=$passwd version > /dev/null 2>&1
					if [ $? -ne 0 ]; then
						echo "Installation was unable to connect to MySql server due to one of the following reasons"
						echo "Firewall is enabled and not configured to allow access to port 3306"
						echo "SE Linux is enabled and blocking access to port 3306"
						echo "Invalid MySql root password"
						exit 1
					fi
					newdbschema=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
					newquartzdbschema=`cat .conf/user_answers.txt | grep -w NEW_QUARTZ_DB_SCHEMA_NAME | cut -d '=' -f 2`
					#mysql --user=root --password=$passwd < .pkgrpm/${newdbschema}.sql
					#mysql --user=root --password=$passwd < .pkgrpm/system_data_${newdbschema}.sql
					#mysql --user=root --password=$passwd < .pkgrpm/${newquartzdbschema}.sql
					mysql --user=root --password=$passwd < .pkgrpm/user_mysql_${newdbschema}.sql
					#mysql --user=root --password=$passwd < .pkgrpm/update_${newdbschema}.sql
					#mysql --user=root --password=$passwd < .pkgrpm/update_system_data_${newdbschema}.sql


insight_ver=`cat .pkgrpm/tbl_ver.txt | grep -w insight_files | cut -d '=' -f 2`
if [ ${#insight_ver} -ne 0 ]; then
IFSsave="$IFS"
IFS=,
insight_vers=( $insight_ver )
IFS="$IFSsave"
for((i=0;i<${#insight_vers[@]};i++))
do
	mysql --user=root --password=$passwd < .pkgrpm/${newdbschema}_${insight_vers[i]}.sql
done
fi

quartz_ver=`cat .pkgrpm/tbl_ver.txt | grep -w quartz_files | cut -d '=' -f 2`
if [ ${#quartz_ver} -ne 0 ]; then
IFSsave="$IFS"
IFS=,
quartz_vers=( $quartz_ver )
IFS="$IFSsave"
for((i=0;i<${#quartz_vers[@]};i++))
do
	mysql --user=root --password=$passwd < .pkgrpm/${newdbschema}_${quartz_vers[i]}.sql
done
fi

data_ver=`cat .pkgrpm/tbl_ver.txt | grep -w system_data_files | cut -d '=' -f 2`
if [ ${#data_ver} -ne 0 ]; then
IFSsave="$IFS"
IFS=,
data_vers=( $data_ver )
IFS="$IFSsave"
for((i=0;i<${#data_vers[@]};i++))
do
	mysql --user=root --password=$passwd < .pkgrpm/${newdbschema}_${data_vers[i]}.sql
done
fi

					echo "DB_USER=$newdbschema" >> .conf/profile
					echo "DB_PASSWORD=$newdbschema" >> .conf/profile
					echo "DB_SCHEMA=$newdbschema" >> .conf/profile
					echo "QUARTZ_DB_SCHEMA=$newquartzdbschema" >> .conf/profile
					echo "MYSQL_BIN=/usr/bin" >> .conf/profile
					echo "mysql --user=root --password=$passwd < delete_schema_${newdbschema}.sql > /dev/null 2>&1" >> uninstall.sh
				else
					echo "Please enter some valid value of mysql root password"
					exit 1 
				fi
			fi
		else
			echo "A previous version of MySQL was detected on your system. This is version is not compatible with Cisco Insight and needs to be uninstalled before proceeding. Now exiting"
			exit 1
		fi
	else
		RIS1=`cat .conf/user_answers.txt | grep -w INSTALL_MYSQL | cut -d '=' -f 2`
		if [ "$RIS1" = "N" -o "$RIS1" = "n" ]; then
			echo "MySql is required to complete the installation of Cisco Insight. Please refer to the installation guide for further details. Now exiting."
			exit 1
		else
				ans=`cat .conf/user_answers.txt | grep -w MYSQL_DATA_DIR | cut -d '=' -f 2`
				if [ -f /etc/my.cnf ]; then
					mv /etc/my.cnf /etc/my.cnf.old
				else
					sed -e s:MYSQL_DATA_DIR:$ans:g .pkgrpm/my.cnf > /etc/my.cnf
				fi
				rpm -ivh .pkgrpm/MySQL-client-advanced-5.1.51-1.rhel5.i386.rpm
				rpm -ivh .pkgrpm/MySQL-server-advanced-5.1.51-1.rhel5.i386.rpm
				/etc/init.d/mysql start
				if [ $? -ne 0 ]; then
					rpm -e MySQL-client-advanced-5.1.51-1.rhel5
					rpm -e MySQL-server-advanced-5.1.51-1.rhel5
					rm -rf $ans
					rm -rf /var/run/mysqld/
					rm -rf /var/lib/mysql/
					rm -f /var/log/mysqld.log
					rm -f /etc/my.cnf
					MYSQL_EXISTS=`cat /etc/passwd | grep -w mysql`
					if [ ${#MYSQL_EXISTS} -ne 0 ]; then
						userdel -rf mysql > /dev/null 2>&1
					fi
					echo "Installation was unable to start mysql daemon due to one of the following reasons"
					echo "Firewall is enabled and not configured to allow access to port 3306"
					echo "SE Linux is enabled and blocking access to port 3306"
					echo "Socket already in use"
					exit 1
				fi
				sleep 3
				mysqladmin -u root -h localhost password 'password'
				mysqladmin --user=root --password=password version > /dev/null 2>&1
				if [ $? -ne 0 ]; then
					/etc/init.d/mysql stop
					rpm -e MySQL-client-advanced-5.1.51-1.rhel5
					rpm -e MySQL-server-advanced-5.1.51-1.rhel5
					rm -rf $ans
					rm -rf /var/run/mysqld/
					rm -rf /var/lib/mysql/
					rm -f /var/log/mysqld.log
					rm -f /etc/my.cnf
					MYSQL_EXISTS=`cat /etc/passwd | grep -w mysql`
					if [ ${#MYSQL_EXISTS} -ne 0 ]; then
						userdel -rf mysql > /dev/null 2>&1
					fi
					echo "Installation was unable to connect to MySql server due to one of the following reasons"
					echo "Firewall is enabled and not configured to allow access to port 3306"
					echo "SE Linux is enabled and blocking access to port 3306"
					echo "Invalid MySql root password"
					exit 1
				fi
				mysql --user=root --password=password < .pkgrpm/insight.sql
				mysql --user=root --password=password < .pkgrpm/system_data_insight.sql
				mysql --user=root --password=password < .pkgrpm/quartz.sql
				mysql --user=root --password=password < .pkgrpm/user_mysql_insight.sql
				mysql --user=root --password=$passwd < .pkgrpm/update_${newdbschema}.sql
				mysql --user=root --password=$passwd < .pkgrpm/update_system_data_${newdbschema}.sql
				echo "DB_USER=insight_admin" >> .conf/profile
				echo "DB_PASSWORD=insight_admin" >> .conf/profile
				echo "DB_SCHEMA=insight" >> .conf/profile
				echo "QUARTZ_DB_SCHEMA=insight_quartz" >> .conf/profile
				/sbin/chkconfig --add mysql
				/sbin/chkconfig --level 23456 mysql on
				echo "MYSQL_BIN=/usr/bin" >> .conf/profile
				echo "echo \"In order to remove completely MySQL server, you need to execute the uninstall.sh script located under [user home directory]/Insightv2/bin.\""
				
				echo "mysql --user=root --password=password < delete_schema_insight.sql > /dev/null 2>&1" >> uninstall.sh
				echo "if [ \$# -ne 0 ]; then" >> uninstall.sh
				echo "if [ \`echo \$* | tr [:upper:] [:lower:] | grep -c \"mysql\"\` -eq 1 ]; then" >> uninstall.sh
				echo "/etc/init.d/mysql stop" >> uninstall.sh
				echo "rpm -e MySQL-client-advanced-5.1.51-1.rhel5" >> uninstall.sh
				echo "rpm -e MySQL-server-advanced-5.1.51-1.rhel5" >> uninstall.sh
				echo "rm -f /etc/my.cnf" >> uninstall.sh
				echo "rm -rf $ans" >> uninstall.sh
				echo "rm -rf /var/lib/mysql" >> uninstall.sh
				echo "rm -rf /var/run/mysqld" >> uninstall.sh
				echo "rm -rf /var/log/mysqld.log" >> uninstall.sh
				echo "MYSQL_EXISTS=\`cat /etc/passwd | grep -w mysql\`" >> uninstall.sh
				echo "if [ \${#MYSQL_EXISTS} -ne 0 ]; then" >> uninstall.sh
				echo "userdel -rf mysql > /dev/null 2>&1" >> uninstall.sh
				echo "fi" >> uninstall.sh
				echo "fi" >> uninstall.sh
				echo "fi" >> uninstall.sh
		fi
	fi
