#!/bin/sh

un=("#!/bin/sh")
echo $un > uninstall.sh
echo "user=(\`id | awk '{print \$1}'\`)" >> uninstall.sh
echo "user=\${user:6:4}" >> uninstall.sh
echo "if [ \$user = \"root\" ]; then" >> uninstall.sh

echo "echo \"This would remove the Insight v2 Application and the corresponding database. If you wish to take a backup of the database schema, quit the un-installation and do so now.\"" >> uninstall.sh
echo "echo -n \"Do you want to continue? [Y/N] (default Y): \"" >> uninstall.sh
echo "read UNINSTALL_ANSWER" >> uninstall.sh
echo "if [ \"\$UNINSTALL_ANSWER\" = \"N\" -o \"\$UNINSTALL_ANSWER\" = \"n\" ]; then" >> uninstall.sh
	echo "exit 0" >> uninstall.sh
echo "else" >> uninstall.sh

. .scripts/user.sh
USER_EXISTS=`cat .conf/user_answers.txt | grep -w USER_EXISTS | cut -d '=' -f 2`
NEW_INSTALLATION=`cat .conf/user_answers.txt | grep -w NEW_INSTALLATION | cut -d '=' -f 2`

if [ $NEW_INSTALLATION -ne 0 ]; then
        if [ -f .conf/profile ]; then
                rm -f .conf/profile
        fi
fi

if [ $? = 1 ]; then
	echo "Issue asking for user name. Please check the logs"
elif [ $USER_EXISTS = 1 ] && [ NEW_INSTALLATION=0 ]; then
	. .scripts/update.sh
else
	. .scripts/answers.sh 
	if [ $? = 1 ]; then
		echo "Issue asking option from user. Please check the logs"
	else	
		. .scripts/java-install.sh 
		if [ $? = 1 ]; then
			echo "Issue installing java. Please check the logs"
		else
			. .scripts/mysql-install.sh 
			if [ $? = 1 ]; then
				echo "Issue installing mysql. Please check the logs"
			else
				. .scripts/create-user.sh 
				if [ $? = 1 ]; then
					echo "Issue creating user. Please check the logs"
				else
					. .scripts/install-app.sh 
					if [ $? = 1 ]; then
						echo "Issue installing application. Please check the logs"
					else
						. .scripts/setenv.sh 
						echo "Proceeding to configuration"
					fi
				fi
			fi
	
		fi
	fi
fi
echo "fi" >> uninstall.sh
echo "else" >> uninstall.sh
echo "echo \"You must be root to launch the un-installation script\"" >> uninstall.sh
echo "fi" >> uninstall.sh

echo $un > backup.sh
echo "user=(\`id | awk '{print \$1}'\`)" >> backup.sh
echo "user=\${user:6:4}" >> backup.sh
echo "if [ \$user = \"root\" ]; then" >> backup.sh
echo "PREDATE=\`date --date=\"-1 days\" +%Y-%m-%d\`" >> backup.sh
echo "LOG_DIR=\$1" >> backup.sh
echo "OUTPUT_DIR=\$2" >> backup.sh
echo "SQL_FILE=\$3" >> backup.sh
echo "if [ \$# -lt 3 ]; then" >> backup.sh
echo "echo \"To execute this script please provide all the 3 arguments(log directory, output directory and sql file)\"">> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "if [ -d \$LOG_DIR ]; then" >> backup.sh
echo "echo \"\"" >> backup.sh
echo "else" >> backup.sh
echo "echo \"log directory does not exists\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "if [ -d \$OUTPUT_DIR ]; then" >> backup.sh
echo "echo \"\"" >> backup.sh
echo "else" >> backup.sh
echo "echo \"output directory does not exists\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "if [ -f \$SQL_FILE ]; then" >> backup.sh
echo "if [ -r \$SQL_FILE ]; then" >> backup.sh
echo "echo \"\"" >> backup.sh
echo "else" >> backup.sh
echo "echo \"cannot read sql file\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "echo \"sql file does not exists\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "mkdir \$OUTPUT_DIR/\$PREDATE" >> backup.sh
echo "PWDIR=\`pwd\`" >> backup.sh
echo "cd \$LOG_DIR" >> backup.sh
echo "zip -r logs.zip *" >> backup.sh
echo "cd \$PWDIR" >> backup.sh
echo "mv -f \$LOG_DIR/logs.zip \$OUTPUT_DIR/\$PREDATE" >> backup.sh
mysql_user=`cat .conf/profile | grep -w DB_USER | cut -d '=' -f 2`
mysql_password=`cat .conf/profile | grep -w DB_PASSWORD | cut -d '=' -f 2`
mysql_schema=`cat .conf/profile | grep -w DB_SCHEMA | cut -d '=' -f 2`
mysql_quartz_schema=`cat .conf/profile | grep -w QUARTZ_DB_SCHEMA | cut -d '=' -f 2`
mysql=`cat .conf/profile | grep -w MYSQL_BIN | cut -d '=' -f 2`
echo "tables=\`cat \$SQL_FILE\`" >> backup.sh
echo "if [ \${#4} -ne 0 ]; then" >> backup.sh
echo "if [ \`echo \$4 | tr [:upper:] [:lower:]\` = \"tables\" ]; then" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password $mysql_schema \$tables > \$OUTPUT_DIR/\$PREDATE/sql_output.sql" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password $mysql_quartz_schema > \$OUTPUT_DIR/\$PREDATE/quartz_sql_output.sql" >> backup.sh
echo "else" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_schema > \$OUTPUT_DIR/\$PREDATE/sql_output.sql" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_quartz_schema > \$OUTPUT_DIR/\$PREDATE/quartz_sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_schema > \$OUTPUT_DIR/\$PREDATE/sql_output.sql" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_quartz_schema > \$OUTPUT_DIR/\$PREDATE/quartz_sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "PWDIR=\`pwd\`" >> backup.sh
echo "cd \$OUTPUT_DIR/\$PREDATE" >> backup.sh
echo "zip sql.zip sql_output.sql" >> backup.sh
echo "if [ \$? -ne 0 ]; then" >> backup.sh
echo "if [ -f sql.zip ]; then" >> backup.sh
echo "rm -f sql.zip" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "rm -f sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "zip quartz_sql.zip quartz_sql_output.sql" >> backup.sh
echo "if [ \$? -ne 0 ]; then" >> backup.sh
echo "if [ -f quartz_sql.zip ]; then" >> backup.sh
echo "rm -f quartz_sql.zip" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "rm -f quartz_sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "cd \$PWDIR" >> backup.sh
echo "cd \$OUTPUT_DIR" >> backup.sh
echo "zip -r \$PREDATE.zip \$PREDATE" >> backup.sh 
echo "rm -rf \$PREDATE" >> backup.sh
echo "cd \$PWDIR" >> backup.sh
echo "else" >> backup.sh
echo "echo \"You must be root to launch the backup script\"" >> backup.sh
echo "fi" >> backup.sh



echo $un > config.sh
user=`cat .conf/profile | grep -w USER | cut -d '=' -f 2`
app_home=`cat .conf/profile | grep -w APP_HOME | cut -d '=' -f 2`

echo "insight_properties_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties" >> config.sh
echo "if [ -f \$insight_properties_file ]; then" >> config.sh
echo "insight_properties_temp_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties.tmp" >> config.sh
echo "insight_properties_backup_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties.backup" >> config.sh

echo "cp -f \$insight_properties_file \$insight_properties_backup_file" >> config.sh
echo "#jdbc host" >> config.sh
echo "jdbc_host=\`cat \$insight_properties_file | grep -w jdbc.host | cut -d'=' -f 2 | tr -d '\\r\\n\\t'\`" >> config.sh
echo "if [ \${#jdbc_host} -ne 0 ]; then" >> config.sh
echo "echo -n \"Enter the Insight local database host name (default is \${jdbc_host}):\"" >> config.sh
echo "else" >> config.sh
echo "echo -n \"Enter the Insight local database host name:\"" >> config.sh
echo "fi" >> config.sh
echo "read host" >> config.sh
echo "if [ \${#host} -ne 0 ]; then" >> config.sh
echo "sed '/^jdbc.host/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.host=\$host\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh

echo "#jdbc port" >> config.sh
echo "jdbc_port=\`cat \$insight_properties_file | grep -w jdbc.port | cut -d'=' -f 2 | tr -d '\\r\\n\\t'\`" >> config.sh
echo "if [ \${#jdbc_port} -ne 0 ]; then" >> config.sh
echo "echo -n \"Enter the Insight local database port (default is \${jdbc_port}):\"" >> config.sh
echo "else" >> config.sh
echo "echo -n \"Enter the Insight local database port :\"" >> config.sh
echo "fi" >> config.sh
echo "read port" >> config.sh
echo "if [ \${#port} -ne 0 ]; then" >> config.sh
echo "sed '/^jdbc.port/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.port=\$port\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh

echo "#jdbc username" >> config.sh
newdbuser=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
if [ ${#newdbuser} -eq 0 ]; then
echo "newdbuser=insight_admin">> config.sh
else
echo "newdbuser=$newdbuser">> config.sh
fi
echo "sed '/^jdbc.username/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.username=\$newdbuser\" >> \$insight_properties_file" >> config.sh
echo "" >> config.sh

echo "#jdbc password" >> config.sh
newdbuserpass=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
if [ ${#newdbuserpass} -eq 0 ]; then
echo "newdbuserpass=insight_admin">> config.sh
else
echo "newdbuserpass=$newdbuserpass">> config.sh
fi
echo "sed '/^jdbc.password/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.password=\$newdbuserpass\" >> \$insight_properties_file" >> config.sh
echo "" >> config.sh


echo "sed '/^log4jfilepath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\nlog4jfilepath=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml\" >> \$insight_properties_file" >> config.sh
echo "" >> config.sh


echo "#template path" >> config.sh
echo "templatepath=$INSIGHT_HOME'/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/template/'" >> config.sh
echo "sed '/^templatePath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\ntemplatePath=\$templatepath\" >> \$insight_properties_file" >> config.sh
echo "echo -n \"Enter the report template directory (default is \${templatepath}):\"" >> config.sh
echo "read template_path" >> config.sh
echo "if [ \${#template_path} -ne 0 ]; then" >> config.sh
echo "sed '/^templatePath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\ntemplatePath=\$template_path\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh

echo "#bundle file path" >> config.sh
echo "bundlefilepath=$INSIGHT_HOME'/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/messagebundle/'" >> config.sh
echo "sed '/^bundleFilePath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\nbundleFilePath=\$bundlefilepath\" >> \$insight_properties_file" >> config.sh
echo "echo -n \"Enter the resource bundle directory (default is \${bundlefilepath}):\"" >> config.sh
echo "read bundle_file_path" >> config.sh
echo "if [ \${#bundle_file_path} -ne 0 ]; then" >> config.sh
echo "sed '/^bundleFilePath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\nbundleFilePath=\$bundle_file_path\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh


echo "db_schema=$mysql_schema" >> config.sh
echo "if [ \${#db_schema} -ne 0 ]; then" >> config.sh
echo "sed '/^jdbc.db.schema/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.db.schema=\$db_schema\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh

echo "#insight properties file" >> config.sh
echo "sed '/^insightpropertiespath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\ninsightpropertiespath=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties\">> \$insight_properties_file" >> config.sh
echo "echo \"The properties file with these configurations is created at:\"" >> config.sh
echo "echo -e \"\\n$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties\"" >> config.sh

echo "if [ \${#host} -eq 0 ]; then" >> config.sh
	echo "host=\"127.0.0.1\"">> config.sh
echo "fi" >> config.sh
echo "if [ \${#port} -eq 0 ]; then" >> config.sh
	echo "port=\"3306\"" >> config.sh
echo "fi" >> config.sh
newdbschema=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
echo "quartz_properties_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties" >> config.sh
echo "if [ -f \$quartz_properties_file ]; then" >> config.sh
echo "quartz_properties_temp_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties.tmp" >> config.sh
echo "quartz_properties_backup_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties.backup" >> config.sh

echo "cp -f \$quartz_properties_file \$quartz_properties_backup_file" >> config.sh
echo "#quartz db url" >> config.sh
echo "sed '/^org.quartz.dataSource.quartzDB.URL/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
if [ ${#newdbschema} -eq 0 ]; then
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.URL=jdbc:mysql://\${host}:\${port}/insight_quartz\" >> \$quartz_properties_file" >> config.sh
else
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.URL=jdbc:mysql://\${host}:\${port}/\${db_schema}_quartz\" >> \$quartz_properties_file" >> config.sh
fi
echo "" >> config.sh

echo "#quartz db user" >> config.sh
echo "sed '/^org.quartz.dataSource.quartzDB.user/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
if [ ${#newdbschema} -eq 0 ]; then
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.user=insight_admin\" >> \$quartz_properties_file" >> config.sh
else
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.user=\${db_schema}\" >> \$quartz_properties_file" >> config.sh
fi
echo "" >> config.sh

echo "#quartz db password" >> config.sh
echo "sed '/^org.quartz.dataSource.quartzDB.password/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
if [ ${#newdbschema} -eq 0 ]; then
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.password=insight_admin\" >> \$quartz_properties_file" >> config.sh
else
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.password=\${db_schema}\" >> \$quartz_properties_file" >> config.sh
fi
echo "" >> config.sh

current_path=`pwd`
app_path=$current_path/Insightv2/bin

template_path=$app_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/template/
grep item_id=208 $app_path/update.sql_backup | sed -e "s;selected_values=;selected_values='$template_path';" >> update.sql

gallery_path=$app_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/gallery
grep item_id=206 $app_path/update.sql_backup | sed -e "s;selected_values=;selected_values='$gallery_path';" >> update.sql

log_file_path=$app_home/apache-tomcat-6.0.20/logs/logs.log
grep item_id=217 $app_path/update.sql_backup | sed -e "s;selected_values=;selected_values='$log_file_path';" >> update.sql

script_path=$app_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/monitoring/
grep item_id=427 $app_path/update.sql_backup | sed -e "s;selected_values=;selected_values='$script_path';" >> update.sql

chmod 755 update.sql
chmod +x ${script_path}system_stat.sh
dos2unix ${script_path}system_stat.sh > /dev/null 2>&1
passwd=`cat .conf/user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
if [ ${#newdbschema} -eq 0 ]; then
        mysql -uroot -ppassword insight < update.sql
else
        mysql -uroot -p$passwd $newdbschema < update.sql
fi

log4j_xml_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml
log4j_xml_temp_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml.tmp
sed -e s:../logs/logs.log:$log_file_path:g $log4j_xml_file > $log4j_xml_temp_file
mv -f $log4j_xml_temp_file $log4j_xml_file
chown $user:$user $log4j_xml_file


echo "#remove all empty lines" >> config.sh
echo "sed '/^\$/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "chown $user:$user \$insight_properties_file" >> config.sh
echo "chown $user:$user \$insight_properties_backup_file" >> config.sh
echo "else" >> config.sh
echo "echo \"Unable to find configuration properties file\"" >> config.sh
echo "fi" >> config.sh

echo "#remove all empty lines" >> config.sh
echo "sed '/^\$/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
echo "chown $user:$user \$quartz_properties_file" >> config.sh
echo "chown $user:$user \$quartz_properties_backup_file" >> config.sh
echo "else" >> config.sh
echo "echo \"Unable to find quartz configuration properties file\"" >> config.sh
echo "fi" >> config.sh

if [ -f .conf/profile ]; then
	user_home=`cat .conf/profile | grep -w USER_HOME | cut -d '=' -f 2`
        if [ ${#user_home} -ne 0 ]; then
		chmod 755 uninstall.sh
		chmod 755 backup.sh
		chmod 755 config.sh
		chmod 755 update.sql
		mv uninstall.sh $user_home/Insightv2/bin
		mv backup.sh $user_home/Insightv2/bin
		mv config.sh $user_home/Insightv2/bin
		mv update.sql $user_home/Insightv2/bin
		chown -R $user:$user $user_home
		chown root:root $user_home/Insightv2/bin/uninstall.sh
		chown root:root $user_home/Insightv2/bin/backup.sh
		PWD=`pwd`
                cd $user_home/Insightv2/bin
                . ./config.sh
                cd $PWD
		echo "CONGRATS!! Installation finished"
		echo "To re-configure the application please execute config.sh in the [user home directory]/Insightv2/bin"
		echo "To uninstall the application please execute uninstall.sh in the [user home directory]/Insightv2/bin"
		echo "To bundle the logs please execute backup.sh in the [user home directory]/Insightv2/bin"
	else
		rm -f uninstall.sh
		rm -f backup.sh
		rm -f config.sh
		rm -f update.sql
	fi
else
	rm -f uninstall.sh
	rm -f backup.sh
	rm -f config.sh
	rm -f update.sql
fi
