#!/bin/sh

CREATE_NEW_USER=`cat .conf/user_answers.txt | grep -w CREATE_NEW_USER | cut -d '=' -f 2`
if [ -d .backup ]; then
	rm -rf .backup
fi
mkdir .backup
mkdir .backup/properties
mkdir .backup/db
mkdir .backup/class
mkdir .backup/gallery

#user_home=`cat .conf/profile | grep -w USER_HOME | cut -d '=' -f 2`
user_home=/home/$CREATE_NEW_USER
insight_home=$user_home/Insightv2

cp -r $insight_home .backup/class
if [ $? != 0 ]; then
	echo "Backup of InsightV2 fail."
	exit 1
fi

gallery_path=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/gallery
cp -r $gallery_path .backup/gallery
if [ $? != 0 ]; then
	echo "Gallery backup fail."
	exit 1
fi

insight_properties_file=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties
quartz_properties_file=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties
log4j_properties_file=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml

cp -r $insight_properties_file .backup/properties
cp -r $quartz_properties_file .backup/properties
cp -r $log4j_properties_file .backup/properties

passwrd=`cat .backup/properties/insight.properties | grep -w jdbc.password | cut -d '=' -f 2`
if [ ${#passwrd} -ne 0 ]; then
	mysqladmin --user=root --password=$passwrd version > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		echo "Installation was unable to connect to MySql server due to one of the following reasons"
		echo "Firewall is enabled and not configured to allow access to port 3306"
		echo "SE Linux is enabled and blocking access to port 3306"
		echo "Invalid MySql root password"
		exit 1
	fi
else
	echo "Mysql root password is not valid in insight.properties"
	exit 1
fi

insight_db=`cat .backup/properties/insight.properties | grep -w jdbc.db.schema | cut -d '=' -f 2`
insight_quartz_db=${insight_db}_quartz

count=`query="SELECT COUNT(*) FROM tables WHERE table_schema ='$insight_db'"
/usr/bin/mysql -uroot -ppassword --skip-column-names  information_schema<< eof
$query
eof`
if [ $count = 0 ]; then
	echo "Insight local database not found.Exiting the script"
	exit 1
fi

count_quartz=`query="SELECT COUNT(*) FROM tables WHERE table_schema ='$insight_quartz_db'"
/usr/bin/mysql -uroot -ppassword --skip-column-names  information_schema<< eof
$query
eof`
if [ $count_quartz = 0 ]; then
        echo "Insight quartz database not found.Exiting the script"
        exit 1
fi

gallery_path=`query="SELECT selected_values FROM config_system_param where item ='"GALLERY_DESTINATION_PATH"'"
/usr/bin/mysql -uroot -ppassword --skip-column-names $insight_db<< eof
$query
eof`

cp -r $gallery_path .backup/gallery/
if [ $? != 0 ]; then
        echo "Gallery backup fail."
        exit 1
fi
echo "GALLERY__PATH=$gallery_path" >> .conf/user_answers.txt

