#!/bin/sh

user_home=`cat .conf/profile | grep -w USER_HOME | cut -d '=' -f 2`
insight_home=$user_home/Insight
java_home=`cat .conf/profile | grep -w JAVA_HOME | cut -d '=' -f 2`
catalina_home=`cat .conf/profile | grep -w CATALINA_HOME | cut -d '=' -f 2`
bash_profile_file=$user_home/.bash_profile
root_bash_profile_file=/root/.bash_profile
temp_root_bash_profile_file=/root/.bash_profile_tmp
temp_bash_profile_file=$user_home/.bash_profile_tmp
JAVA_HOME_VAR=`cat $bash_profile_file | grep -w JAVA_HOME`
if [ ${#JAVA_HOME_VAR} -ne 0 ]; then
	sed '/^JAVA_HOME/d' $bash_profile_file > $temp_bash_profile_file
	mv $temp_bash_profile_file $bash_profile_file
	echo "JAVA_HOME=$java_home" >> $bash_profile_file
else
	echo "JAVA_HOME=$java_home" >> $bash_profile_file
fi
ROOT_JAVA_HOME_VAR=`cat $root_bash_profile_file | grep -w JAVA_HOME`
if [ ${#ROOT_JAVA_HOME_VAR} -ne 0 ]; then
	sed '/^JAVA_HOME/d' $root_bash_profile_file > $temp_root_bash_profile_file
	mv $temp_root_bash_profile_file $root_bash_profile_file
	echo "JAVA_HOME=$java_home" >> $root_bash_profile_file
else
	echo "JAVA_HOME=$java_home" >> $root_bash_profile_file
fi
CATALINA_HOME_VAR=`cat $bash_profile_file | grep -w CATALINA_HOME`
if [ ${#CATALINA_HOME_VAR} -ne 0 ]; then
	sed '/^CATALINA_HOME/d' $bash_profile_file > $temp_bash_profile_file
	mv $temp_bash_profile_file $bash_profile_file
	echo "CATALINA_HOME=$catalina_home" >> $bash_profile_file
else
	echo "CATALINA_HOME=$catalina_home" >> $bash_profile_file
fi
PATH_VAR=`cat $bash_profile_file | grep -w PATH=`
if [ ${#PATH_VAR} -ne 0 ]; then
	sed '/^PATH/d' $bash_profile_file > $temp_bash_profile_file
	mv $temp_bash_profile_file $bash_profile_file
	echo "PATH=$java_home/bin:$PATH" >> $bash_profile_file
else
	echo "PATH=$java_home/bin:$PATH" >> $bash_profile_file
fi
ROOT_PATH_VAR=`cat $root_bash_profile_file | grep -w PATH=`
if [ ${#ROOT_PATH_VAR} -ne 0 ]; then
	sed '/^PATH/d' $root_bash_profile_file > $temp_root_bash_profile_file
	mv $temp_root_bash_profile_file $root_bash_profile_file
	echo "PATH=$java_home/bin:$PATH" >> $root_bash_profile_file
else
	echo "PATH=$java_home/bin:$PATH" >> $root_bash_profile_file
fi
sed '/^export/ d' $bash_profile_file > $temp_bash_profile_file
mv $temp_bash_profile_file $bash_profile_file
echo "export JAVA_HOME" >> $bash_profile_file
echo "export CATALINA_HOME" >> $bash_profile_file
echo "export PATH" >> $bash_profile_file
echo "export INSIGHT_HOME=$insight_home" >> $bash_profile_file

sed '/^export/ d' $root_bash_profile_file > $temp_root_bash_profile_file
mv $temp_root_bash_profile_file $root_bash_profile_file
echo "export JAVA_HOME" >> $root_bash_profile_file
echo "export PATH" >> $root_bash_profile_file

export JAVA_HOME=$java_home
export INSIGHT_HOME=$insight_home
export PATH=$java_home/bin:$insight_home/bin:$PATH


user=`cat .conf/profile | grep -w USER | cut -d '=' -f 2`
sed -e s:TOMCAT_HOME:$catalina_home:g .scripts/automate-tomcat.sh  > .scripts/tomcat-${user}.sh
mv -f .scripts/tomcat-${user}.sh /etc/init.d/tomcat-${user}
chmod +x /etc/init.d/tomcat-${user}
/sbin/chkconfig --add tomcat-${user}

sed -e s:CATALINA_PID=:CATALINA_PID=${user_home}/tomcat.pid:g ${catalina_home}/bin/catalina.sh > ${catalina_home}/bin/catalina-temp.sh
sed -e s:FORCE=0:FORCE=1:g ${catalina_home}/bin/catalina-temp.sh > ${catalina_home}/bin/catalina.sh
sed -e s,PATH=JAVA_BIN_PATH,PATH=$java_home/bin:'$PATH',g ${catalina_home}/bin/catalina.sh > ${catalina_home}/bin/catalina-temp.sh
mv -f ${catalina_home}/bin/catalina-temp.sh ${catalina_home}/bin/catalina.sh
sed -e s,JAVA_HOME=JAVA_HOME,JAVA_HOME=$java_home,g ${catalina_home}/bin/catalina.sh > ${catalina_home}/bin/catalina-temp.sh
mv -f ${catalina_home}/bin/catalina-temp.sh ${catalina_home}/bin/catalina.sh
sed -e s:PS_COMMAND:'ps -aef --columns 1024':g ${catalina_home}/bin/catalina.sh > ${catalina_home}/bin/catalina-temp.sh
mv -f ${catalina_home}/bin/catalina-temp.sh ${catalina_home}/bin/catalina.sh
sed -e s,PATH=JAVA_BIN_PATH,PATH=$java_home/bin:'$PATH',g ${catalina_home}/bin/setclasspath.sh > ${catalina_home}/bin/setclasspath-temp.sh
mv -f ${catalina_home}/bin/setclasspath-temp.sh ${catalina_home}/bin/setclasspath.sh
sed -e s,JAVA_HOME=JAVA_HOME,JAVA_HOME=$java_home,g ${catalina_home}/bin/setclasspath.sh > ${catalina_home}/bin/setclasspath-temp.sh
mv -f ${catalina_home}/bin/setclasspath-temp.sh ${catalina_home}/bin/setclasspath.sh
rm -f ${catalina_home}/bin/catalina-temp.sh
rm -f ${catalina_home}/bin/setclasspath-temp.sh
chown ${user}:${user} ${catalina_home}/bin/catalina.sh
chmod +x ${catalina_home}/bin/catalina.sh
chown ${user}:${user} ${catalina_home}/bin/setclasspath.sh
chmod +x ${catalina_home}/bin/setclasspath.sh
