#!/bin/sh

un=("#!/bin/sh")
echo $un > uninstall.sh
echo "user=(\`id | awk '{print \$1}'\`)" >> uninstall.sh
echo "user=\${user:6:4}" >> uninstall.sh
echo "if [ \$user = \"root\" ]; then" >> uninstall.sh

echo "echo \"INFO : This would remove the Cisco Insight Application and the corresponding database. If you wish to take a backup of the database schema, quit the un-installation and do so now.\"" >> uninstall.sh
echo "echo -n \"INPUT : Do you want to continue? [Y/N] (default Y): \"" >> uninstall.sh
echo "read UNINSTALL_ANSWER" >> uninstall.sh
echo "if [ \"\$UNINSTALL_ANSWER\" = \"N\" -o \"\$UNINSTALL_ANSWER\" = \"n\" ]; then" >> uninstall.sh
	echo "exit 0" >> uninstall.sh
echo "else" >> uninstall.sh
#echo "echo -n \"INPUT : Enter the root password for MySQL: \" "  >> uninstall.sh
#echo "stty -echo" >> uninstall.sh
#echo "read MYSQL_USER_PASSWORD" >> uninstall.sh
#echo "stty echo" >> uninstall.sh
#echo "echo \"\" " >> uninstall.sh
DEFAULT_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
MYSQL_USER_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`
#MYSQL_USER_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
#echo "if [ \${#MYSQL_USER_PASSWORD} -ne 0 ]; then
					#mysqladmin --user=root --password=$MYSQL_USER_PASSWORD version > /dev/null 2>&1
					#if [ \$? -ne 0 ]; then " >> uninstall.sh
#echo "echo \"MSG : Uninstallation was unable to connect to MySql server due to one of the following reasons\" " >> uninstall.sh	
#echo "echo \"1. Firewall is enabled and not configured to allow access to port 3306\" " >> uninstall.sh	
#echo "echo \"2. SE Linux is enabled and blocking access to port 3306\"" >> uninstall.sh	
#echo "echo \"3. Invalid MySql root password\"" >> uninstall.sh	
#echo "exit 1" >> uninstall.sh	
#echo "fi" 	>> uninstall.sh	
#echo "fi" 	>> uninstall.sh	
			
if [ -f .conf/user_answers.txt ]; then 
SILENT_INSTALLATION=`cat .conf/user_answers.txt | grep -w SILENT_INSTALLATION | cut -d '=' -f 2`
NEWUSER=`cat .conf/user_answers.txt | grep -w CREATE_NEW_USER | cut -d '=' -f 2`
fi

if [ ${#SILENT_INSTALLATION} -eq 0 ]; then
. .scripts/user.sh
fi

USER_EXISTS=`cat .conf/user_answers.txt | grep -w USER_EXISTS | cut -d '=' -f 2`
NEW_INSTALLATION=`cat .conf/user_answers.txt | grep -w NEW_INSTALLATION | cut -d '=' -f 2`


if [ $NEW_INSTALLATION -ne 0 ]; then
        if [ -f .conf/profile ]; then
                rm -f .conf/profile
        fi
fi

if [ $? = 1 ]; then
	echo "MSG : Issue asking for user name. Please check the logs"
elif [ $USER_EXISTS = 1 ] && [ $NEW_INSTALLATION = 0 ]; then
	. .scripts/update.sh
else
	. .scripts/answers.sh 
	if [ $? = 1 ]; then
		echo "MSG : Issue asking option from user. Please check the logs"
	else	
		. .scripts/java-install.sh 
		if [ $? = 1 ]; then
			echo "MSG : Issue installing java. Please check the logs"
		else
			. .scripts/mysql-install.sh 
			if [ $? = 1 ]; then
				echo "MSG : Issue installing mysql. Please check the logs"
			else
				. .scripts/create-user.sh 
				if [ $? = 1 ]; then
					echo "MSG : Issue creating user. Please check the logs"
				else
					. .scripts/install-app.sh 
					if [ $? = 1 ]; then
						echo "MSG : Issue installing application. Please check the logs"
					else
						. .scripts/setenv.sh 
						echo "INFO : Proceeding to configuration"
					fi
				fi
			fi
	
		fi
	fi

echo "fi" >> uninstall.sh
echo "else" >> uninstall.sh
echo "echo \"INFO : You must be root to launch the un-installation script\"" >> uninstall.sh
echo "fi" >> uninstall.sh

echo $un > backup.sh
echo "user=(\`id | awk '{print \$1}'\`)" >> backup.sh
echo "user=\${user:6:4}" >> backup.sh
echo "if [ \$user = \"root\" ]; then" >> backup.sh
echo "PREDATE=\`date --date=\"-1 days\" +%Y-%m-%d\`" >> backup.sh
echo "LOG_DIR=\$1" >> backup.sh
echo "OUTPUT_DIR=\$2" >> backup.sh
echo "SQL_FILE=\$3" >> backup.sh
echo "if [ \$# -lt 3 ]; then" >> backup.sh
echo "echo \"INFO : To execute this script please provide all the 3 arguments(log directory, output directory and sql file)\"">> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "if [ -d \$LOG_DIR ]; then" >> backup.sh
echo "echo \"\"" >> backup.sh
echo "else" >> backup.sh
echo "echo \"MSG : Log directory does not exists\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "if [ -d \$OUTPUT_DIR ]; then" >> backup.sh
echo "echo \"\"" >> backup.sh
echo "else" >> backup.sh
echo "echo \"MSG : Output directory does not exists\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "if [ -f \$SQL_FILE ]; then" >> backup.sh
echo "if [ -r \$SQL_FILE ]; then" >> backup.sh
echo "echo \"\"" >> backup.sh
echo "else" >> backup.sh
echo "echo \"MSG : Cannot read sql file\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "echo \"MSG : Sql file does not exists\"" >> backup.sh
echo "exit 1" >> backup.sh
echo "fi" >> backup.sh
echo "mkdir \$OUTPUT_DIR/\$PREDATE" >> backup.sh
echo "PWDIR=\`pwd\`" >> backup.sh
echo "cd \$LOG_DIR" >> backup.sh
echo "zip -r logs.zip *" >> backup.sh
echo "cd \$PWDIR" >> backup.sh
echo "mv -f \$LOG_DIR/logs.zip \$OUTPUT_DIR/\$PREDATE" >> backup.sh
mysql_user=`cat .conf/profile | grep -w DB_USER | cut -d '=' -f 2`
mysql_password=`cat .conf/profile | grep -w DB_PASSWORD | cut -d '=' -f 2`
mysql_schema=`cat .conf/profile | grep -w DB_SCHEMA | cut -d '=' -f 2`
mysql_quartz_schema=`cat .conf/profile | grep -w QUARTZ_DB_SCHEMA | cut -d '=' -f 2`
mysql=`cat .conf/profile | grep -w MYSQL_BIN | cut -d '=' -f 2`
echo "tables=\`cat \$SQL_FILE\`" >> backup.sh
echo "if [ \${#4} -ne 0 ]; then" >> backup.sh
echo "if [ \`echo \$4 | tr [:upper:] [:lower:]\` = \"tables\" ]; then" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password $mysql_schema \$tables > \$OUTPUT_DIR/\$PREDATE/sql_output.sql" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password $mysql_quartz_schema > \$OUTPUT_DIR/\$PREDATE/quartz_sql_output.sql" >> backup.sh
echo "else" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_schema > \$OUTPUT_DIR/\$PREDATE/sql_output.sql" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_quartz_schema > \$OUTPUT_DIR/\$PREDATE/quartz_sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_schema > \$OUTPUT_DIR/\$PREDATE/sql_output.sql" >> backup.sh
echo "${mysql}/mysqldump --user=$mysql_user --password=$mysql_password -B $mysql_quartz_schema > \$OUTPUT_DIR/\$PREDATE/quartz_sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "PWDIR=\`pwd\`" >> backup.sh
echo "cd \$OUTPUT_DIR/\$PREDATE" >> backup.sh
echo "zip sql.zip sql_output.sql" >> backup.sh
echo "if [ \$? -ne 0 ]; then" >> backup.sh
echo "if [ -f sql.zip ]; then" >> backup.sh
echo "rm -f sql.zip" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "rm -f sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "zip quartz_sql.zip quartz_sql_output.sql" >> backup.sh
echo "if [ \$? -ne 0 ]; then" >> backup.sh
echo "if [ -f quartz_sql.zip ]; then" >> backup.sh
echo "rm -f quartz_sql.zip" >> backup.sh
echo "fi" >> backup.sh
echo "else" >> backup.sh
echo "rm -f quartz_sql_output.sql" >> backup.sh
echo "fi" >> backup.sh
echo "cd \$PWDIR" >> backup.sh
echo "cd \$OUTPUT_DIR" >> backup.sh
echo "zip -r \$PREDATE.zip \$PREDATE" >> backup.sh 
echo "rm -rf \$PREDATE" >> backup.sh
echo "cd \$PWDIR" >> backup.sh
echo "else" >> backup.sh
echo "echo \"INFO : You must be root to launch the backup script\"" >> backup.sh
echo "fi" >> backup.sh



echo $un > config.sh
user=`cat .conf/profile | grep -w USER | cut -d '=' -f 2`
app_home=`cat .conf/profile | grep -w APP_HOME | cut -d '=' -f 2`

echo "insight_properties_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties" >> config.sh
echo "if [ -f \$insight_properties_file ]; then" >> config.sh
echo "insight_properties_temp_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties.tmp" >> config.sh
echo "insight_properties_backup_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties.backup" >> config.sh

echo "cp -f \$insight_properties_file \$insight_properties_backup_file" >> config.sh
echo "#jdbc host" >> config.sh
echo "jdbc_host=\`cat \$insight_properties_file | grep -w jdbc.host | cut -d'=' -f 2 | tr -d '\\r\\n\\t'\`" >> config.sh

if [ ${#SILENT_INSTALLATION} -eq 0 ]; then
echo "SILENT_INSTALLATION=0" >> config.sh
else
echo "SILENT_INSTALLATION=1" >> config.sh
fi

echo "if [ \$SILENT_INSTALLATION -eq 0 ]; then" >> config.sh
#commented by rahul to remove question for user to enter remote host name
#echo "if [ \${#jdbc_host} -ne 0 ]; then" >> config.sh
#echo "echo -n \"INPUT : Enter the Insight local database host name (default is \${jdbc_host}):\"" >> config.sh
#echo "else" >> config.sh
echo "if [ \${#jdbc_host} -eq 0 ]; then" >> config.sh
echo "echo -n \"INPUT : Enter the Insight local database host name:\"" >> config.sh
echo "read host" >> config.sh
echo "fi" >> config.sh
echo "if [ \${#host} -ne 0 ]; then" >> config.sh
echo "sed '/^jdbc.host/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.host=\$host\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh
echo "fi" >> config.sh


echo "#jdbc port" >> config.sh
echo "jdbc_port=\`cat \$insight_properties_file | grep -w jdbc.port | cut -d'=' -f 2 | tr -d '\\r\\n\\t'\`" >> config.sh

echo "if [ \$SILENT_INSTALLATION -eq 0 ]; then" >> config.sh
echo "if [ \${#jdbc_port} -ne 0 ]; then" >> config.sh
echo "echo -n \"INPUT : Enter the Insight local database port (default is \${jdbc_port}):\"" >> config.sh
echo "else" >> config.sh
echo "echo -n \"INPUT : Enter the Insight local database port :\"" >> config.sh
echo "fi" >> config.sh
echo "read port" >> config.sh
echo "if [ \${#port} -ne 0 ]; then" >> config.sh
echo "sed '/^jdbc.port/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.port=\$port\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh
echo "fi" >> config.sh

echo "#jdbc username" >> config.sh
newdbuser=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
if [ ${#newdbuser} -eq 0 ]; then
echo "newdbuser=insight_admin">> config.sh
else
echo "newdbuser=$newdbuser">> config.sh
fi
echo "sed '/^jdbc.username/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.username=\$newdbuser\" >> \$insight_properties_file" >> config.sh
echo "" >> config.sh

echo "#jdbc password" >> config.sh
newdbuserpass=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
if [ ${#newdbuserpass} -eq 0 ]; then
echo "newdbuserpass=insight_admin">> config.sh
else
echo "newdbuserpass=$newdbuserpass">> config.sh
fi
echo "sed '/^jdbc.password/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.password=\$newdbuserpass\" >> \$insight_properties_file" >> config.sh
echo "" >> config.sh


echo "sed '/^log4jfilepath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\nlog4jfilepath=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml\" >> \$insight_properties_file" >> config.sh
echo "" >> config.sh

echo "db_schema=$mysql_schema" >> config.sh
echo "if [ \${#db_schema} -ne 0 ]; then" >> config.sh
echo "sed '/^jdbc.db.schema/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\njdbc.db.schema=\$db_schema\" >> \$insight_properties_file" >> config.sh
echo "fi" >> config.sh
echo "" >> config.sh

echo "#insight properties file" >> config.sh
echo "sed '/^insightpropertiespath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\ninsightpropertiespath=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties\">> \$insight_properties_file" >> config.sh

echo "sed '/^thresholdFile/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\nthresholdFile=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/threshold_master.xml\">> \$insight_properties_file" >> config.sh

echo "sed '/^templatePath/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "echo -e \"\\ntemplatePath=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/template/\">> \$insight_properties_file" >> config.sh

echo "if [ \${#host} -eq 0 ]; then" >> config.sh
	echo "host=\"127.0.0.1\"">> config.sh
echo "fi" >> config.sh
echo "if [ \${#port} -eq 0 ]; then" >> config.sh
	echo "port=\"3306\"" >> config.sh
echo "fi" >> config.sh
newdbschema=`cat .conf/user_answers.txt | grep -w NEW_DB_SCHEMA_NAME | cut -d '=' -f 2`
echo "quartz_properties_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties" >> config.sh
echo "if [ -f \$quartz_properties_file ]; then" >> config.sh
echo "quartz_properties_temp_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties.tmp" >> config.sh
echo "quartz_properties_backup_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties.backup" >> config.sh

echo "cp -f \$quartz_properties_file \$quartz_properties_backup_file" >> config.sh
echo "#quartz db url" >> config.sh
echo "sed '/^org.quartz.dataSource.quartzDB.URL/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
if [ ${#newdbschema} -eq 0 ]; then
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.URL=jdbc:mysql://\${host}:\${port}/insight_quartz\" >> \$quartz_properties_file" >> config.sh
else
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.URL=jdbc:mysql://\${host}:\${port}/\${db_schema}_quartz\" >> \$quartz_properties_file" >> config.sh
fi
echo "" >> config.sh

echo "#quartz db user" >> config.sh
echo "sed '/^org.quartz.dataSource.quartzDB.user/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
if [ ${#newdbschema} -eq 0 ]; then
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.user=insight_admin\" >> \$quartz_properties_file" >> config.sh
else
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.user=\${db_schema}\" >> \$quartz_properties_file" >> config.sh
fi
echo "" >> config.sh

echo "#quartz db password" >> config.sh
echo "sed '/^org.quartz.dataSource.quartzDB.password/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
if [ ${#newdbschema} -eq 0 ]; then
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.password=insight_admin\" >> \$quartz_properties_file" >> config.sh
else
	echo "echo -e \"\\norg.quartz.dataSource.quartzDB.password=\${db_schema}\" >> \$quartz_properties_file" >> config.sh
fi
echo "" >> config.sh

current_path=`pwd`
app_path=$current_path/Insight/bin

template_path=$app_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/template/
grep item_id=208 "$app_path/update.sql_backup" | sed -e "s;selected_values=;selected_values='$template_path';" >> update.sql

gallery_path=$app_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/gallery
grep item_id=206 "$app_path/update.sql_backup" | sed -e "s;selected_values=;selected_values='$gallery_path';" >> update.sql

log_file_path=$app_home/apache-tomcat-6.0.20/logs/logs.log
grep item_id=217 "$app_path/update.sql_backup" | sed -e "s;selected_values=;selected_values='$log_file_path';" >> update.sql

script_path=$app_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/monitoring/
grep item_id=427 "$app_path/update.sql_backup" | sed -e "s;selected_values=;selected_values='$script_path';" >> update.sql

file_path=$app_home/scheduleReports/
grep item_id=207 "$app_path/update.sql_backup" | sed -e "s;selected_values=;selected_values='$file_path';" >> update.sql


chmod 755 update.sql
chmod +x ${script_path}system_stat.sh
dos2unix ${script_path}system_stat.sh > /dev/null 2>&1
DEFAULT_PASSWORD=`cat .conf/user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
passwd=`echo $DEFAULT_PASSWORD | base64 --decode -i`
#passwd=`cat .conf/user_answers.txt | grep -w INSTALLED_MYSQL_ROOT_PASSWORD | cut -d '=' -f 2`
if [ ${#newdbschema} -eq 0 ]; then
        mysql -uroot -p$passwd insight < update.sql
else
        mysql -uroot -p$passwd $newdbschema < update.sql
fi

log4j_xml_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml
log4j_xml_temp_file=$INSIGHT_HOME/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml.tmp
sed -e s:../logs/:$app_home/apache-tomcat-6.0.20/logs/:g $log4j_xml_file > $log4j_xml_temp_file
mv -f $log4j_xml_temp_file $log4j_xml_file
chown $user:$user $log4j_xml_file


echo "#remove all empty lines" >> config.sh
echo "sed '/^\$/d' \$insight_properties_file > \$insight_properties_temp_file" >> config.sh
echo "mv -f \$insight_properties_temp_file \$insight_properties_file" >> config.sh
echo "chown $user:$user \$insight_properties_file" >> config.sh
echo "chown $user:$user \$insight_properties_backup_file" >> config.sh
echo "else" >> config.sh
echo "echo \"MSG : Unable to find configuration properties file\"" >> config.sh
echo "fi" >> config.sh

echo "#remove all empty lines" >> config.sh
echo "sed '/^\$/d' \$quartz_properties_file > \$quartz_properties_temp_file" >> config.sh
echo "mv -f \$quartz_properties_temp_file \$quartz_properties_file" >> config.sh
echo "chown $user:$user \$quartz_properties_file" >> config.sh
echo "chown $user:$user \$quartz_properties_backup_file" >> config.sh
echo "else" >> config.sh
echo "echo \"MSG : Unable to find quartz configuration properties file\"" >> config.sh
echo "fi" >> config.sh

if [ ${#SILENT_INSTALLATION} -ne 0 ]; then
		cp $current_path/.pkgrpm/traffic_data_update.sql $INSIGHT_HOME/apache-tomcat-6.0.20/
		echo "if [ \"\$para\" = \"start\" ] ; then" >> $insight_home/apache-tomcat-6.0.20/bin/catalina.sh		
		#echo "mysql --user=root --password=$passwd < ../traffic_data_update.sql" >> $insight_home/apache-tomcat-6.0.20/bin/catalina.sh		
		echo "fi" >> $insight_home/apache-tomcat-6.0.20/bin/catalina.sh		
fi

DEFAULT_PASSWORD=`cat .conf/user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
NEW_MYSQL_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`

update_password=`query="UPDATE mysql.user SET Password=PASSWORD('$NEW_MYSQL_PASSWORD') WHERE User='root'"
mysql -uroot -p$NEW_MYSQL_PASSWORD  << eof
$query
eof`

grant_access=`query="GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED BY '$NEW_MYSQL_PASSWORD' WITH GRANT OPTION"
mysql -uroot -p$NEW_MYSQL_PASSWORD  << eof
$query
eof`

/etc/init.d/mysql stop
/etc/init.d/mysql start

if [ -f .conf/profile ]; then
	user_home=`cat .conf/profile | grep -w USER_HOME | cut -d '=' -f 2`
        if [ ${#user_home} -ne 0 ]; then
		chmod 755 uninstall.sh
		chmod 755 backup.sh
		chmod 755 config.sh
		chmod 755 update.sql
		mv uninstall.sh $user_home/Insight/bin
		mv backup.sh $user_home/Insight/bin
		mv config.sh $user_home/Insight/bin
		mv update.sql $user_home/Insight/bin
		chown -R $user:$user $user_home
		chown root:root $user_home/Insight/bin/uninstall.sh
		chown root:root $user_home/Insight/bin/backup.sh
		PWD=`pwd`
                cd $user_home/Insight/bin
                . ./config.sh
                cd $PWD
				if [ ${#SILENT_INSTALLATION} -eq 1 ]; then										
					cd /home/$NEWUSER/Insight/apache-tomcat-6.0.20/bin/
					sh catalina.sh start
				fi				
		echo "INFO : CONGRATS!! Installation finished"
		echo "INFO : To re-configure the application please execute config.sh in the $user_home/Insight/bin"
		echo "INFO : To uninstall the application please execute uninstall.sh in the $user_home/Insight/bin"
		echo "INFO : To bundle the logs please execute backup.sh in the $user_home/Insight/bin"
	else
		rm -f uninstall.sh
		rm -f backup.sh
		rm -f config.sh
		rm -f update.sql
	fi
else
	rm -f uninstall.sh
	rm -f backup.sh
	rm -f config.sh
	rm -f update.sql
fi
fi


