#!/bin/sh
#. .scripts/jre_mysql_install.sh
#. .scripts/upgrade-uninstall.sh
#. .scripts/mysql-install.sh

CREATE_NEW_USER=`cat .conf/user_answers.txt | grep -w CREATE_NEW_USER | cut -d '=' -f 2`

if [ -d .backup ]; then
	rm -rf .backup
fi
mkdir .backup
mkdir .backup/properties
mkdir .backup/db
mkdir .backup/class
mkdir .backup/gallery

#user_home=`cat .conf/profile | grep -w USER_HOME | cut -d '=' -f 2`
user_home=/home/$CREATE_NEW_USER
if [ -d ${user_home}/Insightv2 ]; then
	insight_home=$user_home/Insightv2
else
	insight_home=$user_home/Insight
fi

cp -r $insight_home .backup/class
if [ $? != 0 ]; then
	echo "MSG : Backup of Insight fail."
	exit 1
fi

insight_properties_file=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties
quartz_properties_file=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/quartz.properties
log4j_properties_file=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml

cp -r $insight_properties_file .backup/properties
cp -r $quartz_properties_file .backup/properties
cp -r $log4j_properties_file .backup/properties



usrname=`cat .backup/properties/insight.properties | grep -w jdbc.username | cut -d '=' -f 2`
passwrd=`cat .backup/properties/insight.properties | grep -w jdbc.password | cut -d '=' -f 2`
if [ ${#passwrd} -ne 0 ]; then
	#mysqladmin --user=$usrname --password=$passwrd version > /dev/null 2>&1
	version_comment=`query="SHOW VARIABLES WHERE Variable_name='version_comment'"
mysql -u$usrname -p$passwrd --skip-column-names << eof
$query
eof`
	if [ $? -ne 0 ]; then
		echo "MSG : Installation was unable to connect to MySql server due to one of the following reasons"
		echo "1. Firewall is enabled and not configured to allow access to port 3306"
		echo "2. SE Linux is enabled and blocking access to port 3306"
		echo "3. Invalid MySql root password"
		exit 1
	fi
else
	echo "MSG : Mysql root password is not valid in insight.properties."
	exit 1
fi

version_comment=`query="SHOW VARIABLES WHERE Variable_name='version_comment'"
mysql -u$usrname -p$passwrd --skip-column-names << eof
$query
eof`
if [ $? -ne 0 ];then
	echo "MSG : Installation was unable to connect to MySql server due to one of the following reasons"
	echo "1. Firewall is enabled and not configured to allow access to port 3306"
	echo "2. SE Linux is enabled and blocking access to port 3306"
	echo "3. MySql root password is not compatible with Insight reporter."
	exit 1;
fi 

echo "$version_comment" | grep 'MySQL Enterprise Server' &> /dev/null
if [ $? == 0 ]; then
	echo ""
else
	echo "An existing MySQL installation is detected on your system which is not compatible with Cisco Insight Reporter. Please use MySQL Enterprise Server - Advanced Edition 
(Commercial) only packaged with installation package."
	exit 1;		
fi

insight_db=`cat .backup/properties/insight.properties | grep -w jdbc.db.schema | cut -d '=' -f 2`
insight_quartz_db=${insight_db}_quartz
echo "INSIGHT_DB=$insight_db" >> .conf/user_answers.txt
echo "INSIGHT_QUARTZ_DB=$insight_quartz_db" >> .conf/user_answers.txt 

count=`query="SELECT COUNT(*) FROM tables WHERE table_schema ='$insight_db'"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names  information_schema<< eof
$query
eof`
if [ $count = 0 ]; then
	echo "MSG : Insight local database not found.Exiting the script."
	exit 1
fi

count_quartz=`query="SELECT COUNT(*) FROM tables WHERE table_schema ='$insight_quartz_db'"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names  information_schema<< eof
$query
eof`
if [ $count_quartz = 0 ]; then
        echo "MSG : Insight quartz database not found.Exiting the script."
        exit 1
fi
#Added by rahul for 3.6.5 and older remove changes start.
count_schema=`query="SELECT COUNT(*) FROM remote_db_param WHERE db_schema_version IN ('3.5.0','3.5.5','3.6.0')"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names $insight_db<< eof
$query
eof`
if [ $count_schema != 0 ]; then
		echo "Error : (Existing Network found using 3.6.0 or lower CM schema version)."
		echo "MSG : Now supported CM schema version are 3.6.5 and above."
		echo "MSG : Please remove any configured network using 3.6.0 or lower CM schema versions and then retry for upgrade."
		echo "MSG : Exits from Insight Upgrade! "
		exit 1
fi
#Added by rahul for 3.6.5 and older remove changes end.
#Added by rahul for SCE1K and SCE2K changes start.
count_device=`query="SELECT COUNT(*) FROM device WHERE device_type_id <>'1'"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names $insight_db<< eof
$query
eof`
if [ $count_device != 0 ]; then
		echo "MSG : Old device models found : Starting from this release 5.2.0, only SCE8000 model is supported."
		echo "MSG : Since only SCE8000 is supported, now it will be referred as generic 'SCE'."
		echo "MSG : After upgrade model types of all devices will become 'SCE'."
		echo "MSG : For further information, please refer installation guide."
		echo -n "Input:  Do you still want to proceed? [Y/N] : "
		read schema_version
		if [ "$schema_version" = 'N' -o "$schema_version" = 'n' ]; then
			echo "Terminating upgrade ... "
			exit 1
			else
			mysql --version >/dev/null 2>&1
			if [ $? -eq 0 ]; then
				contr=(`mysql --version | awk '{print $5}' | sed s:,::g`)
				controllo=(`echo ${contr:0:3}`)
				if [ "$controllo" \< "5.6" ]; then
				echo
				else
update_schema=`query="UPDATE device SET device_type_id ='1' WHERE device_type_id <>'1'"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names $insight_db<< eof
$query
eof`
				echo "MSG : Model type has been changed to 'SCE' successfully ."
				fi
			fi	
		fi
fi
#Added by rahul for SCE1K and SCE2K changes end.
gallery_path=`query="SELECT selected_values FROM config_system_param where item ='"GALLERY_DESTINATION_PATH"'"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names $insight_db<< eof
$query
eof`

#gallery_path=`query="SELECT selected_values FROM config_system_param where item ='"GALLERY_DESTINATION_PATH"'"
#/usr/bin/mysql -uinsight_admin -pinsight_admin --skip-column-names insight<< eof
#$query
#eof`

cp -r $gallery_path .backup/gallery/
if [ $? != 0 ]; then
        echo "MSG : Gallery backup fail."
        exit 1
fi
echo "GALLERY__PATH=$gallery_path" >> .conf/user_answers.txt

avc_network=`query="SELECT COUNT(*) FROM remote_db_param where device_family =2"
/usr/bin/mysql -u$usrname -p$passwrd --skip-column-names $insight_db<< eof
$query
eof`
if [ $avc_network != 0 ]; then
        echo "Error : (AVC device found) Insight V4.0.0 upgradation can not proceed."
		echo "      : Please delete AVC device then try to upgrade again."
		echo "      : For further information, please refer the installation guide."
        exit 1
fi


#changed by rahul to upgrade mysql only after all condition satisfied 
. .scripts/jre_mysql_install.sh
. .scripts/upgrade-uninstall.sh
#. .scripts/mysql-install.sh
#changed by rahul to upgrade mysql only after all condition satisfied

DEFAULT_PASSWORD=`cat .pkgrpm/silent_user_answers.txt | grep -w DEFAULT_ID | cut -d '=' -f 2`
NEW_MYSQL_PASSWORD=`echo $DEFAULT_PASSWORD | base64 --decode -i`
delete_users=`query="DELETE FROM mysql.user WHERE User not in('root','$usrname')"
/usr/bin/mysql -uroot -p$NEW_MYSQL_PASSWORD --skip-column-names << eof
$query
eof`

. .scripts/db_backup.sh
if [ $? != 0 ]; then
	echo "MSG : Backup of insight database fail."
	exit 1
fi


if [ -f /home/$CREATE_NEW_USER/tomcat.pid ]; then
/etc/init.d/tomcat-$CREATE_NEW_USER stop
fi

if [ -d $insight_home/apache-tomcat-6.0.20/webapps/ROOT/ ]; then
	rm -rf $insight_home/apache-tomcat-6.0.20/webapps/ROOT/
fi
cp -r Insight/apache-tomcat-6.0.20/webapps/ROOT/ $insight_home/apache-tomcat-6.0.20/webapps/ROOT/
if [ $? != 0 ]; then
	echo "MSG : Issue deploying application."
	exit 1
fi

if [ -d $insight_home/apache-tomcat-6.0.20/webapps/insight/ ]; then

rm -rf $insight_home/apache-tomcat-6.0.20/webapps/insight/index.jsp
cp -rf Insight/apache-tomcat-6.0.20/webapps/insight/index.jsp $insight_home/apache-tomcat-6.0.20/webapps/insight/
if [ $? != 0 ]; then
	echo "MSG : Issue Copying index.jsp File."
	exit 1
fi
rm -rf $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/
cp -rf Insight/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/ $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/
if [ $? != 0 ]; then
	echo "MSG : Issue Copying Classes Folder."
	exit 1
fi
rm -rf $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/web.xml
cp -rf Insight/apache-tomcat-6.0.20/webapps/insight/WEB-INF/web.xml $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/
if [ $? != 0 ]; then
	echo "MSG : Issue Copying web.xml FIle."
	exit 1
fi

/bin/cp -rf Insight/apache-tomcat-6.0.20/webapps/insight/WEB-INF/lib/* $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/lib/
if [ $? != 0 ]; then
	echo "MSG : Issue Copying lib Folder."
	exit 1
fi
fi

rm -rf $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/lib/mysql-connector-java-commercial-5.1.13-bin.jar

if [ -f $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties ]; then
	rm -f $insight_properties_file
fi
echo -e \\nthresholdFile=$insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/threshold_master.xml>> .backup/properties/insight.properties
cp -r .backup/properties/insight.properties $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/

if [ -f $quartz_properties_file ]; then
	rm -f $quartz_properties_file
fi
cp -r .backup/properties/quartz.properties $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/

if [ -f $log4j_properties_file ]; then
	rm -f $log4j_properties_file
fi

if [ -f /etc/init.d/tomcat-${CREATE_NEW_USER} ]; then
	sed -e s:"Insightv2":"Insight":g /etc/init.d/tomcat-${CREATE_NEW_USER} > .scripts/tomcat-temp-${CREATE_NEW_USER}.sh
	mv .scripts/tomcat-temp-${CREATE_NEW_USER}.sh /etc/init.d/tomcat-${CREATE_NEW_USER}
	chmod +x /etc/init.d/tomcat-${CREATE_NEW_USER}
fi

cp -r .backup/properties/log4j.xml $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/

cp -r Insight/bin/update.sql_backup $insight_home/bin/
cp -r Insight/bin/Insight_restore.sh $insight_home/bin/
cp -r Insight/bin/Insight_backup.sh $insight_home/bin/
cp -r Insight/bin/Logs_Backup.sh $insight_home/bin/
cp -r Insight/about.txt $insight_home/

. .scripts/db_update.sh
if [ $? != 0 ]; then
        echo "MSG : Database update fail."
        exit 1
else
	if [ $insight_home=$user_home/Insightv2 ]; then
		sed -e s:"Insightv2":"Insight":g $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml > $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j.xml
		sed -e s:"<root>":"\n\t<appender class='org.apache.log4j.RollingFileAppender' name='thresholdAppender'>\n\t\t<param name='file' value='../logs/threshold.log' />\n\t\t<param name='threshold' value='debug' />\n\t\t<param name='MaxFileSize' value='10000KB' />\n\t\t<param name='MaxBackupIndex' value='10' />\n\t\t<layout class='org.apache.log4j.PatternLayout'>\n\t\t\t<param name='ConversionPattern' value='%d{yyyy-MM-dd} %d{HH\:mm\:ss} %m%n' />\n\t\t</layout>\n\t</appender>\n\n\t<logger additivity='false' name='com.cisco.insight.networktopology.threshold.logger'>\n\t\t\t<appender-ref ref='thresholdAppender' />\n\t</logger>\n\n\t<appender class='org.apache.log4j.RollingFileAppender' name='schfileAppender'>\n\t\t<param name='File' value='../logs/scheduler.log'/>\n\t\t<param name='MaxFileSize' value='10000KB'/>\n\t\t<param name='MaxBackupIndex' value='10'/>\n\t\t<layout class='org.apache.log4j.PatternLayout'>\n\t\t\t<param name='ConversionPattern' value='%d{yyyy-MM-dd} %d{HH\:mm\:ss} %5p %l - %m%n'/>\n\t\t</layout>\n</appender>\n\n<logger additivity='false' name='com.cisco.insight.reporting.scheduler'>\n\t\t\t<appender-ref ref='schfileAppender'/>\n\t</logger>\n\n\t<root>":g $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j.xml > $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j1.xml
		sed -e s:../logs/threshold.log:$insight_home/apache-tomcat-6.0.20/logs/threshold.log:g $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j1.xml > $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j2.xml
		sed -e s:../logs/scheduler.log:$insight_home/apache-tomcat-6.0.20/logs/scheduler.log:g $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j2.xml > $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j3.xml
		mv $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j3.xml $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/log4j.xml
		rm -rf $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j.xml
		rm -rf $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j1.xml
		rm -rf $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_log4j2.xml		
		sed -e s:"Insightv2":"Insight":g $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties > $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_insight.properties
		mv $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/temp_insight.properties $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties
		sed -e s:"Insightv2":"Insight":g $insight_home/bin/config.sh > $insight_home/bin/temp_config.sh		
		mv $insight_home/bin/temp_config.sh $insight_home/bin/config.sh		
		chmod 777 $insight_home/bin/config.sh		
		sed -e s:"Insight v2":"Cisco Insight Reporter":g $insight_home/bin/uninstall.sh > $insight_home/bin/temp_uninstall.sh
		mv $insight_home/bin/temp_uninstall.sh $insight_home/bin/uninstall.sh
		chmod 777 $insight_home/bin/uninstall.sh
		sed -e s:"Insightv2":"Insight":g $insight_home/bin/update.sql > $insight_home/bin/temp_update.sql
		echo "UPDATE config_system_param set selected_values='$insight_home/scheduleReports/' where item_id=207;" >> $insight_home/bin/temp_update.sql
		mv $insight_home/bin/temp_update.sql $insight_home/bin/update.sql
		cp -u .backup/gallery/gallery/* $insight_home/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/gallery/		
		if [ -d ${user_home}/Insightv2 ]; then
			mv $user_home/Insightv2 $user_home/Insight
		fi	
		/usr/bin/mysql -u$usrname -p$passwrd $insight_db < $user_home/Insight/bin/update.sql
		
	fi   

/etc/init.d/mysql stop
/etc/init.d/mysql start	

/etc/init.d/tomcat-$CREATE_NEW_USER start

	#echo "INFO : Please start the Apache Tomcat server to make the Cisco Insight Reporter application up."
 	echo "INFO : CONGRATS!! Upgrade successfully completed."
fi