#!/bin/sh

if [ -f .conf/user_answers.txt ]; then
	rm -f .conf/user_answers.txt
fi

until [[ ${#CREATE_NEW_USER} -ne 0 ]] && [[ ${#OUTPUT} -eq 0 ]] && [[ ${#USER_EXISTS} -eq 0 ]];
	do
		echo -n "INPUT : Enter the OS username that will be used to install/upgrade (root not allowed):"
		read CREATE_NEW_USER
		if [ ${#CREATE_NEW_USER} -eq 0 ]; then
			echo "MSG : Please enter a valid value of the user"
		elif [ $CREATE_NEW_USER = "root" ]; then
			echo "MSG : Please enter a valid value of the user (root not allowed)"
				CREATE_NEW_USER=""			
		else	
			copy_user=$CREATE_NEW_USER
			len=${#CREATE_NEW_USER}		
			if [ $len -gt 31 ]; then
			echo "MSG : Length of entered OS username is greater than 31. length of OS user should be equal or less than 31"
			CREATE_NEW_USER=""
			fi			
			
			for ((i=1;i<=len;i++))
			do
				char=`echo $copy_user|cut -c$i`
				if [ -z $(echo $char | sed -e 's/[0-9]//g' | sed  -e 's/[A-Z]//g' | sed  -e 's/[a-z]//g' | (sed -e 's/'.'//g' | sed -e 's/'_'//g' | sed -e 's/'-'//g' ))]; then
					continue
				else										
					echo "MSG : Username should not have special symbol." 				
					CREATE_NEW_USER=""				
					break
				fi
			done				
			if [ ${#CREATE_NEW_USER} -ne 0 ]; then
			OUTPUT=`ls -1 /home | grep -w $CREATE_NEW_USER`
			USER_EXISTS=`cat /etc/passwd | grep -w $CREATE_NEW_USER`
			if [ ${#OUTPUT} -ne 0 ] || [ ${#USER_EXISTS} -ne 0 ] ; then
				#echo "${CREATE_NEW_USER} already exists! Please enter a valid user"
				echo "CREATE_NEW_USER=$CREATE_NEW_USER" >> .conf/user_answers.txt
				break	
			else
				echo "CREATE_NEW_USER=$CREATE_NEW_USER" >> .conf/user_answers.txt
				break
			 fi			 
			fi
		fi
	done

if [ ${#USER_EXISTS} -ne 0 ]; then
	if [ -d /home/$CREATE_NEW_USER/Insightv2/apache-tomcat-6.0.20 ] || [ -d /home/$CREATE_NEW_USER/Insight/apache-tomcat-6.0.20 ]; then
		echo "USER_EXISTS=1" >> .conf/user_answers.txt
		echo "NEW_INSTALLATION=0">> .conf/user_answers.txt
	else
		echo "USER_EXISTS=1" >> .conf/user_answers.txt
		echo "NEW_INSTALLATION=1">> .conf/user_answers.txt
	fi
else
        echo "USER_EXISTS=0" >> .conf/user_answers.txt
        echo "NEW_INSTALLATION=1">> .conf/user_answers.txt
fi

