#!/bin/bash

OPERATING_SYSTEM=`uname`
WORD_COUNT=
VMSTAT_HEADER=
WORD_AT_COLUMN=""
COLUMN_NUMBER=
CPU_IDLE_TIME=
CPU_USAGE=0
TOTAL_MEMORY=
FREE_MEMORY=
MEMORY_USED=
BAD_ARGUMENTS_ERROR=500

if [ $# != 2 ]
then
        echo "Error : Invalid Number of arguments"
        exit $BAD_ARGUMENTS_ERROR
fi

if [ "$OPERATING_SYSTEM" = "Linux" ]
then
        if [ $1 = "cpu" ]
        then
                VMSTAT_HEADER=`vmstat| head -2 | tail -1`
                WORD_COUNT=`echo $VMSTAT_HEADER | wc -w`

                for (( i = 1  ; i <= $WORD_COUNT ; i++ ))
                do
                        WORD_AT_COLUMN=`echo $VMSTAT_HEADER | awk '{print $'$i'}'`
                        if [ $WORD_AT_COLUMN = id ]
                        then
                                COLUMN_NUMBER=$i
                                break
                        fi
                done

                CPU_IDLE_TIME=`vmstat $2 2 | tail -1 | awk '{print $'$COLUMN_NUMBER'}'`
                CPU_USAGE=`echo 100-$CPU_IDLE_TIME|bc`

                echo $CPU_USAGE

        elif [ $1 = "mem" ]
        then

                TOTAL_MEMORY=`free | head -2 | tail -1 | awk '{print $2}'`
                FREE_MEMORY=`free | head -2 | tail -1 | awk '{print $4}'`
                TEMP=`echo $TOTAL_MEMORY - $FREE_MEMORY | bc`
                TEMP1=`echo $TEMP \* 100 | bc`
                MEMORY_USED=`echo $TEMP1 / $TOTAL_MEMORY | bc`

                echo $TOTAL_MEMORY
                echo $FREE_MEMORY
                echo $TEMP
                echo $TEMP1
                echo $MEMORY_USED
        fi

elif [ "$OPERATING_SYSTEM" = "SunOS" ]
then

        if [ $1 = "cpu" ]
        then
                VMSTAT_HEADER=`vmstat| head -2 | tail -1`
                WORD_COUNT=`echo $VMSTAT_HEADER | wc -w`

                for (( i = 1  ; i<=WORD_COUNT ; i++ ))
                do
                        WORD_AT_COLUMN=`echo $VMSTAT_HEADER | awk '{print $'$i'}'`
                        if [ $WORD_AT_COLUMN = id ]
                        then
                                COLUMN_NUMBER=$i
                                break
                        fi
                done

                CPU_IDLE_TIME=`vmstat $2 2 | tail -1 | awk '{print $'$COLUMN_NUMBER'}'`
                CPU_USAGE=`echo 100-$CPU_IDLE_TIME|bc`

                echo $CPU_USAGE

        elif [ $1 = "mem" ]
        then
                TOTAL_MEMORY_IN_MB=`/usr/sbin/prtconf | head -2 | tail -1 | awk '{print $3}'`
                TOTAL_MEMORY=`echo $TOTAL_MEMORY_IN_MB\*1024|bc`

                VMSTAT_HEADER=`vmstat| head -2 | tail -1`
                WORD_COUNT=`echo $VMSTAT_HEADER | wc -w`

                for (( i=1 ; i<=WORD_COUNT ;  i++ ))
                do
                        WORD_AT_COLUMN=`echo $VMSTAT_HEADER | awk '{print $'$i'}'`
                        if [ $WORD_AT_COLUMN == "free" ]
                        then
                                COLUMN_NUMBER=$i
                                break
                        fi
                done

                FREE_MEMORY=`vmstat $2 2 | tail -1 | awk '{print $'$COLUMN_NUMBER'}'`

                TEMP=`echo $TOTAL_MEMORY-$FREE_MEMORY|bc`
                TEMP1=`echo $TEMP\*100| bc`
                MEMORY_USED=`echo $TEMP1/$TOTAL_MEMORY|bc`

                echo $MEMORY_USED
        fi
fi