<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:date="http://exslt.org/dates-and-times"
	extension-element-prefixes="date" xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" indent="yes" />
	<xsl:variable name="chartImageName" select="chartImageLocation" />
	<xsl:variable name="title-font-size">
		14pt
	</xsl:variable>
	<xsl:variable name="font-size">
		10pt
	</xsl:variable>
	<xsl:variable name="fontName">
		Times Roman
	</xsl:variable>
	<xsl:variable name="table_header_bg_color">
		#DCDCDC
	</xsl:variable>
	<xsl:variable name="table_row_bg_color">
		#FFFAF0
	</xsl:variable>
		<xsl:variable name="TodaysDate"
		select="java:format(java:java.text.SimpleDateFormat.new

('MMMM d, yyyy, h:mm:ss a (zz)'), java:java.util.Date.new())">
	</xsl:variable>
	<xsl:variable name="logoPath">
		<xsl:value-of select="//logoImagePath" />
	</xsl:variable>
	<xsl:template match="coverpage">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="coverpage"
					page-height="11in" page-width="8.5in" margin-top="0.5in"
					margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in">
					<fo:region-body margin-top="0.75in" margin-bottom="0.75in" />
					<fo:region-before extent="0.5in" />
					<fo:region-after extent="0.5in" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="coverpage">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block font-size="8pt">
						<fo:table table-layout="fixed" border-style="double">
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell color="grey">
										<fo:block>
											<fo:external-graphic src="url({$logoPath})"></fo:external-graphic>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block font-size="8pt" font-family="{$fontName}"
											text-align="center">
											<xsl:value-of select="productName" />
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block font-family="{$fontName}" text-align="right">
											<xsl:value-of select="$TodaysDate" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="8pt" text-align="right" font-family="{$fontName}">
						<xsl:value-of select="pageLabel"/>
						<fo:page-number />
						<xsl:value-of select="ofLabel"/>
						<fo:page-number-citation ref-id="last-page" />
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-weight="bold" font-size="8pt" font-family="{$fontName}"
						id="{generate-id(Title)}" break-before="page" text-align="center">
						<xsl:value-of select="reportData/@reportname" />
					</fo:block>
					<fo:block>
						<fo:table text-align="center">
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block text-align="left" font-size="8pt"
											font-family="{$fontName}" space-after="5pt">
											<fo:inline font-weight="bold"><xsl:value-of select="createdByLabel" /></fo:inline>
											<fo:inline font-style="italic"><xsl:value-of select="reportData/@creatorname" /></fo:inline>
										</fo:block>
									</fo:table-cell>
									
									<fo:table-cell>
										<fo:block text-align="right" font-size="8pt"
											font-family="{$fontName}" start-indent="8pt">
											<xsl:value-of select="totalPagesLabel" />
											<fo:page-number-citation ref-id="last-page" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								</fo:table-body>
							</fo:table>

										<fo:block font-size="8pt"
											font-family="{$fontName}" >
											<fo:inline font-weight="bold"><xsl:value-of select="description" /></fo:inline>
											<fo:inline font-style="italic"><xsl:value-of select="reportData/@description" /></fo:inline>
										</fo:block>
										<fo:block font-weight="bold" text-align="left" font-size="8pt"
											font-family="{$fontName}" >
											<xsl:value-of select="reportParamLabel" />
										</fo:block>
					</fo:block>
					<fo:block font-family="{$fontName}" font-size="8pt">
						<xsl:for-each select="reportData/subtitle">
							<fo:list-block>
								<fo:list-item>
									<fo:list-item-label>
										<fo:block></fo:block>
									</fo:list-item-label>
									<fo:list-item-body>
										<fo:block>
											<xsl:value-of select="." />
										</fo:block>
									</fo:list-item-body>
								</fo:list-item>
							</fo:list-block>
						</xsl:for-each>
					</fo:block>
					<fo:block>
					<fo:table text-align="center" >
						<fo:table-body>
						<xsl:for-each select="reportData/chartImageLocation">
									<xsl:variable name="chartImage" select=".">
									</xsl:variable>
									<fo:table-row>
										<fo:table-cell>	
										<fo:block>
											<fo:external-graphic src="url({$chartImage})"
												content-width="scale-to-fit" content-height="scale-to-fit" />
										</fo:block>
										</fo:table-cell>
									</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
					</fo:table>
					</fo:block>
					<fo:block>
						<xsl:apply-templates select="reportData/reportTable" />
					</fo:block>
					<fo:block id="last-page" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="tableMap">
		<fo:table>
			<fo:table-header>
				<fo:table-row>
					<xsl:for-each select="entry">
						<fo:table-cell>
							<fo:block background-color="silver" font-family="{$fontName}">
								<xsl:value-of select="key" />
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
				</fo:table-row>
			</fo:table-header>
			<fo:table-body>
				<xsl:for-each select="//value[1]/values">
					<fo:table-row>
						<xsl:for-each select="//value/values[position() = $row-no]">
							<fo:table-cell>
								<fo:block>
									<xsl:apply-templates />
								</fo:block>
							</fo:table-cell>
						</xsl:for-each>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:param name="row-no" select="position()" />
	<xsl:template name="row">
		<xsl:param name="row-no" />
		<xsl:for-each select="//value/values[position() = $row-no]">
			<fo:table-cell>
				<fo:block>
					<xsl:apply-templates />
				</fo:block>
			</fo:table-cell>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="duration">
		Time Interval:
		<xsl:value-of select="startDate" />
		-
		<xsl:value-of select="endDate" />
	</xsl:template>
	<xsl:template match="reportData/reportTable">
		<fo:table>
			<fo:table-header>
				<fo:table-row>
					<xsl:for-each select="headerLabels">
						<fo:table-cell>
							<fo:block font-size="8pt" background-color="{$table_header_bg_color}"
								font-family="{$fontName}">
								<xsl:value-of select="." />
							</fo:block>
						</fo:table-cell>
					</xsl:for-each>
				</fo:table-row>
			</fo:table-header>
			<fo:table-body>
				<xsl:for-each select="rows">
					<fo:table-row>
						<xsl:if test="(position() mod 2 = 1)">
							<xsl:attribute name="background-color">
							<xsl:value-of select="$table_row_bg_color" /></xsl:attribute>
						</xsl:if>
						<xsl:for-each select="values">
							<fo:table-cell>
								<fo:block font-size="8pt">
									<xsl:value-of select="." />
								</fo:block>
							</fo:table-cell>
						</xsl:for-each>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>
</xsl:stylesheet>