#!/bin/sh
user=(`id | awk '{print $1}'`)
user=${user:6:4}
if [ $user = "root" ]; then
echo "*******************************************************************************************************************************"
echo "**  Backup script is allow user to take backup of Insight at any point of time.                                              **"
echo "**  This script will ask for the operating system username chosen during the initial Insight Reporter installation procedure.**"
echo "**  User has to provide the MySQL password and the absolute path to store backup file.                                       **"
echo "**  The backup script will create back up of the Insight directory, Insight local schema, and quartz schema.                 **"
echo "*******************************************************************************************************************************"
echo -n ""

	echo -n "Please enter Insight User Name:"
	read USERNAME
	USER_EXISTS=`cat /etc/passwd | grep -w $USERNAME`
	if [ ${#USER_EXISTS} -ne 0 ] ; then
				 
		NEW_MYSQL_PASSWORD=`echo Q2lzY29AMTIz | base64 --decode -i`	
					mysqladmin --user=root --password=$NEW_MYSQL_PASSWORD version > /dev/null 2>&1
					if [ $? -ne 0 ]; then 
					echo "MSG : Backup script is unable to connect to MySql server due to one of the following reasons" 
					echo "1. Firewall is enabled and not configured to allow access to port 3306" 
					echo "2. SE Linux is enabled and blocking access to port 3306"
					echo "3. Invalid MySql root password"
					exit 1
					fi
		
		echo -n "Please enter absolute path where back up will be stored (For ex: /home/insight_backup/):"
		read OUTPUT_DIR
	if [ ${#OUTPUT_DIR} -ne 0 ]; then
		mkdir $OUTPUT_DIR
	else 
		echo "Please enter valid directory path!!!"
		exit 1
	fi
		PWDIR=`pwd`
		INSIGHT_DIR="/home/${USERNAME}/"
		cd $INSIGHT_DIR
		zip -r Insight.zip Insight/
		if [ $? -ne 0 ] ; then
		echo "Msg: Unable to Zip due to one of the following reasons"
		echo "1. Unexpected end of zip file." 
		echo "2. zip was unable to allocate enough memory."
		echo "2. zip could not open a specified file to read."
		exit 1
		fi
		mv -f $INSIGHT_DIR/Insight.zip $OUTPUT_DIR
		
		DATABASE_SCHEMA=`cat /home/$USERNAME/Insight/apache-tomcat-6.0.20/webapps/insight/WEB-INF/classes/conf/insight.properties | grep -w jdbc.db.schema | cut -d '=' -f 2`
		/usr/bin/mysqldump --user=$user --password=$MYSQL_ROOT_PASSWORD --routines --add-drop-database --add-drop-table -B $DATABASE_SCHEMA> $OUTPUT_DIR/schema.sql
		/usr/bin/mysqldump --user=$user --password=$MYSQL_ROOT_PASSWORD --routines --add-drop-database --add-drop-table -B "${DATABASE_SCHEMA}_quartz" > $OUTPUT_DIR/quartz.sql
		cd $OUTPUT_DIR
		echo "DROP USER '$DATABASE_SCHEMA';">mysqlcreateuser.sql
		echo "CREATE USER '$DATABASE_SCHEMA' IDENTIFIED BY '$DATABASE_SCHEMA';">>mysqlcreateuser.sql
		zip schema.zip schema.sql
		if [ $? -ne 0 ] ; then
		echo "Msg: Unable to Zip due to one of the following reasons"
		echo "1. Unexpected end of zip file." 
		echo "2. zip was unable to allocate enough memory."
		echo "2. zip could not open a specified file to read."
		exit 1
		fi
		if [ $? -ne 0 ]; then
			if [ -f schema.zip ]; then
				rm -f schema.zip
			fi
		else
		rm -f schema.sql
		fi
		zip quartz.zip quartz.sql
		if [ $? -ne 0 ] ; then
		echo "Msg: Unable to Zip due to one of the following reasons"
		echo "1. Unexpected end of zip file." 
		echo "2. zip was unable to allocate enough memory."
		echo "2. zip could not open a specified file to read."
		exit 1
		fi
		if [ $? -ne 0 ]; then
			if [ -f quartz.zip ]; then
				rm -f quartz.zip
			fi
		else
			rm -f quartz.sql
		fi
		echo $PWDIR
		cd $PWDIR
		cd $OUTPUT_DIR
		mkdir $USERNAME
		mv *.* ./$USERNAME
		cp /home/$USERNAME/Insight/bin/Insight_restore.sh $OUTPUT_DIR
		zip -r $USERNAME.zip $USERNAME
		if [ $? -ne 0 ] ; then
		echo "Msg: Unable to Zip due to one of the following reasons"
		echo "1. Unexpected end of zip file." 
		echo "2. zip was unable to allocate enough memory."
		echo "2. zip could not open a specified file to read."
		exit 1
		fi
		rm -rf $USERNAME/
		echo ""
		echo "Backup of '$USERNAME' have successfully created at '$OUTPUT_DIR'."
		else
		echo "User ${USERNAME} doest not exists! Please enter a valid user"
		break;				
	fi	
else
	echo "INFO : You must be root to launch the backup script"
fi