#!/bin/sh

user=(`id | awk '{print $1}'`)
user=${user:6:4}
if [ $user = "root" ]; then
echo "*****************************************************************************************"
echo "**  Restore script allow user to restore Insight instance from backup file.            **"
echo "**  Insight user should exist before start of restore process.                         **"
echo "**  The script will ask the backup file path and verify that the user exist or not.    **"
echo "**  User can backup and restore the same version of Insight Reporter only.             **"
echo "*****************************************************************************************"
echo -n ""

	echo -n "Please enter path where backup file is stored:"
	read INPUT_DIR
	cd $INPUT_DIR
	if [ $? -ne 0 ] ; then
		echo "Msg: Please check the path you entered."
	exit 1
	fi
	for file in `ls -a *.zip`
	do
	USERNAME=${file%.*}
	done
	USER_EXISTS=`cat /etc/passwd | grep -w $USERNAME`
	if [ ${#USER_EXISTS} -ne 0 ] ; then
		#echo "User ${USERNAME} exists!!!"
		echo -n "Do you want to start restore process(y/n):"
		read DELETE
		if [ $DELETE == 'y' ] ; then
		
		NEW_MYSQL_PASSWORD=`echo Q2lzY29AMTIz | base64 --decode -i`	
		
				mysqladmin --user=root --password=$NEW_MYSQL_PASSWORD version > /dev/null 2>&1
					if [ $? -ne 0 ]; then 
					echo "MSG : Backup script is unable to connect to MySql server due to one of the following reasons" 
					echo "1. Firewall is enabled and not configured to allow access to port 3306" 
					echo "2. SE Linux is enabled and blocking access to port 3306"
					echo "3. Invalid MySql root password"
					exit 1
					fi
			
			if [ -f /home/$USERNAME/tomcat.pid ]; then
			/etc/init.d/tomcat-$USERNAME stop
			fi
			echo "INFO : Restoring user [$USERNAME]"
		else
			echo "User does not restored!"
			exit 1
		fi
	else
		echo "User does not exist:"
		exit 1
	fi
		PWDIR=`pwd`
		cd $INPUT_DIR
		unzip $USERNAME.zip
		cd $USERNAME
		unzip Insight.zip
		unzip schema.zip
		unzip quartz.zip
		rm -rf /home/$USERNAME/Insight
		mv Insight/ "/home/${USERNAME}/"
		/usr/bin/mysql --user=$user --password=$MYSQL_ROOT_PASSWORD<mysqlcreateuser.sql
		/usr/bin/mysql --user=$user --password=$MYSQL_ROOT_PASSWORD < ./schema.sql
		/usr/bin/mysql --user=$user --password=$MYSQL_ROOT_PASSWORD < ./quartz.sql	
		cd ../
		rm -rf $USERNAME
		/etc/init.d/tomcat-$USERNAME start
		echo -n ""
		echo "User $USERNAME Restored successfully"
else
	echo "INFO : You must be root to launch the restore script"
fi