#!/bin/sh
logfile=(`date +"%d%m%Y_%H%M%S"`)
sbin_set=`echo $PATH | grep -w "/usr/sbin/"`
if [ ${#sbin_set} -eq 0 ]; then 
	PATH=$PATH:/usr/sbin/
fi

SELINUX_STATUS=`getenforce`
if [ `echo $SELINUX_STATUS | tr [:upper:] [:lower:] | grep -c "enforcing"` -eq 1 ]; then
    echo "SELinux is enabled. Please refer the Installation Guide to disable it."
    exit 9
fi

user=(`id | awk '{print $1}'`)
user=${user:6:4}
if [ $user = "root" ]; then
AVAILABLE_SPACE=`df -P /home | column -t | grep -w "/home"`
if [ $? -ne 0 ]; then
AVAILABLE_SPACE=`df -P / | column -t | grep -w "/"`
fi
        AVAIL_SIZE=`echo $AVAILABLE_SPACE | cut -d' ' -f 4`
	REQUIRED_SIZE=1048576
	if [ $AVAIL_SIZE -lt $REQUIRED_SIZE ]; then
	        echo "Not enough space left to install the application. 1GB of space is required to install the application."
		exit 1
	else
		if [ $# = 1 ] && [ $1 = "silent" ]; then
			cp  .pkgrpm/silent_user_answers.txt .conf/user_answers.txt
		else
			rm -rf .conf/*
		fi
		.scripts/start.sh 2>&1 | tee logs/install_$logfile.log
	fi
else
	echo "You must be root to launch the installation script"
fi


if [ -f uninstall.sh ]; then
	rm -f uninstall.sh
fi
if [ -f backup.sh ]; then
	rm -f backup.sh
fi
if [ -f config.sh ]; then
	rm -f config.sh
fi
