/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.Constants;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.DiscoveryPermission;
import net.jini.discovery.IncomingMulticastAnnouncement;
import net.jini.discovery.IncomingUnicastResponse;
import net.jini.discovery.OutgoingMulticastRequest;

public class LookupDiscovery
implements DiscoveryManagement,
DiscoveryGroupManagement {
    public static final String[] ALL_GROUPS = DiscoveryGroupManagement.ALL_GROUPS;
    public static final String[] NO_GROUPS = DiscoveryGroupManagement.NO_GROUPS;
    private boolean terminated = false;
    private ArrayList listeners = new ArrayList(1);
    private Set groups = null;
    private Map registrars = new HashMap(11);
    private Set pendingDiscoveries = new HashSet(11);
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private UnicastDiscoverer discovererThread;
    private AnnouncementListener announceeThread;
    private Collection requestors = new LinkedList();
    private ResponseListener respondeeThread = null;
    private final AccessControlContext acc = AccessController.getContext();
    private HashMap regTimes = new HashMap(11);
    private AnnouncementTimerThread announcementTimerThread;
    private static final int DISCOVERED = 0;
    private static final int DISCARDED = 1;
    private static final int CHANGED = 2;

    public LookupDiscovery(String[] stringArray) throws IOException {
        LookupDiscovery.checkGroups(stringArray);
        if (stringArray != null) {
            this.groups = new HashSet(stringArray.length * 2);
            int n = 0;
            while (n < stringArray.length) {
                this.groups.add(stringArray[n]);
                ++n;
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    LookupDiscovery.this.announceeThread = new AnnouncementListener();
                    LookupDiscovery.this.announcementTimerThread = new AnnouncementTimerThread();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        if (this.groups == null || !this.groups.isEmpty()) {
            this.requestGroups(this.groups);
        }
        this.announceeThread.start();
        this.announcementTimerThread.start();
    }

    static /* synthetic */ void access$18(LookupDiscovery lookupDiscovery, IncomingUnicastResponse incomingUnicastResponse) {
        lookupDiscovery.maybeAddNewRegistrar(incomingUnicastResponse);
    }

    static /* synthetic */ void access$19(LookupDiscovery lookupDiscovery, IncomingUnicastResponse incomingUnicastResponse, String[] stringArray) {
        lookupDiscovery.maybeSendEvent(incomingUnicastResponse, stringArray);
    }

    static /* synthetic */ Map access$22(LookupDiscovery lookupDiscovery, HashMap hashMap) {
        return lookupDiscovery.deepCopy(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.listeners.indexOf(discoveryListener) >= 0) {
                return;
            }
            this.listeners.add(discoveryListener);
            if (this.registrars.isEmpty()) {
                return;
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iterator = this.registrars.values().iterator();
            int n = 0;
            while (true) {
                Object object;
                if (!iterator.hasNext()) {
                    object = new ArrayList(1);
                    ((ArrayList)object).add(discoveryListener);
                    this.addNotify((ArrayList)object, hashMap, 0);
                    return;
                }
                object = (IncomingUnicastResponse)iterator.next();
                hashMap.put(((IncomingUnicastResponse)object).registrar, ((IncomingUnicastResponse)object).groups);
                ++n;
            }
        }
    }

    public void addGroups(String[] stringArray) throws IOException {
        LookupDiscovery.checkGroups(stringArray);
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't add to \"any groups\"");
            }
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (this.groups.add(stringArray[n])) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                this.requestGroups(arrayList);
            }
        }
    }

    private void addNotify(ArrayList arrayList, Map map, int n) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(arrayList, map, n));
            if (this.notifierThread == null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        LookupDiscovery.this.notifierThread = new Notifier();
                        LookupDiscovery.this.notifierThread.start();
                        return null;
                    }
                });
            }
        }
    }

    private static void checkGroups(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                securityManager.checkPermission(new DiscoveryPermission(stringArray[n]));
                ++n;
            }
        } else {
            securityManager.checkPermission(new DiscoveryPermission("*"));
        }
    }

    private static final String[] collectionToStrings(Collection collection) {
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    private Map deepCopy(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return hashMap2;
    }

    public void discard(ServiceRegistrar serviceRegistrar) {
        Map map = this.registrars;
        synchronized (map) {
            this.sendDiscarded(serviceRegistrar, null);
        }
    }

    public void finalize() {
        this.terminate();
    }

    private String[] getActualGroups(ServiceRegistrar serviceRegistrar) {
        try {
            return serviceRegistrar.getGroups();
        }
        catch (RemoteException remoteException) {
            this.discard(serviceRegistrar);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getGroups() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.groups == null) {
                return ALL_GROUPS;
            }
            if (!this.groups.isEmpty()) return LookupDiscovery.collectionToStrings(this.groups);
            return NO_GROUPS;
        }
    }

    public ServiceRegistrar[] getRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.registrars.isEmpty()) {
                ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[]{};
                Object var3_4 = null;
                return serviceRegistrarArray;
            }
            Iterator iterator = this.registrars.values().iterator();
            ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.registrars.size()];
            int n = 0;
            while (iterator.hasNext()) {
                serviceRegistrarArray[n] = ((IncomingUnicastResponse)iterator.next()).registrar;
                ++n;
            }
            ServiceRegistrar[] serviceRegistrarArray2 = serviceRegistrarArray;
            Object var3_5 = null;
            return serviceRegistrarArray2;
        }
    }

    private ServiceID[] getServiceIDs() {
        Map map = this.registrars;
        synchronized (map) {
            ServiceID[] serviceIDArray = this.registrars.keySet().toArray(new ServiceID[this.registrars.size()]);
            Object var3_3 = null;
            return serviceIDArray;
        }
    }

    private static boolean groupSetsEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            block4: {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (!stringArray[n].equals(stringArray2[n2])) {
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean groupsOverlap(String[] stringArray) {
        if (this.groups == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (this.groups.contains(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Map mapRegToGroups(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
        hashMap.put(serviceRegistrar, stringArray);
        return hashMap;
    }

    private void maybeAddNewRegistrar(IncomingUnicastResponse incomingUnicastResponse) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.groupsOverlap(incomingUnicastResponse.groups) && !incomingUnicastResponse.equals(this.registrars.put(incomingUnicastResponse.registrar.getServiceID(), incomingUnicastResponse))) {
                this.regTimes.put(incomingUnicastResponse.registrar.getServiceID(), new Long(System.currentTimeMillis()));
                if (!this.listeners.isEmpty()) {
                    this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(incomingUnicastResponse.registrar, incomingUnicastResponse.groups), 0);
                }
            }
        }
    }

    private void maybeDiscardRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iterator = this.registrars.values().iterator();
            while (iterator.hasNext()) {
                IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)iterator.next();
                if (this.groupsOverlap(incomingUnicastResponse.groups)) continue;
                hashMap.put(incomingUnicastResponse.registrar, incomingUnicastResponse.groups);
                this.regTimes.remove(incomingUnicastResponse.registrar.getServiceID());
                iterator.remove();
            }
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, 1);
            }
        }
    }

    private void maybeSendEvent(IncomingUnicastResponse incomingUnicastResponse, String[] stringArray) {
        ServiceRegistrar serviceRegistrar = incomingUnicastResponse.getRegistrar();
        String[] stringArray2 = incomingUnicastResponse.getGroups();
        boolean bl = true;
        if (stringArray == null) {
            stringArray = this.getActualGroups(serviceRegistrar);
            if (stringArray == null) {
                return;
            }
            bl = false;
        }
        if (LookupDiscovery.groupSetsEqual(stringArray2, stringArray)) {
            return;
        }
        String[] stringArray3 = stringArray;
        if (bl && stringArray.length > 0 && (stringArray3 = this.getActualGroups(serviceRegistrar)) == null) {
            return;
        }
        this.notifyOnGroupChange(serviceRegistrar, stringArray2, stringArray3);
    }

    private void notifyOnGroupChange(ServiceRegistrar serviceRegistrar, String[] stringArray, String[] stringArray2) {
        boolean bl = LookupDiscovery.groupSetsEqual(stringArray, stringArray2);
        boolean bl2 = this.groupsOverlap(stringArray2);
        if (!bl && bl2) {
            this.sendChanged(serviceRegistrar, stringArray2);
        } else if (!bl2) {
            this.sendDiscarded(serviceRegistrar, stringArray2);
        }
    }

    private void nukeThreads() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LookupDiscovery.this.announcementTimerThread.interrupt();
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    Iterator iterator = LookupDiscovery.this.requestors.iterator();
                    while (iterator.hasNext()) {
                        Thread thread = (Thread)iterator.next();
                        thread.interrupt();
                    }
                    if (LookupDiscovery.this.respondeeThread != null) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                    }
                }
                LookupDiscovery.this.announceeThread.interrupt();
                collection = LookupDiscovery.this.pendingDiscoveries;
                synchronized (collection) {
                    if (LookupDiscovery.this.discovererThread != null) {
                        LookupDiscovery.this.discovererThread.interrupt();
                    }
                }
                return null;
            }
        });
    }

    private static void printException(Exception exception) {
        try {
            if (System.getProperty("net.jini.discovery.debug") != null) {
                exception.printStackTrace();
            }
        }
        catch (SecurityException securityException) {}
    }

    public void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        Map map = this.registrars;
        synchronized (map) {
            ((AbstractCollection)this.listeners).remove(discoveryListener);
        }
    }

    public void removeGroups(String[] stringArray) {
        boolean bl;
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't remove from \"any groups\"");
            }
            bl = this.removeGroupsInt(stringArray);
        }
        if (bl) {
            this.maybeDiscardRegistrars();
        }
    }

    private boolean removeGroupsInt(String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            bl |= this.groups.remove(stringArray[n]);
            ++n;
        }
        return bl;
    }

    private void requestGroups(final Collection collection) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Requestor requestor;
                    Collection collection2 = requestors;
                    synchronized (collection2) {
                        if (respondeeThread == null) {
                            respondeeThread = new ResponseListener();
                            respondeeThread.start();
                        }
                        requestor = new Requestor(LookupDiscovery.collectionToStrings(collection), respondeeThread.getPort());
                        requestors.add(requestor);
                    }
                    requestor.start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void sendChanged(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)this.registrars.get(serviceRegistrar.getServiceID());
        incomingUnicastResponse.groups = (String[])stringArray.clone();
        if (!this.listeners.isEmpty()) {
            this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(serviceRegistrar, stringArray), 2);
        }
    }

    private void sendDiscarded(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        ServiceID serviceID = serviceRegistrar.getServiceID();
        if (stringArray == null) {
            IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)this.registrars.get(serviceID);
            if (incomingUnicastResponse == null) {
                return;
            }
            stringArray = incomingUnicastResponse.getGroups();
        }
        if (this.registrars.remove(serviceID) != null) {
            this.regTimes.remove(serviceID);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(serviceRegistrar, stringArray), 1);
            }
        }
    }

    public void setGroups(String[] stringArray) throws IOException {
        boolean bl = false;
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>(stringArray.length * 2);
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
        }
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (stringArray == null) {
                if (this.groups != null) {
                    this.groups = null;
                    this.requestGroups(null);
                }
                Object var5_6 = null;
                return;
            }
            if (this.groups == null) {
                this.groups = new HashSet(11);
                bl = true;
            }
            HashSet hashSet2 = new HashSet(hashSet);
            hashSet2.removeAll(this.groups);
            HashSet hashSet3 = new HashSet(this.groups);
            hashSet3.removeAll(hashSet);
            this.groups.addAll(hashSet2);
            if (!hashSet3.isEmpty()) {
                bl |= this.removeGroupsInt(LookupDiscovery.collectionToStrings(hashSet3));
            }
            if (!hashSet2.isEmpty()) {
                this.requestGroups(hashSet2);
            }
        }
        if (bl) {
            this.maybeDiscardRegistrars();
        }
    }

    private static void setInterface(MulticastSocket multicastSocket) throws IOException {
        try {
            String string = System.getProperty("net.jini.discovery.interface");
            if (string != null) {
                multicastSocket.setInterface(InetAddress.getByName(string));
            }
        }
        catch (SecurityException securityException) {}
    }

    public void terminate() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                Object var2_2 = null;
                return;
            }
            this.terminated = true;
        }
        this.nukeThreads();
    }

    private class AnnouncementListener
    extends Thread {
        private MulticastSocket sock;
        private boolean interrupted = false;

        public AnnouncementListener() throws IOException {
            super("multicast discovery announcement listener");
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            this.sock.joinGroup(Constants.getAnnouncementAddress());
            LookupDiscovery.setInterface(this.sock);
        }

        public void interrupt() {
            this.interrupted = true;
            this.sock.close();
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            byte[] byArray = new byte[512];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            while (!this.isInterrupted()) {
                try {
                    Object object;
                    IncomingMulticastAnnouncement incomingMulticastAnnouncement;
                    block22: {
                        datagramPacket.setLength(byArray.length);
                        try {
                            this.sock.receive(datagramPacket);
                        }
                        catch (NullPointerException nullPointerException) {
                            break;
                        }
                        incomingMulticastAnnouncement = new IncomingMulticastAnnouncement(datagramPacket);
                        ServiceID serviceID = incomingMulticastAnnouncement.getServiceID();
                        object = LookupDiscovery.this.registrars;
                        synchronized (object) {
                            IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)LookupDiscovery.this.registrars.get(serviceID);
                            if (incomingUnicastResponse != null) {
                                LookupDiscovery.this.regTimes.put(serviceID, new Long(System.currentTimeMillis()));
                                Set set = LookupDiscovery.this.pendingDiscoveries;
                                synchronized (set) {
                                    if (LookupDiscovery.this.pendingDiscoveries.add(incomingMulticastAnnouncement) && LookupDiscovery.this.discovererThread == null) {
                                        LookupDiscovery.this.discovererThread = new UnicastDiscoverer();
                                        LookupDiscovery.this.discovererThread.start();
                                    }
                                }
                            }
                            if (LookupDiscovery.this.groupsOverlap(incomingMulticastAnnouncement.getGroups())) break block22;
                            Object var6_7 = null;
                            continue;
                        }
                    }
                    object = LookupDiscovery.this.pendingDiscoveries;
                    synchronized (object) {
                        if (LookupDiscovery.this.pendingDiscoveries.add(incomingMulticastAnnouncement.getLocator()) && LookupDiscovery.this.discovererThread == null) {
                            LookupDiscovery.this.discovererThread = new UnicastDiscoverer();
                            LookupDiscovery.this.discovererThread.start();
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    LookupDiscovery.printException(exception);
                }
            }
            this.sock.close();
            this.sock = null;
        }
    }

    private class UnicastDiscoverer
    extends Thread {
        private boolean interrupted = false;

        public UnicastDiscoverer() {
            super("unicast discovery");
            this.setDaemon(true);
        }

        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ResponseListener
    extends Thread {
        public ServerSocket serv;
        private boolean interrupted = false;

        public ResponseListener() throws IOException {
            super("multicast discovery response listener");
            this.setDaemon(true);
            this.serv = new ServerSocket(0);
        }

        public int getPort() {
            return this.serv.getLocalPort();
        }

        public void interrupt() {
            this.interrupted = true;
            try {
                new Socket(InetAddress.getLocalHost(), this.getPort()).close();
            }
            catch (IOException iOException) {}
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Socket socket = this.serv.accept();
                    if (this.isInterrupted()) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    Set set = LookupDiscovery.this.pendingDiscoveries;
                    synchronized (set) {
                        LookupDiscovery.this.pendingDiscoveries.add(socket);
                        if (LookupDiscovery.this.discovererThread == null) {
                            LookupDiscovery.this.discovererThread = new UnicastDiscoverer();
                            LookupDiscovery.this.discovererThread.start();
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    LookupDiscovery.printException(exception);
                }
            }
            try {
                this.serv.close();
            }
            catch (IOException iOException) {
                LookupDiscovery.printException(iOException);
            }
        }
    }

    private class Requestor
    extends Thread {
        private MulticastSocket sock;
        private int responsePort;
        private String[] groups;

        public Requestor(String[] stringArray, int n) throws IOException {
            super("multicast discovery request");
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            int n2 = 15;
            try {
                n2 = Integer.getInteger("net.jini.discovery.ttl", n2);
            }
            catch (SecurityException securityException) {}
            this.sock.setTimeToLive(n2);
            LookupDiscovery.setInterface(this.sock);
            this.responsePort = n;
            this.groups = stringArray == null ? new String[]{} : stringArray;
        }

        public void run() {
            Object object;
            try {
                try {
                    int n = 7;
                    while (--n >= 0 && !this.isInterrupted()) {
                        try {
                            object = OutgoingMulticastRequest.marshal(this.responsePort, this.groups, LookupDiscovery.this.getServiceIDs());
                            int n2 = 0;
                            while (n2 < ((DatagramPacket[])object).length) {
                                try {
                                    this.sock.send(object[n2]);
                                }
                                catch (InterruptedIOException interruptedIOException) {
                                    Object var3_8 = null;
                                    object = LookupDiscovery.this.requestors;
                                    synchronized (object) {
                                        LookupDiscovery.this.requestors.remove(Thread.currentThread());
                                        if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                                            LookupDiscovery.this.respondeeThread.interrupt();
                                            LookupDiscovery.this.respondeeThread = null;
                                        }
                                    }
                                    this.sock.close();
                                    return;
                                }
                                catch (Exception exception) {
                                    LookupDiscovery.printException(exception);
                                }
                                ++n2;
                            }
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            break;
                        }
                        catch (Exception exception) {
                            LookupDiscovery.printException(exception);
                        }
                        Thread.sleep(n > 0 ? 5000 : 120000);
                    }
                }
                catch (InterruptedException interruptedException) {
                    LookupDiscovery.printException(interruptedException);
                }
                Object var3_9 = null;
            }
            catch (Throwable throwable) {
                Object var3_10 = null;
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    LookupDiscovery.this.requestors.remove(Thread.currentThread());
                    if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                        LookupDiscovery.this.respondeeThread = null;
                    }
                }
                this.sock.close();
                throw throwable;
            }
            object = LookupDiscovery.this.requestors;
            synchronized (object) {
                LookupDiscovery.this.requestors.remove(Thread.currentThread());
                if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                    LookupDiscovery.this.respondeeThread.interrupt();
                    LookupDiscovery.this.respondeeThread = null;
                }
            }
            this.sock.close();
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final int eventType;

        public NotifyTask(ArrayList arrayList, Map map, int n) {
            this.listeners = arrayList;
            this.groupsMap = map;
            this.eventType = n;
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event listener notification");
            this.setDaemon(true);
        }

        static /* synthetic */ LookupDiscovery access$0(Notifier notifier) {
            return notifier.LookupDiscovery.this;
        }

        public void run() {
            while (true) {
                NotifyTask notifyTask;
                LinkedList linkedList = LookupDiscovery.this.pendingNotifies;
                synchronized (linkedList) {
                    if (LookupDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupDiscovery.this.notifierThread = null;
                        Object var3_3 = null;
                        return;
                    }
                    notifyTask = (NotifyTask)LookupDiscovery.this.pendingNotifies.removeFirst();
                }
                AccessController.doPrivileged(new PrivilegedAction(notifyTask, this){
                    private final /* synthetic */ Notifier this$1;
                    private final /* synthetic */ NotifyTask val$task;
                    {
                        this.val$task = notifyTask;
                        this.this$1 = notifier;
                    }

                    public Object run() {
                        Iterator<E> iterator = ((AbstractList)this.val$task.listeners).iterator();
                        while (iterator.hasNext()) {
                            DiscoveryListener discoveryListener = (DiscoveryListener)iterator.next();
                            if (this.val$task.eventType == 2 && !(discoveryListener instanceof DiscoveryChangeListener)) continue;
                            DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)Notifier.access$0(this.this$1), LookupDiscovery.access$22(Notifier.access$0(this.this$1), (HashMap)this.val$task.groupsMap));
                            switch (this.val$task.eventType) {
                                case 0: {
                                    discoveryListener.discovered(discoveryEvent);
                                    break;
                                }
                                case 1: {
                                    discoveryListener.discarded(discoveryEvent);
                                    break;
                                }
                                case 2: {
                                    ((DiscoveryChangeListener)discoveryListener).changed(discoveryEvent);
                                    break;
                                }
                            }
                        }
                        return null;
                    }
                }, LookupDiscovery.this.acc);
            }
        }
    }

    private class AnnouncementTimerThread
    extends Thread {
        private static final int INTERVAL = 120000;
        private static final int N_INTERVALS = 3;

        public AnnouncementTimerThread() {
            super("multicast announcement timer");
            this.setDaemon(true);
        }

        public synchronized void run() {
            int n = 120000;
            try {
                n = Integer.getInteger("net.jini.discovery.announce", n);
            }
            catch (SecurityException securityException) {}
            int n2 = 3 * n;
            try {
                while (!this.isInterrupted()) {
                    this.wait(n);
                    long l = System.currentTimeMillis();
                    Map map = LookupDiscovery.this.registrars;
                    synchronized (map) {
                        HashMap hashMap = (HashMap)LookupDiscovery.this.regTimes.clone();
                        Set set = hashMap.entrySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            ServiceID serviceID = (ServiceID)entry.getKey();
                            long l2 = (Long)entry.getValue();
                            long l3 = l - l2;
                            if (l3 <= (long)n2) continue;
                            IncomingUnicastResponse incomingUnicastResponse = (IncomingUnicastResponse)LookupDiscovery.this.registrars.get(serviceID);
                            Set set2 = LookupDiscovery.this.pendingDiscoveries;
                            synchronized (set2) {
                                if (LookupDiscovery.this.pendingDiscoveries.add(incomingUnicastResponse) && LookupDiscovery.this.discovererThread == null) {
                                    LookupDiscovery.this.discovererThread = new UnicastDiscoverer();
                                    LookupDiscovery.this.discovererThread.start();
                                }
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

