/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.Constants;

public class OutgoingMulticastAnnouncement {
    protected static final int minMaxPacketSize = 512;
    protected static final int maxPacketSize = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return Integer.getInteger("net.jini.discovery.mtu", 512);
            }
            catch (SecurityException securityException) {
                return new Integer(512);
            }
        }
    });
    protected static final int protocolVersion = 1;

    public static DatagramPacket[] marshal(ServiceID serviceID, LookupLocator lookupLocator, String[] stringArray) throws IOException {
        Object object;
        DatagramPacket[] datagramPacketArray;
        Object object2;
        Object object3;
        Object object4;
        if (maxPacketSize < 512) {
            throw new RuntimeException("value of net.jini.discovery.mtu property is less than 512");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeUTF(lookupLocator.getHost());
        dataOutputStream.writeInt(lookupLocator.getPort());
        serviceID.writeBytes(dataOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > maxPacketSize) {
            throw new IllegalArgumentException("host name marshals too large");
        }
        byte[][] byArray2 = new byte[stringArray.length][];
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            object4 = new ByteArrayOutputStream();
            object3 = new DataOutputStream((OutputStream)object4);
            ((DataOutputStream)object3).writeUTF(stringArray[n2]);
            ((DataOutputStream)object3).flush();
            byArray2[n2] = ((ByteArrayOutputStream)object4).toByteArray();
            if (byArray.length + 4 + 4 + byArray2[n2].length > maxPacketSize) {
                throw new IllegalArgumentException("group name marshals too large (" + byArray2[n2].length + " bytes)");
            }
            if (byArray2[n2].length > n) {
                n = byArray2[n2].length;
            }
            ++n2;
        }
        object4 = new Vector();
        object3 = Constants.getAnnouncementAddress();
        if (stringArray.length == 0) {
            object2 = new ByteArrayOutputStream(maxPacketSize);
            datagramPacketArray = new DataOutputStream((OutputStream)object2);
            datagramPacketArray.write(byArray);
            datagramPacketArray.writeInt(0);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            object4.add(new DatagramPacket((byte[])object, ((Object)object).length, (InetAddress)object3, 4160));
        } else {
            int n3 = 0;
            while (n3 < byArray2.length) {
                datagramPacketArray = new ByteArrayOutputStream(maxPacketSize);
                object = new DataOutputStream((OutputStream)datagramPacketArray);
                ((FilterOutputStream)object).write(byArray);
                ((DataOutputStream)object).flush();
                int n4 = datagramPacketArray.size() + 4;
                int n5 = n3;
                while (n5 < byArray2.length && n4 + byArray2[n5].length <= maxPacketSize) {
                    n4 += byArray2[n5].length;
                    ++n5;
                }
                ((DataOutputStream)object).writeInt(n5 - n3);
                while (n3 < n5) {
                    ((FilterOutputStream)object).write(byArray2[n3++]);
                }
                ((DataOutputStream)object).flush();
                byte[] byArray3 = datagramPacketArray.toByteArray();
                object4.add(new DatagramPacket(byArray3, byArray3.length, (InetAddress)object3, 4160));
            }
        }
        object2 = object4.iterator();
        datagramPacketArray = new DatagramPacket[object4.size()];
        int n6 = 0;
        while (object2.hasNext()) {
            datagramPacketArray[n6] = (DatagramPacket)object2.next();
            ++n6;
        }
        return datagramPacketArray;
    }
}

