/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.jini.core.event.RemoteEvent;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.LookupUnmarshalException;

public class RemoteDiscoveryEvent
extends RemoteEvent {
    private static final long serialVersionUID = -9171289945014585248L;
    protected boolean discarded;
    protected ArrayList marshalledRegs;
    protected ServiceRegistrar[] regs;
    protected Map groups;

    public RemoteDiscoveryEvent(Object object, long l, long l2, MarshalledObject marshalledObject, boolean bl, Map map) throws IOException {
        super(object, l, l2, marshalledObject);
        this.discarded = bl;
        if (map != null) {
            if (map.size() == 0) {
                throw new IllegalArgumentException("empty input map");
            }
            ServiceRegistrar[] serviceRegistrarArray = map.keySet().toArray(new ServiceRegistrar[map.size()]);
            int n = 0;
            while (n < serviceRegistrarArray.length) {
                if (serviceRegistrarArray[n] == null) {
                    throw new NullPointerException("null element (" + n + ") in input map");
                }
                ++n;
            }
            this.groups = new HashMap(map.size());
            this.marshalledRegs = new ArrayList(map.size());
            int n2 = 0;
            while (n2 < serviceRegistrarArray.length) {
                try {
                    this.marshalledRegs.add(new MarshalledObject<ServiceRegistrar>(serviceRegistrarArray[n2]));
                    this.groups.put(serviceRegistrarArray[n2].getServiceID(), map.get(serviceRegistrarArray[n2]));
                }
                catch (IOException iOException) {}
                ++n2;
            }
            if (this.marshalledRegs.isEmpty()) {
                throw new IOException("failed to serialize any of the " + serviceRegistrarArray.length + " elements");
            }
        } else {
            throw new NullPointerException("null input map");
        }
        this.regs = new ServiceRegistrar[this.marshalledRegs.size()];
    }

    public Map getGroups() {
        return this.groups;
    }

    public ServiceRegistrar[] getRegistrars() throws LookupUnmarshalException {
        HashSet<ServiceRegistrar> hashSet = new HashSet<ServiceRegistrar>();
        ArrayList arrayList = this.marshalledRegs;
        synchronized (arrayList) {
            if (this.marshalledRegs.size() > 0) {
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = RemoteDiscoveryEvent.unmarshalRegistrars(this.marshalledRegs, arrayList2);
                RemoteDiscoveryEvent.insertRegistrars(this.regs, arrayList2);
                if (arrayList3.size() > 0) {
                    throw new LookupUnmarshalException(arrayList2.toArray(new ServiceRegistrar[arrayList2.size()]), this.marshalledRegs.toArray(new MarshalledObject[this.marshalledRegs.size()]), arrayList3.toArray(new Throwable[arrayList3.size()]));
                }
            }
            int n = 0;
            while (n < this.regs.length) {
                if (this.regs[n] != null) {
                    hashSet.add(this.regs[n]);
                }
                ++n;
            }
        }
        return ((AbstractCollection)hashSet).toArray(new ServiceRegistrar[hashSet.size()]);
    }

    private static int indexFirstNull(Object[] objectArray) {
        int n = -1;
        if (objectArray == null || objectArray.length == 0) {
            return n;
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    private static void insertRegistrars(ServiceRegistrar[] serviceRegistrarArray, ArrayList arrayList) {
        if (serviceRegistrarArray != null && arrayList != null) {
            int n = serviceRegistrarArray.length;
            int n2 = arrayList.size();
            if (n == 0 || n2 == 0) {
                return;
            }
            int n3 = RemoteDiscoveryEvent.indexFirstNull(serviceRegistrarArray);
            int n4 = n3 + n2 <= n ? n3 + n2 : n;
            int n5 = n3;
            int n6 = 0;
            while (n5 < n4) {
                serviceRegistrarArray[n5] = (ServiceRegistrar)arrayList.get(n6);
                ++n5;
                ++n6;
            }
        }
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    private static ArrayList unmarshalRegistrars(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Exception> arrayList3 = new ArrayList<Exception>();
        int n = 0;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            try {
                MarshalledObject marshalledObject = (MarshalledObject)arrayList.get(n);
                ServiceRegistrar serviceRegistrar = (ServiceRegistrar)marshalledObject.get();
                arrayList2.add(serviceRegistrar);
                arrayList.remove(n);
            }
            catch (IOException iOException) {
                arrayList3.add(iOException);
                ++n;
            }
            catch (ClassNotFoundException classNotFoundException) {
                arrayList3.add(classNotFoundException);
                ++n;
            }
            ++n3;
        }
        return arrayList3;
    }
}

