/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.CDATASectionImpl;
import com.ibm.xml.dom.CommentImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DOMImplementationImpl;
import com.ibm.xml.dom.DeepNodeListImpl;
import com.ibm.xml.dom.DocumentFragmentImpl;
import com.ibm.xml.dom.DocumentTypeImpl;
import com.ibm.xml.dom.ElementDefinitionImpl;
import com.ibm.xml.dom.ElementImpl;
import com.ibm.xml.dom.EntityImpl;
import com.ibm.xml.dom.EntityReferenceImpl;
import com.ibm.xml.dom.NodeImpl;
import com.ibm.xml.dom.NotationImpl;
import com.ibm.xml.dom.ProcessingInstructionImpl;
import com.ibm.xml.dom.TextImpl;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document {
    private static final boolean DEBUG_PRINT_TABLES = false;
    protected static final int CHUNK_SHIFT = 11;
    protected static final int CHUNK_SIZE = 2048;
    protected static final int CHUNK_MASK = 2047;
    protected static final int INITIAL_CHUNK_COUNT = 32;
    protected int fNodeCount;
    protected byte[][] fNodeType;
    protected int[][] fNodeName;
    protected int[][] fNodeValue;
    protected int[][] fNodeParent;
    protected int[][] fNodeFirstChild;
    protected int[][] fNodeLastChild;
    protected int[][] fNodePrevSib;
    protected int[][] fNodeNextSib;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    protected ParserState fParserState;
    protected StringPool fStringPool;

    public DocumentImpl() {
        super(null, null, null);
        this.ownerDocument = this;
    }

    public DocumentImpl(ParserState parserState) {
        super(null, 0);
        this.fParserState = parserState;
        this.fStringPool = parserState.getStringPool();
        this.ownerDocument = this;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public String getNodeValue() {
        return null;
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        if (bl) {
            NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
            while (nodeImpl != null) {
                documentImpl.appendChild(documentImpl.importNode(nodeImpl, true));
                nodeImpl = nodeImpl.nextSibling;
            }
        }
        return documentImpl;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (s == 1 && this.docElement != null || s == 10 && this.docType != null) {
            throw new DOMExceptionImpl(3, null);
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public Attr createAttribute(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new AttrImpl(this, string);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ElementImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new EntityReferenceImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public DocumentType getDoctype() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.singleton;
    }

    public DocumentType createDocumentType(String string) throws DOMException {
        if (!DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, null);
        }
        return new DocumentTypeImpl(this, string);
    }

    public Entity createEntity(String string) throws DOMException {
        return new EntityImpl(this, string);
    }

    public Notation createNotation(String string) throws DOMException {
        return new NotationImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        return new ElementDefinitionImpl(this, string);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2;
        Object object = null;
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                node2 = this.createElement(node.getNodeName());
                Object object2 = node.getAttributes();
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.getLength()) {
                        node2.setAttributeNode((AttrImpl)this.importNode(object2.item(n), true));
                        ++n;
                    }
                }
                object = (NodeImpl)node2;
                break;
            }
            case 2: {
                object = (NodeImpl)((Object)this.createAttribute(node.getNodeName()));
                break;
            }
            case 3: {
                object = (NodeImpl)((Object)this.createTextNode(node.getNodeValue()));
                break;
            }
            case 4: {
                object = (NodeImpl)((Object)this.createCDATASection(node.getNodeValue()));
                break;
            }
            case 5: {
                object = (NodeImpl)((Object)this.createEntityReference(node.getNodeName()));
                bl = false;
                break;
            }
            case 6: {
                node2 = (Entity)node;
                Object object2 = (EntityImpl)this.createEntity(node.getNodeName());
                ((EntityImpl)object2).setPublicId(node2.getPublicId());
                ((EntityImpl)object2).setSystemId(node2.getSystemId());
                ((EntityImpl)object2).setNotationName(node2.getNotationName());
                object = object2;
                break;
            }
            case 7: {
                object = (ProcessingInstructionImpl)this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                object = (NodeImpl)((Object)this.createComment(node.getNodeValue()));
                break;
            }
            case 10: {
                int n;
                node2 = (DocumentTypeImpl)this.createDocumentType(node.getNodeName());
                Object object2 = ((DocumentType)node).getEntities();
                NamedNodeMap namedNodeMap = ((DocumentTypeImpl)node2).getEntities();
                if (object2 != null) {
                    n = 0;
                    while (n < object2.getLength()) {
                        namedNodeMap.setNamedItem((EntityImpl)this.importNode(object2.item(n), true));
                        ++n;
                    }
                }
                object2 = ((DocumentType)node).getNotations();
                namedNodeMap = ((DocumentTypeImpl)node2).getNotations();
                if (object2 != null) {
                    n = 0;
                    while (n < object2.getLength()) {
                        namedNodeMap.setNamedItem((NotationImpl)this.importNode(object2.item(n), true));
                        ++n;
                    }
                }
                object = node2;
                break;
            }
            case 11: {
                object = (NodeImpl)((Object)this.createDocumentFragment());
                break;
            }
            case 12: {
                node2 = (Notation)node;
                Object object2 = (NotationImpl)this.createNotation(node.getNodeName());
                ((NotationImpl)object2).setPublicId(node2.getPublicId());
                ((NotationImpl)object2).setSystemId(node2.getSystemId());
                object = object2;
                break;
            }
            default: {
                throw new DOMExceptionImpl(3, null);
            }
        }
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                ((NodeImpl)object).appendChild(this.importNode(node2, true));
                node2 = node2.getNextSibling();
            }
        }
        return object;
    }

    public int createDocument() {
        int n = this.createNode((short)9);
        return n;
    }

    public int createDocumentType(int n) {
        int n2 = this.createNode((short)10);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeName[n3][n4] = n;
        return n2;
    }

    public int createNotation(int n) {
        int n2 = this.createNode((short)12);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        int n5 = this.createNode((short)3);
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        this.fNodeValue[n3][n4] = n5;
        EntityPool entityPool = this.fParserState.getEntityPool();
        this.fNodeName[n3][n4] = entityPool.getNotationName(n);
        this.fNodeFirstChild[n6][n7] = entityPool.getPublicId(n);
        this.fNodeLastChild[n6][n7] = entityPool.getSystemId(n);
        return n2;
    }

    public int createEntity(int n) {
        int n2 = this.createNode((short)6);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        int n5 = this.createNode((short)3);
        int n6 = n5 >> 11;
        int n7 = n5 & 0x7FF;
        this.fNodeValue[n3][n4] = n5;
        EntityPool entityPool = this.fParserState.getEntityPool();
        this.fNodeName[n3][n4] = entityPool.getEntityName(n);
        this.fNodeFirstChild[n6][n7] = entityPool.getPublicId(n);
        this.fNodeLastChild[n6][n7] = entityPool.getSystemId(n);
        this.fNodePrevSib[n6][n7] = entityPool.getNotationName(n);
        return n2;
    }

    public int createEntityReference(int n) {
        int n2;
        int n3 = this.createNode((short)5);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n2 = this.fParserState.getEntityPool().getEntityName(n);
        return n3;
    }

    public int createElement(int n, int n2) {
        int n3 = this.createNode((short)1);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n;
        if (n2 != -1) {
            AttrPool attrPool = this.fParserState.getAttrPool();
            int n6 = attrPool.getFirstAttr(n2);
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = n6;
            while (n10 != -1) {
                int n11 = this.createNode((short)2);
                int n12 = n11 >> 11;
                int n13 = n11 & 0x7FF;
                this.fNodeParent[n12][n13] = n3;
                this.fNodeName[n12][n13] = attrPool.getAttrName(n10);
                this.fNodeValue[n12][n13] = attrPool.isSpecified(n10) ? 1 : 0;
                int n14 = this.createNode((short)3);
                int n15 = n14 >> 11;
                int n16 = n14 & 0x7FF;
                this.fNodeValue[n15][n16] = attrPool.getAttValue(n10);
                this.appendChild(n11, n14);
                if (n10 == n6) {
                    this.fNodeValue[n4][n5] = n11;
                } else {
                    this.fNodeNextSib[n8][n9] = n11;
                    this.fNodePrevSib[n12][n13] = n7;
                }
                n7 = n11;
                n8 = n12;
                n9 = n13;
                n10 = attrPool.getNextAttr(n10);
            }
        }
        return n3;
    }

    public int createAttribute(int n, int n2, boolean bl) {
        int n3 = this.createNode((short)2);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n;
        this.fNodeValue[n4][n5] = bl ? 1 : 0;
        int n6 = this.createTextNode(n2, false);
        this.appendChild(n3, n6);
        return n3;
    }

    public int createElementDefinition(int n) {
        int n2 = this.createNode((short)-1);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeName[n3][n4] = n;
        return n2;
    }

    public int createTextNode(int n, boolean bl) {
        int n2 = this.createNode((short)3);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeValue[n3][n4] = n;
        this.fNodeFirstChild[n3][n4] = bl ? 1 : 0;
        return n2;
    }

    public int createCDATASection(int n) {
        int n2 = this.createNode((short)4);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeValue[n3][n4] = n;
        return n2;
    }

    public int createProcessingInstruction(int n, int n2) {
        int n3 = this.createNode((short)7);
        int n4 = n3 >> 11;
        int n5 = n3 & 0x7FF;
        this.fNodeName[n4][n5] = n;
        this.fNodeValue[n4][n5] = n2;
        return n3;
    }

    public int createComment(int n) {
        int n2 = this.createNode((short)8);
        int n3 = n2 >> 11;
        int n4 = n2 & 0x7FF;
        this.fNodeValue[n3][n4] = n;
        return n2;
    }

    public void appendChild(int n, int n2) {
        int n3;
        int n4 = n >> 11;
        int n5 = n & 0x7FF;
        int n6 = n2 >> 11;
        int n7 = n2 & 0x7FF;
        this.fNodeParent[n6][n7] = n;
        this.fNodePrevSib[n6][n7] = n3 = this.fNodeLastChild[n4][n5];
        if (n3 == -1) {
            this.fNodeFirstChild[n4][n5] = n2;
        } else {
            int n8 = n3 >> 11;
            int n9 = n3 & 0x7FF;
            this.fNodeNextSib[n8][n9] = n2;
        }
        this.fNodeLastChild[n4][n5] = n2;
    }

    public void setAsFirstChild(int n, int n2) {
        int n3 = n >> 11;
        int n4 = n & 0x7FF;
        int n5 = n2 >> 11;
        int n6 = n2 & 0x7FF;
        this.fNodeFirstChild[n3][n4] = n2;
        int n7 = n2;
        while (n7 != -1) {
            n2 = n7;
            n7 = this.fNodeNextSib[n5][n6];
            n5 = n7 >> 11;
            n6 = n7 & 0x7FF;
        }
        this.fNodeLastChild[n3][n4] = n2;
    }

    public int getParentNode(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeParent[n2][n3];
    }

    public int getFirstChild(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeFirstChild[n2][n3];
    }

    public int getLastChild(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodeLastChild[n2][n3];
        if (n4 != -1 && this.fNodeType[n2][n3] == 3) {
            int n5 = this.fNodePrevSib[n2][n3];
            n2 = n5 >> 11;
            n3 = n5 & 0x7FF;
            if (n5 != -1 && this.fNodeType[n2][n3] == 3) {
                while (n5 != -1 && this.fNodeType[n2][n3] == 3) {
                    n = n5;
                    n5 = this.fNodePrevSib[n2][n3];
                    n2 = n5 >> 11;
                    n3 = n5 & 0x7FF;
                }
                return n;
            }
        }
        return n4;
    }

    public int getPreviousSibling(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodePrevSib[n2][n3];
        if (n4 != -1 && this.fNodeType[n2][n3] != 3 && this.fNodeType[n2 = n4 >> 11][n3 = n4 & 0x7FF] == 3) {
            while (n4 != -1 && this.fNodeType[n2][n3] == 3) {
                n = n4;
                n4 = this.fNodePrevSib[n2][n3];
                n2 = n4 >> 11;
                n3 = n4 & 0x7FF;
            }
            return n;
        }
        return n4;
    }

    public int getNextSibling(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        n = this.fNodeNextSib[n2][n3];
        while (n != -1 && this.fNodeType[n2][n3] == 3) {
            n = this.fNodeNextSib[n2][n3];
            n2 = n >> 11;
            n3 = n & 0x7FF;
        }
        return n;
    }

    public int getRealNextSibling(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeNextSib[n2][n3];
    }

    public int lookupElementDefinition(int n) {
        if (this.fNodeCount > 1) {
            int n2 = -1;
            int n3 = this.getFirstChild(0);
            while (n3 != -1) {
                if (this.getNodeType(n3) == 10) {
                    n2 = n3;
                    break;
                }
                n3 = this.getNextSibling(n3);
            }
            int n4 = this.getFirstChild(n2);
            while (n4 != -1) {
                if (this.getIntNodeName(n4) == n) {
                    return n4;
                }
                n4 = this.getNextSibling(n4);
            }
        }
        return -1;
    }

    public int getAttributeList(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeValue[n2][n3];
    }

    public NodeImpl getNodeObject(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        byte by = this.fNodeType[n2][n3];
        NodeImpl nodeImpl = null;
        switch (by) {
            case 2: {
                nodeImpl = new AttrImpl(this, n);
                break;
            }
            case 4: {
                nodeImpl = new CDATASectionImpl(this, n);
                break;
            }
            case 8: {
                nodeImpl = new CommentImpl(this, n);
                break;
            }
            case 9: {
                nodeImpl = this;
                break;
            }
            case 10: {
                nodeImpl = new DocumentTypeImpl(this, n);
                this.docType = (DocumentTypeImpl)nodeImpl;
                break;
            }
            case 1: {
                nodeImpl = new ElementImpl(this, n);
                if (this.docElement != null) break;
                this.docElement = (ElementImpl)nodeImpl;
                break;
            }
            case 6: {
                nodeImpl = new EntityImpl(this, n);
                break;
            }
            case 5: {
                nodeImpl = new EntityReferenceImpl(this, n);
                break;
            }
            case 12: {
                nodeImpl = new NotationImpl(this, n);
                break;
            }
            case 7: {
                nodeImpl = new ProcessingInstructionImpl(this, n);
                break;
            }
            case 3: {
                nodeImpl = new TextImpl(this, n);
                break;
            }
            case -1: {
                nodeImpl = new ElementDefinitionImpl(this, n);
            }
        }
        if (nodeImpl != null) {
            return nodeImpl;
        }
        throw new IllegalArgumentException();
    }

    public String getNodeName(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodeName[n2][n3];
        if (n4 == -1) {
            return null;
        }
        return this.fStringPool.toString(n4);
    }

    public String getNodeValue(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        int n4 = this.fNodeValue[n2][n3];
        if (n4 == -1) {
            return null;
        }
        return this.fStringPool.toString(n4);
    }

    public int getIntNodeName(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeName[n2][n3];
    }

    public int getIntNodeValue(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeValue[n2][n3];
    }

    public short getNodeType(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >> 11;
        int n3 = n & 0x7FF;
        return this.fNodeType[n2][n3];
    }

    public static boolean isXMLName(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        if (!Character.isLetter(cArray[0]) && "_:".indexOf(cArray[0]) == -1) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c = cArray[n];
            int n2 = Character.getType(c);
            if (!Character.isLetterOrDigit(c) && ".-_:".indexOf(c) == -1 && (n2 < 6 || n2 > 8 || c >= '\u06dd' && c <= '\u06de' || c >= '\u20dd' && c <= '\u20e0' || c >= '\u309b') && (n2 != 4 || c >= '\u02d0' && c <= '\u0559' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u309b' && c <= '\u309c') && c != '\u00b7' && c != '\u0387') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void print() {
    }

    void synchronizeChildren() {
        this.syncChildren = false;
        super.synchronizeChildren();
        NodeImpl nodeImpl = this.firstChild;
        while (nodeImpl != null) {
            short s = nodeImpl.getNodeType();
            if (s == 10) {
                this.docType = (DocumentTypeImpl)nodeImpl;
            } else if (s == 1) {
                this.docElement = (ElementImpl)nodeImpl;
            }
            nodeImpl = nodeImpl.nextSibling;
        }
    }

    protected boolean ensureCapacity(int n, int n2) {
        if (this.fNodeType == null) {
            this.fNodeType = new byte[32][];
            this.fNodeName = new int[32][];
            this.fNodeValue = new int[32][];
            this.fNodeParent = new int[32][];
            this.fNodeFirstChild = new int[32][];
            this.fNodeLastChild = new int[32][];
            this.fNodePrevSib = new int[32][];
            this.fNodeNextSib = new int[32][];
        }
        try {
            return this.fNodeType[n][n2] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fNodeType, 0, byArray, 0, n);
            this.fNodeType = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fNodeName, 0, nArray, 0, n);
            this.fNodeName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNodeValue, 0, nArray, 0, n);
            this.fNodeValue = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNodeParent, 0, nArray, 0, n);
            this.fNodeParent = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNodeFirstChild, 0, nArray, 0, n);
            this.fNodeFirstChild = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNodeLastChild, 0, nArray, 0, n);
            this.fNodeLastChild = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNodePrevSib, 0, nArray, 0, n);
            this.fNodePrevSib = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNodeNextSib, 0, nArray, 0, n);
            this.fNodeNextSib = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fNodeType[n] = new byte[2048];
        this.fNodeName[n] = new int[2048];
        this.fNodeValue[n] = new int[2048];
        this.fNodeParent[n] = new int[2048];
        this.fNodeFirstChild[n] = new int[2048];
        this.fNodeLastChild[n] = new int[2048];
        this.fNodePrevSib[n] = new int[2048];
        this.fNodeNextSib[n] = new int[2048];
        return true;
    }

    protected int createNode(short s) {
        int n = this.fNodeCount >> 11;
        int n2 = this.fNodeCount & 0x7FF;
        this.ensureCapacity(n, n2);
        this.fNodeType[n][n2] = (byte)s;
        this.fNodeName[n][n2] = -1;
        this.fNodeValue[n][n2] = -1;
        this.fNodeParent[n][n2] = -1;
        this.fNodeFirstChild[n][n2] = -1;
        this.fNodeLastChild[n][n2] = -1;
        this.fNodePrevSib[n][n2] = -1;
        this.fNodeNextSib[n][n2] = -1;
        return this.fNodeCount++;
    }
}

