/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.NamedNodeMapImpl;
import com.ibm.xml.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentTypeImpl
extends NodeImpl
implements DocumentType {
    protected NamedNodeMapImpl entities;
    protected NamedNodeMapImpl notations;
    protected NamedNodeMapImpl elements;
    protected boolean syncInfo;

    DocumentTypeImpl(DocumentImpl documentImpl, int n) {
        super(documentImpl, n);
        this.syncChildren = false;
        this.syncInfo = true;
    }

    public DocumentTypeImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null);
        this.entities = new NamedNodeMapImpl(documentImpl, null);
        this.notations = new NamedNodeMapImpl(documentImpl, null);
        this.elements = new NamedNodeMapImpl(documentImpl, null);
    }

    public short getNodeType() {
        return 10;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public Node cloneNode(boolean bl) {
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)super.cloneNode(bl);
        documentTypeImpl.entities = this.entities.cloneMap();
        documentTypeImpl.notations = this.notations.cloneMap();
        documentTypeImpl.elements = this.elements.cloneMap();
        return documentTypeImpl;
    }

    public String getName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public NamedNodeMap getEntities() {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        return this.entities;
    }

    public NamedNodeMap getNotations() {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        return this.notations;
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        this.setReadOnly(bl, bl2);
        this.elements.setReadOnly(bl, true);
        this.entities.setReadOnly(bl, true);
        this.notations.setReadOnly(bl, true);
    }

    public NamedNodeMap getElements() {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        return this.elements;
    }

    protected void synchronizeInfo() {
        this.entities = new NamedNodeMapImpl(this.ownerDocument, null);
        this.notations = new NamedNodeMapImpl(this.ownerDocument, null);
        this.elements = new NamedNodeMapImpl(this.ownerDocument, null);
        int n = this.ownerDocument.getFirstChild(this.fNodeIndex);
        while (n != -1) {
            NodeImpl nodeImpl = this.ownerDocument.getNodeObject(n);
            short s = nodeImpl.getNodeType();
            switch (s) {
                case 6: {
                    this.entities.setNamedItem(nodeImpl);
                    break;
                }
                case 12: {
                    this.notations.setNamedItem(nodeImpl);
                    break;
                }
                case -1: {
                    this.elements.setNamedItem(nodeImpl);
                    NamedNodeMap namedNodeMap = nodeImpl.getAttributes();
                    int n2 = this.ownerDocument.getFirstChild(nodeImpl.fNodeIndex);
                    while (n2 != -1) {
                        NodeImpl nodeImpl2 = this.ownerDocument.getNodeObject(n2);
                        namedNodeMap.setNamedItem(nodeImpl2);
                        n2 = this.ownerDocument.getNextSibling(n2);
                    }
                    break;
                }
                default: {
                    System.out.println("DocumentTypeImpl#synchronizeInfo: node.getNodeType() = " + nodeImpl.getNodeType() + ", class = " + nodeImpl.getClass().getName());
                }
            }
            n = this.ownerDocument.getNextSibling(n);
        }
        this.syncInfo = false;
    }
}

