/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DeepNodeListImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.DocumentTypeImpl;
import com.ibm.xml.dom.ElementDefinitionImpl;
import com.ibm.xml.dom.NamedNodeMapImpl;
import com.ibm.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
extends NodeImpl
implements Element {
    protected NamedNodeMapImpl attributes;

    ElementImpl(DocumentImpl documentImpl, int n) {
        super(documentImpl, n);
        this.setupDefaultAttributes(documentImpl);
        int n2 = documentImpl.getAttributeList(n);
        while (n2 != -1) {
            this.setAttributeNode((Attr)((Object)documentImpl.getNodeObject(n2)));
            n2 = documentImpl.getNextSibling(n2);
        }
    }

    public ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string, null);
        this.setupDefaultAttributes(documentImpl);
    }

    protected void setupDefaultAttributes(DocumentImpl documentImpl) {
        ElementDefinitionImpl elementDefinitionImpl;
        NamedNodeMapImpl namedNodeMapImpl = null;
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)documentImpl.getDoctype();
        if (documentTypeImpl != null && (elementDefinitionImpl = (ElementDefinitionImpl)documentTypeImpl.getElements().getNamedItem(this.getNodeName())) != null) {
            namedNodeMapImpl = (NamedNodeMapImpl)elementDefinitionImpl.getAttributes();
        }
        this.attributes = new NamedNodeMapImpl(documentImpl, namedNodeMapImpl);
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        elementImpl.attributes = this.attributes.cloneMap();
        return elementImpl;
    }

    public String getValue() {
        return null;
    }

    public String getAttribute(String string) {
        Attr attr = (Attr)this.attributes.getNamedItem(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String string) {
        return (Attr)this.attributes.getNamedItem(string);
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public String getTagName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void normalize() {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node2 != null && node.getNodeType() == 3 && node2.getNodeType() == 3) {
                ((Text)node).appendData(node2.getNodeValue());
                this.removeChild(node2);
                node2 = node;
            } else if (node.getNodeType() == 1) {
                ((Element)node).normalize();
            }
            node = node2;
        }
    }

    public void removeAttribute(String string) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        AttrImpl attrImpl = (AttrImpl)this.attributes.getNamedItem(string);
        if (attrImpl != null) {
            attrImpl.owned = false;
            this.attributes.removeNamedItem(string);
        }
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        AttrImpl attrImpl = (AttrImpl)this.attributes.getNamedItem(attr.getName());
        if (attrImpl == attr) {
            this.attributes.removeNamedItem(attr.getName());
            attrImpl.owned = false;
            return attrImpl;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public void setAttribute(String string, String string2) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        AttrImpl attrImpl = (AttrImpl)this.getOwnerDocument().createAttribute(string);
        attrImpl.setNodeValue(string2);
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (!(attr instanceof AttrImpl)) {
            throw new DOMExceptionImpl(4, null);
        }
        AttrImpl attrImpl = (AttrImpl)attr;
        AttrImpl attrImpl2 = (AttrImpl)this.attributes.getNamedItem(attr.getName());
        this.attributes.setNamedItem(attrImpl);
        attrImpl.owned = true;
        return attrImpl2;
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        this.attributes.setReadOnly(bl, true);
    }
}

