/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.NodeImpl;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    protected Vector nodes = new Vector();
    protected Document ownerDoc;
    protected NamedNodeMapImpl defaults;
    protected int changes;
    protected int lastDefaultsChanges = -1;
    protected boolean readOnly = false;
    protected int elementNode = -1;

    protected NamedNodeMapImpl(Document document, NamedNodeMapImpl namedNodeMapImpl) {
        this.ownerDoc = document;
        this.defaults = namedNodeMapImpl;
    }

    public int getLength() {
        this.reconcileDefaults();
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    public Node item(int n) {
        this.reconcileDefaults();
        if (this.nodes != null && n < this.nodes.size()) {
            return (Node)this.nodes.elementAt(n);
        }
        return null;
    }

    public Node getNamedItem(String string) {
        int n = this.findNamePoint(string);
        if (n < 0) {
            return null;
        }
        return (Node)this.nodes.elementAt(n);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (node.getOwnerDocument() != this.ownerDoc) {
            throw new DOMExceptionImpl(4, null);
        }
        if (node instanceof AttrImpl && ((AttrImpl)node).owned) {
            throw new DOMExceptionImpl(10, null);
        }
        int n = this.findNamePoint(node.getNodeName());
        Node node2 = null;
        if (n >= 0) {
            node2 = (Node)this.nodes.elementAt(n);
            this.nodes.setElementAt(node, n);
        } else {
            n = -1 - n;
            if (this.nodes == null) {
                this.nodes = new Vector();
            }
            this.nodes.insertElementAt(node, n);
        }
        ++this.changes;
        return node2;
    }

    public Node removeNamedItem(String string) throws DOMException {
        Node node;
        int n = this.findNamePoint(string);
        if (n < 0) {
            throw new DOMExceptionImpl(8, null);
        }
        Node node2 = (Node)this.nodes.elementAt(n);
        if (this.defaults != null && (node = this.defaults.getNamedItem(string)) != null) {
            this.nodes.setElementAt(node, n);
        } else {
            this.nodes.removeElementAt(n);
        }
        ++this.changes;
        return node2;
    }

    public NamedNodeMapImpl cloneMap() {
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl(this.ownerDoc, this.defaults);
        if (this.nodes != null) {
            namedNodeMapImpl.nodes = new Vector(this.nodes.size());
            int n = 0;
            while (n < this.nodes.size()) {
                namedNodeMapImpl.nodes.addElement(((NodeImpl)this.nodes.elementAt(n)).cloneNode(true));
                ++n;
            }
        }
        namedNodeMapImpl.defaults = this.defaults;
        return namedNodeMapImpl;
    }

    void setReadOnly(boolean bl, boolean bl2) {
        this.readOnly = bl;
        if (bl2 && this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeImpl)enumeration.nextElement()).setReadOnly(bl, bl2);
            }
        }
    }

    private int findNamePoint(String string) {
        this.reconcileDefaults();
        int n = 0;
        if (this.nodes != null) {
            int n2 = 0;
            int n3 = this.nodes.size() - 1;
            while (n2 <= n3) {
                n = (n2 + n3) / 2;
                int n4 = string.compareTo(((Node)this.nodes.elementAt(n)).getNodeName());
                if (n4 == 0) {
                    return n;
                }
                if (n4 < 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = n + 1;
            }
            if (n2 > n) {
                n = n2;
            }
        }
        return -1 - n;
    }

    protected void reconcileDefaults() {
        if (this.defaults != null && this.lastDefaultsChanges != this.defaults.changes) {
            int n = 0;
            int n2 = 0;
            int n3 = this.nodes.size();
            int n4 = this.defaults.nodes.size();
            Attr attr = n3 == 0 ? null : (Attr)this.nodes.elementAt(0);
            Attr attr2 = n4 == 0 ? null : (Attr)this.defaults.nodes.elementAt(0);
            while (n < n3 && n2 < n4) {
                attr = (Attr)this.nodes.elementAt(n);
                attr2 = (Attr)this.defaults.nodes.elementAt(n2);
                int n5 = attr.getNodeName().compareTo(attr2.getNodeName());
                if (n5 == 0 && !attr.getSpecified()) {
                    this.nodes.setElementAt(attr2, n);
                    ++n;
                    ++n2;
                    continue;
                }
                if (n5 > 0) {
                    this.nodes.insertElementAt(attr2, n);
                    ++n;
                    ++n2;
                    continue;
                }
                if (!attr.getSpecified()) {
                    this.nodes.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            while (n2 < n4) {
                this.nodes.addElement(this.defaults.nodes.elementAt(n2++));
            }
            this.lastDefaultsChanges = this.defaults.changes;
        }
    }
}

