/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.CharacterDataImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    boolean isIgnorableWhitespace = false;

    TextImpl(DocumentImpl documentImpl, int n) {
        super(documentImpl, n);
    }

    public TextImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, string);
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public boolean isIgnorableWhitespace() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.isIgnorableWhitespace;
    }

    public void setIgnorableWhitespace(boolean bl) {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        this.isIgnorableWhitespace = bl;
    }

    public Node cloneNode(boolean bl) {
        return this.ownerDocument.createTextNode(this.getNodeValue());
    }

    public Text splitText(int n) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        if (n < 0 || n > this.value.length() - 1) {
            throw new DOMExceptionImpl(1, null);
        }
        Text text = this.ownerDocument.createTextNode(this.value.substring(n));
        this.setNodeValue(this.value.substring(0, n));
        if (this.parentNode != null) {
            this.parentNode.insertBefore(text, this.nextSibling);
        }
        return text;
    }

    protected void synchronizeData() {
        this.value = this.ownerDocument.getNodeValue(this.fNodeIndex);
        int n = -1;
        if (this.getNodeType() == 3 && (n = this.ownerDocument.getParentNode(this.fNodeIndex)) != -1 && this.ownerDocument.getNodeType(n) == 1) {
            int n2 = this.ownerDocument.getRealNextSibling(this.fNodeIndex);
            short s = this.ownerDocument.getNodeType(n2);
            if (n2 != -1 && s == 3) {
                StringBuffer stringBuffer = new StringBuffer(this.value);
                while (n2 != -1 && s == 3) {
                    stringBuffer.append(this.ownerDocument.getNodeValue(n2));
                    n2 = this.ownerDocument.getRealNextSibling(n2);
                    s = this.ownerDocument.getNodeType(n2);
                }
                this.value = stringBuffer.toString();
            }
        }
        this.syncData = false;
    }

    protected void synchronizeChildren() {
        this.isIgnorableWhitespace = this.ownerDocument.getFirstChild(this.fNodeIndex) == 1;
        this.syncChildren = false;
    }
}

