/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.internal.StringHasher;

public final class DefaultStringPool
implements StringPool {
    private static final int INITIAL_CHUNK_SHIFT = 5;
    private static final int INITIAL_CHUNK_SIZE = 32;
    private static final int CHUNK_SHIFT = 10;
    private static final int CHUNK_SIZE = 1024;
    private static final int CHUNK_MASK = 1023;
    private static final int INITIAL_CHUNK_COUNT = 32;
    private ParserState fParserState;
    private int fStringCount;
    private int fNullString;
    private int fStringFreeList = -1;
    private String[][] fString = new String[32][];
    private StringProducer[][] fStringProducer = new StringProducer[32][];
    private int[][] fOffset = new int[32][];
    private int[][] fLength = new int[32][];
    private int fStringListCount;
    private int fActiveStringList = -1;
    private int[][] fStringList = new int[32][];
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 128;
    private int[][] fSymbolTable = new int[128][];

    public DefaultStringPool(ParserState parserState) {
        this.fParserState = parserState;
        this.fNullString = this.addSymbol("");
    }

    public void reset(ParserState parserState) {
        this.fParserState = parserState;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fStringCount) {
            this.fString[n][n2] = null;
            this.fStringProducer[n][n2] = null;
            if (++n2 == 1024) {
                ++n;
                n2 = 0;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < 128) {
            this.fSymbolTable[n4] = null;
            ++n4;
        }
        this.fStringCount = 0;
        this.fStringFreeList = -1;
        this.fStringListCount = 0;
        this.fActiveStringList = -1;
        this.fNullString = this.addSymbol("");
    }

    public StringPool resetOrCopy(ParserState parserState) {
        return new DefaultStringPool(parserState);
    }

    private boolean ensureCapacity(int n, int n2) {
        block4: {
            try {
                return this.fOffset[n][n2] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n2 == 0) {
                    String[][] stringArray = new String[n * 2][];
                    System.arraycopy(this.fString, 0, stringArray, 0, n);
                    this.fString = stringArray;
                    StringProducer[][] stringProducerArray = new StringProducer[n * 2][];
                    System.arraycopy(this.fStringProducer, 0, stringProducerArray, 0, n);
                    this.fStringProducer = stringProducerArray;
                    int[][] nArray = new int[n * 2][];
                    System.arraycopy(this.fOffset, 0, nArray, 0, n);
                    this.fOffset = nArray;
                    nArray = new int[n * 2][];
                    System.arraycopy(this.fLength, 0, nArray, 0, n);
                    this.fLength = nArray;
                    break block4;
                }
                String[] stringArray = new String[n2 * 2];
                System.arraycopy(this.fString[n], 0, stringArray, 0, n2);
                this.fString[n] = stringArray;
                StringProducer[] stringProducerArray = new StringProducer[n2 * 2];
                System.arraycopy(this.fStringProducer[n], 0, stringProducerArray, 0, n2);
                this.fStringProducer[n] = stringProducerArray;
                int[] nArray = new int[n2 * 2];
                System.arraycopy(this.fOffset[n], 0, nArray, 0, n2);
                this.fOffset[n] = nArray;
                nArray = new int[n2 * 2];
                System.arraycopy(this.fLength[n], 0, nArray, 0, n2);
                this.fLength[n] = nArray;
                return true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.fString[n] = new String[32];
        this.fStringProducer[n] = new StringProducer[32];
        this.fOffset[n] = new int[32];
        this.fLength[n] = new int[32];
        return true;
    }

    private void checkStringCount() {
    }

    public int addString(String string) {
        int n;
        int n2;
        int n3;
        if (this.fStringFreeList != -1) {
            n3 = this.fStringFreeList;
            n2 = n3 >> 10;
            n = n3 & 0x3FF;
            this.fStringFreeList = this.fOffset[n2][n];
        } else {
            n3 = this.fStringCount++;
            n2 = n3 >> 10;
            n = n3 & 0x3FF;
            this.ensureCapacity(n2, n);
        }
        this.fString[n2][n] = string;
        this.fStringProducer[n2][n] = null;
        this.fOffset[n2][n] = 0;
        this.fLength[n2][n] = string.length();
        return n3;
    }

    public int addString(StringProducer stringProducer, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.fStringFreeList != -1) {
            n5 = this.fStringFreeList;
            n4 = n5 >> 10;
            n3 = n5 & 0x3FF;
            this.fStringFreeList = this.fOffset[n4][n3];
        } else {
            n5 = this.fStringCount++;
            n4 = n5 >> 10;
            n3 = n5 & 0x3FF;
            this.ensureCapacity(n4, n3);
        }
        this.fString[n4][n3] = null;
        this.fStringProducer[n4][n3] = stringProducer;
        this.fOffset[n4][n3] = n;
        this.fLength[n4][n3] = n2;
        return n5;
    }

    private void hashSymbol(int[] nArray, int n, int n2, int n3) {
        if (nArray == null) {
            nArray = new int[13];
            nArray[0] = 1;
            nArray[1] = n;
            nArray[2] = n2;
            nArray[3] = n3;
            int n4 = n % 128;
            this.fSymbolTable[n4] = nArray;
            return;
        }
        int n5 = nArray[0];
        int n6 = 1 + n5 * 3;
        if (n6 == nArray.length) {
            int n7 = n5 + 4;
            int[] nArray2 = new int[1 + n7 * 3];
            System.arraycopy(nArray, 0, nArray2, 0, n6);
            nArray = nArray2;
            int n8 = n % 128;
            this.fSymbolTable[n8] = nArray;
        }
        nArray[n6++] = n;
        nArray[n6++] = n2;
        nArray[n6++] = n3;
        nArray[0] = ++n5;
    }

    public int addSymbol(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        int n5 = StringHasher.hashString(string, n4);
        int n6 = n5 % 128;
        int[] nArray = this.fSymbolTable[n6];
        if (nArray != null) {
            n3 = 1;
            n2 = 0;
            while (n2 < nArray[0]) {
                int n7;
                if (nArray[n3] == n5 && string.equals(this.fString[n = nArray[n3 + 1]][n7 = nArray[n3 + 2]])) {
                    return (n << 10) + n7;
                }
                n3 += 3;
                ++n2;
            }
        }
        if (this.fStringFreeList != -1) {
            n = this.fStringFreeList;
            n3 = n >> 10;
            n2 = n & 0x3FF;
            this.fStringFreeList = this.fOffset[n3][n2];
        } else {
            n = this.fStringCount++;
            n3 = n >> 10;
            n2 = n & 0x3FF;
            this.ensureCapacity(n3, n2);
        }
        this.fString[n3][n2] = string;
        this.fStringProducer[n3][n2] = null;
        this.fOffset[n3][n2] = -1;
        this.fLength[n3][n2] = n4;
        this.hashSymbol(nArray, n5, n3, n2);
        return n;
    }

    public int addSymbol(StringProducer stringProducer, int n, int n2, int n3) {
        String string;
        int n4;
        int n5;
        int n6;
        int n7 = n3 % 128;
        int[] nArray = this.fSymbolTable[n7];
        if (nArray != null) {
            n6 = 1;
            n5 = 0;
            while (n5 < nArray[0]) {
                int n8;
                if (nArray[n6] == n3 && stringProducer.equalsString(n, n2, this.fString[n4 = nArray[n6 + 1]][n8 = nArray[n6 + 2]], this.fLength[n4][n8])) {
                    return (n4 << 10) + n8;
                }
                n6 += 3;
                ++n5;
            }
        }
        if (this.fStringFreeList != -1) {
            n4 = this.fStringFreeList;
            n6 = n4 >> 10;
            n5 = n4 & 0x3FF;
            this.fStringFreeList = this.fOffset[n6][n5];
        } else {
            n4 = this.fStringCount++;
            n6 = n4 >> 10;
            n5 = n4 & 0x3FF;
            this.ensureCapacity(n6, n5);
        }
        this.fString[n6][n5] = string = stringProducer.toString(n, n2);
        this.fStringProducer[n6][n5] = null;
        this.fOffset[n6][n5] = -1;
        this.fLength[n6][n5] = string.length();
        this.hashSymbol(nArray, n3, n6, n5);
        return n4;
    }

    private boolean ensureListCapacity(int n, int n2) {
        block4: {
            try {
                return this.fStringList[n][n2] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n2 == 0) {
                    int[][] nArray = new int[n * 2][];
                    System.arraycopy(this.fStringList, 0, nArray, 0, n);
                    this.fStringList = nArray;
                    break block4;
                }
                int[] nArray = new int[n2 * 2];
                System.arraycopy(this.fStringList[n], 0, nArray, 0, n2);
                this.fStringList[n] = nArray;
                return true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.fStringList[n] = new int[32];
        return true;
    }

    public int startStringList() {
        this.fActiveStringList = this.fStringListCount;
        return this.fStringListCount;
    }

    public boolean addStringToList(int n, int n2) {
        if (n2 == -1 || n != this.fActiveStringList) {
            return false;
        }
        int n3 = this.fStringListCount >> 10;
        int n4 = this.fStringListCount & 0x3FF;
        this.ensureListCapacity(n3, n4);
        this.fStringList[n3][n4] = n2;
        ++this.fStringListCount;
        return true;
    }

    public void finishStringList(int n) {
        if (n != this.fActiveStringList) {
            return;
        }
        int n2 = this.fStringListCount >> 10;
        int n3 = this.fStringListCount & 0x3FF;
        this.ensureListCapacity(n2, n3);
        this.fStringList[n2][n3] = -1;
        this.fActiveStringList = -1;
        ++this.fStringListCount;
    }

    public int stringListLength(int n) {
        int n2 = n >> 10;
        int n3 = n & 0x3FF;
        int n4 = 0;
        while (this.fStringList[n2][n3] != -1) {
            ++n4;
            if (++n3 != 1024) continue;
            ++n2;
            n3 = 0;
        }
        return n4;
    }

    public boolean stringInList(int n, int n2) {
        int n3 = n >> 10;
        int n4 = n & 0x3FF;
        while (this.fStringList[n3][n4] != n2) {
            if (this.fStringList[n3][n4] == -1) {
                return false;
            }
            if (++n4 != 1024) continue;
            ++n3;
            n4 = 0;
        }
        return true;
    }

    public int[] stringsInList(int n) {
        int n2 = n >> 10;
        int n3 = n & 0x3FF;
        int[] nArray = new int[this.stringListLength(n)];
        int n4 = 0;
        while (this.fStringList[n2][n3] != -1 && n4 < nArray.length) {
            nArray[n4] = this.fStringList[n2][n3];
            ++n4;
            if (++n3 != 1024) continue;
            ++n2;
            n3 = 0;
        }
        return nArray;
    }

    private void releaseStringInternal(int n, int n2) {
        int n3;
        this.fString[n][n2] = null;
        this.fStringProducer[n][n2] = null;
        this.fLength[n][n2] = 0;
        this.fOffset[n][n2] = this.fStringFreeList;
        this.fStringFreeList = n3 = (n << 10) + n2;
    }

    public void releaseString(int n) {
        if (n < 0 || n >= this.fStringCount) {
            return;
        }
        int n2 = n >> 10;
        int n3 = n & 0x3FF;
        if (this.fOffset[n2][n3] != -1) {
            this.releaseStringInternal(n2, n3);
        }
    }

    public String toString(int n) {
        if (n < 0 || n >= this.fStringCount) {
            return null;
        }
        int n2 = n >> 10;
        int n3 = n & 0x3FF;
        String string = this.fString[n2][n3];
        if (string != null) {
            return string;
        }
        this.fString[n2][n3] = string = this.fStringProducer[n2][n3].toString(this.fOffset[n2][n3], this.fLength[n2][n3]);
        return string;
    }

    public String orphanString(int n) {
        if (n < 0 || n >= this.fStringCount) {
            return null;
        }
        int n2 = n >> 10;
        int n3 = n & 0x3FF;
        String string = this.fString[n2][n3];
        if (string == null) {
            string = this.fStringProducer[n2][n3].toString(this.fOffset[n2][n3], this.fLength[n2][n3]);
            this.releaseStringInternal(n2, n3);
        } else if (this.fOffset[n2][n3] != -1) {
            this.releaseStringInternal(n2, n3);
        }
        return string;
    }
}

