/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.OutputStream;
import java.util.LinkedList;
import sun.plugin.ConsoleWindow;

public class MainConsoleWriter
implements Runnable {
    private LinkedList queue = new LinkedList();
    private OutputStream traceOutputStream;
    private ConsoleWindow console = null;

    MainConsoleWriter(ConsoleWindow consoleWindow, OutputStream outputStream) {
        this.console = consoleWindow;
        this.traceOutputStream = outputStream;
        Thread thread = new Thread((Runnable)this, "Main Console Writer");
        thread.setDaemon(false);
        thread.setPriority(6);
        thread.start();
    }

    public void run() {
        while (true) {
            byte[] byArray = null;
            try {
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    if (this.queue.size() > 0) {
                        byArray = (byte[])this.queue.remove(0);
                    } else {
                        this.queue.wait();
                    }
                }
                if (byArray == null) continue;
                this.trace(new String(byArray));
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void enQueue(byte[] byArray) {
        try {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(byArray);
                this.queue.notifyAll();
            }
        }
        catch (Exception exception) {
            this.console.append(exception.toString());
        }
    }

    private void trace(String string) {
        try {
            if (this.console != null) {
                this.console.append(string);
            }
            this.traceOutputStream.write(string.getBytes());
            this.traceOutputStream.flush();
        }
        catch (Exception exception) {
            this.console.append(exception.toString());
        }
    }
}

