/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.PoolTcpEndpoint;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.TcpEndpointConnector;

public class PoolTcpConnector
extends TcpEndpointConnector
implements ServerConnector {
    public static final String VHOST_PORT = "vhost_port";
    public static final String VHOST_NAME = "vhost_name";
    public static final String SERVER = "server";
    public static final String VHOST_ADDRESS = "vhost_address";
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final String INET = "inet";
    public static final String PORT = "port";
    public static final String HANDLER = "handler";
    public static final String THREAD_POOL = "thread_pool";
    public static final String MAX_THREADS = "max_threads";
    public static final String MAX_SPARE_THREADS = "max_spare_threads";
    public static final String MIN_SPARE_THREADS = "min_spare_threads";
    public static final String BACKLOG = "backlog";
    String handlerClassName;
    PoolTcpEndpoint ep = new PoolTcpEndpoint();
    TcpConnectionHandler con;
    ContextManager cm;
    private InetAddress address;
    private int port;
    private int backlog = -1;
    private boolean usePools = true;
    private int maxThreads = -1;
    private int maxSpareThreads = -1;
    private int minSpareThreads = -1;
    int vport;
    private ServerSocketFactory socketFactory;
    private ServerSocket serverSocket;
    boolean running = true;

    public Object getAttribute(String prop) {
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public TcpConnectionHandler getTcpConnectionHandler() {
        return this.con;
    }

    public void setAttribute(String prop, Object value) {
        if (!VHOST_NAME.equals(prop)) {
            if (VHOST_PORT.equals(prop)) {
                this.vport = (Integer)value;
            } else if (VHOST_ADDRESS.equals(prop)) {
                this.address = (InetAddress)value;
            } else if (!SERVER.equals(prop) && SOCKET_FACTORY.equals(prop)) {
                this.socketFactory = (ServerSocketFactory)value;
            }
        }
    }

    public void setContextManager(ContextManager ctx) {
        this.cm = ctx;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPort(String portS) {
        this.port = this.string2Int(portS);
    }

    public void setProperty(String prop, String value) {
        if (PORT.equals(prop)) {
            this.setPort(value);
        } else if (HANDLER.equals(prop)) {
            try {
                Class<?> chC = Class.forName(value);
                this.con = (TcpConnectionHandler)chC.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (THREAD_POOL.equals(prop)) {
            if (value.equalsIgnoreCase("off")) {
                this.usePools = false;
            }
        } else if (INET.equals(prop)) {
            try {
                this.address = InetAddress.getByName(value);
            }
            catch (Exception exception) {}
        } else if (MAX_THREADS.equals(prop)) {
            this.maxThreads = this.string2Int(value);
        } else if (MAX_SPARE_THREADS.equals(prop)) {
            this.maxSpareThreads = this.string2Int(value);
        } else if (MIN_SPARE_THREADS.equals(prop)) {
            this.minSpareThreads = this.string2Int(value);
        } else if (BACKLOG.equals(prop)) {
            this.backlog = this.string2Int(value);
        }
    }

    public void setTcpConnectionHandler(TcpConnectionHandler handler) {
        this.con = handler;
    }

    public void start() throws Exception {
        if (this.con == null) {
            throw new Exception("Invalid ConnectionHandler");
        }
        this.con.setAttribute("context.manager", this.cm);
        this.ep.setPort(this.port);
        this.ep.setAddress(this.address);
        this.ep.setPoolOn(this.usePools);
        if (this.backlog > 0) {
            this.ep.setBacklog(this.backlog);
        }
        if (this.maxThreads > 0) {
            this.ep.setMaxThreads(this.maxThreads);
        }
        if (this.maxSpareThreads > 0) {
            this.ep.setMaxSpareThreads(this.maxSpareThreads);
        }
        if (this.minSpareThreads > 0) {
            this.ep.setMinSpareThreads(this.minSpareThreads);
        }
        if (this.socketFactory != null) {
            this.ep.setServerSocketFactory(this.socketFactory);
        }
        this.ep.setConnectionHandler(this.con);
        this.ep.startEndpoint();
        System.out.println("Starting tcp endpoint on " + this.port + " with " + this.con.getClass().getName());
    }

    public void stop() throws Exception {
        this.ep.stopEndpoint();
    }

    private int string2Int(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

