/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.WeakHashMap;

class ClassMapper {
    private static final WeakHashMap serviceMap = new WeakHashMap(23);
    private static final WeakHashMap entryMap = new WeakHashMap(17);
    private static final WeakHashMap fieldMap = new WeakHashMap(17);
    private static final FieldComparator comparator = new FieldComparator();
    private static final ServiceType[] empty = new ServiceType[0];
    private static final Class[] noArg = new Class[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;

    private ClassMapper() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static EntryField[] getFields(Class clazz) {
        WeakHashMap weakHashMap = fieldMap;
        synchronized (weakHashMap) {
            SoftReference softReference = (SoftReference)fieldMap.get(clazz);
            EntryField[] entryFieldArray = null;
            if (softReference != null) {
                entryFieldArray = (EntryField[])softReference.get();
            }
            if (entryFieldArray == null) {
                Field[] fieldArray = clazz.getFields();
                Arrays.sort(fieldArray, comparator);
                int n = 0;
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    if ((fieldArray[n2].getModifiers() & 0x98) == 0) {
                        if (fieldArray[n2].getType().isPrimitive()) {
                            throw new IllegalArgumentException("entry class " + clazz.getName() + " has a primitive field");
                        }
                        fieldArray[n++] = fieldArray[n2];
                    }
                    ++n2;
                }
                entryFieldArray = new EntryField[n];
                while (--n >= 0) {
                    entryFieldArray[n] = new EntryField(fieldArray[n]);
                }
                fieldMap.put(clazz, new SoftReference<EntryField[]>(entryFieldArray));
            }
            EntryField[] entryFieldArray2 = entryFieldArray;
            Object var3_8 = null;
            return entryFieldArray2;
        }
    }

    private static EntryClass toEntryClass(Class clazz) {
        if (clazz != null) {
            return ClassMapper.toEntryClassBase((Class)clazz, (boolean)false).eclass;
        }
        return null;
    }

    public static EntryClassBase toEntryClassBase(Class clazz) {
        WeakHashMap weakHashMap = entryMap;
        synchronized (weakHashMap) {
            EntryClassBase entryClassBase = ClassMapper.toEntryClassBase(clazz, true);
            Object var3_3 = null;
            return entryClassBase;
        }
    }

    private static EntryClassBase toEntryClassBase(Class clazz, boolean bl) {
        if (clazz == null) {
            return null;
        }
        SoftReference softReference = (SoftReference)entryMap.get(clazz);
        EntryClassBase entryClassBase = null;
        if (softReference != null) {
            entryClassBase = (EntryClassBase)softReference.get();
        }
        if (entryClassBase == null) {
            if (bl) {
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    throw new IllegalArgumentException("entry class " + clazz.getName() + " is not public");
                }
                try {
                    clazz.getConstructor(noArg);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalArgumentException("entry class " + clazz.getName() + " does not have a public no-arg constructor");
                }
            }
            entryClassBase = new EntryClassBase(new EntryClass(clazz, ClassMapper.toEntryClass(clazz.getSuperclass())), null);
            entryMap.put(clazz, new SoftReference<EntryClassBase>(entryClassBase));
        }
        if (bl && entryClassBase.codebase == null) {
            entryClassBase.setCodebase(clazz);
        }
        return entryClassBase;
    }

    private static ServiceType toServiceType(Class clazz) {
        if (clazz != null) {
            return ClassMapper.toServiceTypeBase((Class)clazz, (boolean)false).type;
        }
        return null;
    }

    public static ServiceType[] toServiceType(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) {
            return empty;
        }
        ServiceType[] serviceTypeArray = new ServiceType[classArray.length];
        WeakHashMap weakHashMap = serviceMap;
        synchronized (weakHashMap) {
            int n = classArray.length;
            while (--n >= 0) {
                serviceTypeArray[n] = ClassMapper.toServiceType(classArray[n]);
            }
        }
        return serviceTypeArray;
    }

    public static ServiceTypeBase toServiceTypeBase(Class clazz) {
        WeakHashMap weakHashMap = serviceMap;
        synchronized (weakHashMap) {
            ServiceTypeBase serviceTypeBase = ClassMapper.toServiceTypeBase(clazz, true);
            Object var3_3 = null;
            return serviceTypeBase;
        }
    }

    private static ServiceTypeBase toServiceTypeBase(Class clazz, boolean bl) {
        if (clazz == null) {
            return null;
        }
        SoftReference softReference = (SoftReference)serviceMap.get(clazz);
        ServiceTypeBase serviceTypeBase = null;
        if (softReference != null) {
            serviceTypeBase = (ServiceTypeBase)softReference.get();
        }
        if (serviceTypeBase == null) {
            serviceTypeBase = new ServiceTypeBase(new ServiceType(clazz, ClassMapper.toServiceType(clazz.getSuperclass()), ClassMapper.toServiceType(clazz.getInterfaces())), null);
            serviceMap.put(clazz, new SoftReference<ServiceTypeBase>(serviceTypeBase));
        }
        if (bl && serviceTypeBase.codebase == null) {
            serviceTypeBase.setCodebase(clazz);
        }
        return serviceTypeBase;
    }

    static class EntryField {
        public final Field field;
        public final boolean marshal;

        public EntryField(Field field) {
            this.field = field;
            Class<?> clazz = field.getType();
            this.marshal = (clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ClassMapper.class$("java.lang.String"))) || clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ClassMapper.class$("java.lang.Integer"))) || clazz == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ClassMapper.class$("java.lang.Boolean"))) || clazz == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = ClassMapper.class$("java.lang.Character"))) || clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ClassMapper.class$("java.lang.Long"))) || clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ClassMapper.class$("java.lang.Float"))) || clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ClassMapper.class$("java.lang.Double"))) || clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ClassMapper.class$("java.lang.Byte"))) || clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ClassMapper.class$("java.lang.Short")))) ^ true;
        }
    }

    private static class FieldComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Field field = (Field)object;
            Field field2 = (Field)object2;
            if (field == field2) {
                return 0;
            }
            if (field.getDeclaringClass() == field2.getDeclaringClass()) {
                return field.getName().compareTo(field2.getName());
            }
            if (field.getDeclaringClass().isAssignableFrom(field2.getDeclaringClass())) {
                return -1;
            }
            return 1;
        }
    }
}

