/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.RegistrarProxy;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import net.jini.core.entry.Entry;

class EntryRep
implements Serializable,
Cloneable {
    public EntryClass eclass;
    public String codebase;
    public Object[] fields;
    private static final long serialVersionUID = 7539800683869455714L;

    public EntryRep(Entry entry) throws RemoteException {
        EntryClassBase entryClassBase = ClassMapper.toEntryClassBase(entry.getClass());
        this.eclass = entryClassBase.eclass;
        this.codebase = entryClassBase.codebase;
        try {
            ClassMapper.EntryField[] entryFieldArray = ClassMapper.getFields(entry.getClass());
            this.fields = new Object[entryFieldArray.length];
            int n = entryFieldArray.length;
            while (--n >= 0) {
                ClassMapper.EntryField entryField = entryFieldArray[n];
                MarshalledObject<Object> marshalledObject = entryField.field.get(entry);
                if (entryField.marshal && marshalledObject != null) {
                    marshalledObject = new MarshalledObject<Object>(marshalledObject);
                }
                this.fields[n] = marshalledObject;
            }
        }
        catch (IOException iOException) {
            throw new MarshalException("error marshalling arguments", iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MarshalException("error marshalling arguments", illegalAccessException);
        }
    }

    public Object clone() {
        try {
            EntryRep entryRep = (EntryRep)super.clone();
            entryRep.fields = (Object[])entryRep.fields.clone();
            return entryRep;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EntryRep) {
            EntryRep entryRep = (EntryRep)object;
            if (!this.eclass.equals(entryRep.eclass) || this.fields.length != entryRep.fields.length) {
                return false;
            }
            int n = this.fields.length;
            while (--n >= 0) {
                if ((this.fields[n] != null || entryRep.fields[n] == null) && (this.fields[n] == null || this.fields[n].equals(entryRep.fields[n]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Entry get() {
        try {
            Class clazz = this.eclass.toClass(this.codebase);
            ClassMapper.EntryField[] entryFieldArray = ClassMapper.getFields(clazz);
            Entry entry = (Entry)clazz.newInstance();
            int n = entryFieldArray.length;
            while (--n >= 0) {
                try {
                    Object object = this.fields[n];
                    ClassMapper.EntryField entryField = entryFieldArray[n];
                    if (entryField.marshal && object != null) {
                        object = ((MarshalledObject)object).get();
                    }
                    entryField.field.set(entry, object);
                }
                catch (Throwable throwable) {
                    RegistrarProxy.handleException(throwable);
                }
            }
            return entry;
        }
        catch (Throwable throwable) {
            RegistrarProxy.handleException(throwable);
            return null;
        }
    }

    public int hashCode() {
        return this.eclass.hashCode();
    }

    public static Entry[] toEntry(EntryRep[] entryRepArray) {
        Entry[] entryArray = null;
        if (entryRepArray != null) {
            entryArray = new Entry[entryRepArray.length];
            int n = entryRepArray.length;
            while (--n >= 0) {
                entryArray[n] = entryRepArray[n].get();
            }
        }
        return entryArray;
    }

    public static EntryRep[] toEntryRep(Entry[] entryArray, boolean bl) throws RemoteException {
        EntryRep[] entryRepArray = null;
        if (entryArray != null) {
            entryRepArray = new EntryRep[entryArray.length];
            int n = entryArray.length;
            while (--n >= 0) {
                if (entryArray[n] == null) continue;
                entryRepArray[n] = new EntryRep(entryArray[n]);
                if (bl) continue;
                entryRepArray[n].codebase = null;
            }
        }
        return entryRepArray;
    }
}

