/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.ServiceTypeBase;
import com.sun.jini.reggie.Template;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.jini.admin.Administrable;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.core.lookup.ServiceTemplate;

class RegistrarProxy
implements ServiceRegistrar,
Administrable,
Serializable {
    private static final long serialVersionUID = 2425188657680236255L;
    private final Registrar server;
    private final ServiceID serviceID;

    public RegistrarProxy(Registrar registrar, ServiceID serviceID) {
        this.server = registrar;
        this.serviceID = serviceID;
    }

    public boolean equals(Object object) {
        return object instanceof RegistrarProxy && this.serviceID.equals(((RegistrarProxy)object).serviceID);
    }

    public Object getAdmin() throws RemoteException {
        return this.server.getAdmin();
    }

    public Class[] getEntryClasses(ServiceTemplate serviceTemplate) throws RemoteException {
        return EntryClassBase.toClass(this.server.getEntryClasses(new Template(serviceTemplate)));
    }

    public Object[] getFieldValues(ServiceTemplate serviceTemplate, int n, String string) throws NoSuchFieldException, RemoteException {
        ClassMapper.EntryField[] entryFieldArray = ClassMapper.getFields(serviceTemplate.attributeSetTemplates[n].getClass());
        int n2 = entryFieldArray.length;
        while (--n2 >= 0) {
            if (string.equals(entryFieldArray[n2].field.getName())) break;
        }
        if (n2 < 0) {
            throw new NoSuchFieldException(string);
        }
        Object[] objectArray = this.server.getFieldValues(new Template(serviceTemplate), n, n2);
        if (objectArray != null && entryFieldArray[n2].marshal) {
            int n3 = objectArray.length;
            while (--n3 >= 0) {
                try {
                    objectArray[n3] = ((MarshalledObject)objectArray[n3]).get();
                }
                catch (Throwable throwable) {
                    RegistrarProxy.handleException(throwable);
                    objectArray[n3] = null;
                }
            }
        }
        return objectArray;
    }

    public String[] getGroups() throws RemoteException {
        return this.server.getMemberGroups();
    }

    public LookupLocator getLocator() throws RemoteException {
        return this.server.getLocator();
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public Class[] getServiceTypes(ServiceTemplate serviceTemplate, String string) throws RemoteException {
        return ServiceTypeBase.toClass(this.server.getServiceTypes(new Template(serviceTemplate), string));
    }

    static void handleException(final Throwable throwable) {
        if (throwable instanceof Error && !(throwable instanceof LinkageError) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (System.getProperty("com.sun.jini.reggie.proxy.debug") != null) {
                        throwable.printStackTrace();
                    }
                }
                catch (SecurityException securityException) {}
                return null;
            }
        });
    }

    public int hashCode() {
        return this.serviceID.hashCode();
    }

    public Object lookup(ServiceTemplate serviceTemplate) throws RemoteException {
        MarshalledObject marshalledObject = this.server.lookup(new Template(serviceTemplate));
        if (marshalledObject == null) {
            return null;
        }
        try {
            return marshalledObject.get();
        }
        catch (IOException iOException) {
            throw new UnmarshalException("error unmarshalling return", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshalException("error unmarshalling return", classNotFoundException);
        }
    }

    public ServiceMatches lookup(ServiceTemplate serviceTemplate, int n) throws RemoteException {
        return this.server.lookup(new Template(serviceTemplate), n).get();
    }

    public EventRegistration notify(ServiceTemplate serviceTemplate, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) throws RemoteException {
        return this.server.notify(new Template(serviceTemplate), n, remoteEventListener, marshalledObject, l);
    }

    public ServiceRegistration register(ServiceItem serviceItem, long l) throws RemoteException {
        return this.server.register(new Item(serviceItem), l);
    }
}

