/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.core.ClientRequest;
import com.sun.corba.se.internal.core.ClientResponse;
import com.sun.corba.se.internal.core.GIOPVersion;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.ORBVersionFactory;
import com.sun.corba.se.internal.core.Profile;
import com.sun.corba.se.internal.core.ServerRequest;
import com.sun.corba.se.internal.core.ServerResponse;
import com.sun.corba.se.internal.core.ServiceContexts;
import com.sun.corba.se.internal.iiop.IIOPOutputStream;
import com.sun.corba.se.internal.iiop.LocalServerRequestImpl;
import com.sun.corba.se.internal.iiop.LocalServerResponseImpl;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.iiop.RequestMessage;

public class LocalClientRequestImpl
extends IIOPOutputStream
implements ClientRequest {
    private RequestMessage request;
    private int bodyBegin;
    private boolean isOneway;

    public LocalClientRequestImpl(ORB oRB, byte[] byArray, String string, boolean bl, ServiceContexts serviceContexts, int n) {
        super(oRB, null);
        this.isOneway = bl;
        boolean bl2 = !this.isOneway;
        oRB.setORBVersion(ORBVersionFactory.createFromObjectKey(byArray));
        this.request = new RequestMessage(serviceContexts, n, bl2, byArray, string, null, oRB.transportDebugFlag);
        this.request.write(this);
        this.setMessage(this.request);
        this.bodyBegin = this.size;
    }

    public int getRequestId() {
        return this.request.getRequestId();
    }

    public boolean isOneWay() {
        return this.isOneway;
    }

    public ServiceContexts getServiceContexts() {
        return this.request.getServiceContexts();
    }

    public String getOperationName() {
        return this.request.getOperation();
    }

    public byte[] getObjectKey() {
        return this.request.getObjectKey();
    }

    public byte[] getBody() {
        if (this.size <= this.bodyBegin) {
            return null;
        }
        byte[] byArray = new byte[this.size - this.bodyBegin];
        System.arraycopy(this.toByteArray(), this.bodyBegin, byArray, 0, this.size - this.bodyBegin);
        return byArray;
    }

    public ServerRequest getServerRequest() {
        this.getMessage().setSize(this.getBuffer(), this.size);
        LocalServerRequestImpl localServerRequestImpl = new LocalServerRequestImpl((ORB)this.orb, this.toByteArray(), this.request);
        localServerRequestImpl.setOffset(this.bodyBegin);
        return localServerRequestImpl;
    }

    public ClientResponse invoke() {
        ORB oRB = (ORB)this.orb;
        ServerResponse serverResponse = oRB.process(this.getServerRequest());
        LocalServerResponseImpl localServerResponseImpl = (LocalServerResponseImpl)serverResponse;
        return localServerResponseImpl.getClientResponse();
    }

    public ClientResponse reInvoke(IOR[] iORArray) {
        ClientResponse clientResponse;
        IOR iOR = iORArray[0];
        int[] nArray = new int[]{this.bodyBegin};
        while (true) {
            Profile profile = iOR.getProfile();
            byte[] byArray = profile.getObjectKey();
            this.realign(byArray, nArray);
            clientResponse = this.invoke();
            if (!clientResponse.isLocationForward()) break;
            iOR = clientResponse.getForwardedIOR();
            this.bodyBegin = nArray[0];
        }
        iORArray[0] = iOR;
        return clientResponse;
    }

    public ClientResponse reInvokeOnce(IOR[] iORArray) {
        IOR iOR = iORArray[0];
        int[] nArray = new int[]{this.bodyBegin};
        Profile profile = iOR.getProfile();
        byte[] byArray = profile.getObjectKey();
        this.realign(byArray, nArray);
        ClientResponse clientResponse = this.invoke();
        if (clientResponse.isLocationForward()) {
            iORArray[0] = iOR = clientResponse.getForwardedIOR();
        }
        this.bodyBegin = nArray[0];
        return clientResponse;
    }

    public boolean isLocal() {
        return true;
    }

    public GIOPVersion getGIOPVersion() {
        return this.request.getGIOPVersion();
    }
}

