/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.Locale;
import sun.security.action.GetPropertyAction;

public abstract class GraphicsEnvironment {
    private static GraphicsEnvironment localEnv;

    protected GraphicsEnvironment() {
    }

    public static synchronized GraphicsEnvironment getLocalGraphicsEnvironment() {
        if (localEnv == null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.awt.graphicsenv", null));
            try {
                localEnv = (GraphicsEnvironment)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("Could not find class: " + string);
            }
            catch (InstantiationException instantiationException) {
                throw new Error("Could not instantiate Graphics Environment: " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Could not access Graphics Environment: " + string);
            }
        }
        return localEnv;
    }

    public abstract GraphicsDevice[] getScreenDevices();

    public abstract GraphicsDevice getDefaultScreenDevice();

    public abstract Graphics2D createGraphics(BufferedImage var1);

    public abstract Font[] getAllFonts();

    public abstract String[] getAvailableFontFamilyNames();

    public abstract String[] getAvailableFontFamilyNames(Locale var1);
}

