/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import sun.misc.BASE64Decoder;
import sun.security.util.Debug;

public class ManifestEntryVerifier {
    private static final Debug debug = Debug.getInstance("jar");
    HashMap createdDigests;
    ArrayList digests;
    ArrayList manifestHashes;
    private byte[][] manifestHash = new byte[][]{null, null};
    private BASE64Decoder decoder = null;
    private String name = null;
    private Manifest man;
    private boolean skip = true;
    private JarEntry entry;
    private Certificate[] certs = null;
    private static final char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ManifestEntryVerifier(Manifest manifest) {
        this.createdDigests = new HashMap(11);
        this.digests = new ArrayList();
        this.manifestHashes = new ArrayList();
        this.decoder = new BASE64Decoder();
        this.man = manifest;
    }

    public void setEntry(String string, JarEntry jarEntry) throws IOException {
        this.digests.clear();
        this.manifestHashes.clear();
        this.name = string;
        this.entry = jarEntry;
        this.skip = true;
        this.certs = null;
        if (this.man == null || string == null) {
            return;
        }
        Attributes attributes = this.man.getAttributes(string);
        if (attributes == null && (attributes = this.man.getAttributes("./" + string)) == null && (attributes = this.man.getAttributes("/" + string)) == null) {
            return;
        }
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = entry.getKey().toString();
            if (!string2.toUpperCase().endsWith("-DIGEST")) continue;
            String string3 = string2.substring(0, string2.length() - 7);
            MessageDigest messageDigest = (MessageDigest)this.createdDigests.get(string3);
            if (messageDigest == null) {
                try {
                    messageDigest = MessageDigest.getInstance(string3);
                    this.createdDigests.put(string3, messageDigest);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (messageDigest == null) continue;
            this.skip = false;
            messageDigest.reset();
            this.digests.add(messageDigest);
            this.manifestHashes.add(this.decoder.decodeBuffer((String)entry.getValue()));
        }
    }

    public void update(byte by) {
        if (this.skip) {
            return;
        }
        int n = 0;
        while (n < this.digests.size()) {
            ((MessageDigest)this.digests.get(n)).update(by);
            ++n;
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.skip) {
            return;
        }
        int n3 = 0;
        while (n3 < this.digests.size()) {
            ((MessageDigest)this.digests.get(n3)).update(byArray, n, n2);
            ++n3;
        }
    }

    public JarEntry getEntry() {
        return this.entry;
    }

    public Certificate[] verify(Hashtable hashtable, Hashtable hashtable2) throws JarException {
        if (this.skip) {
            return null;
        }
        if (this.certs != null) {
            return this.certs;
        }
        int n = 0;
        while (n < this.digests.size()) {
            MessageDigest messageDigest = (MessageDigest)this.digests.get(n);
            byte[] byArray = (byte[])this.manifestHashes.get(n);
            byte[] byArray2 = messageDigest.digest();
            if (debug != null) {
                debug.println("Manifest Entry: " + this.name + " digest=" + messageDigest.getAlgorithm());
                debug.println("  manifest " + ManifestEntryVerifier.toHex(byArray));
                debug.println("  computed " + ManifestEntryVerifier.toHex(byArray2));
                debug.println();
            }
            if (!MessageDigest.isEqual(byArray2, byArray)) {
                throw new SecurityException(messageDigest.getAlgorithm() + " digest error for " + this.name);
            }
            ++n;
        }
        this.certs = (Certificate[])hashtable2.remove(this.name);
        if (this.certs != null) {
            hashtable.put(this.name, this.certs);
        }
        return this.certs;
    }

    static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hexc[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hexc[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

