/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.JavacOutputStream;
import org.apache.tools.ant.taskdefs.Jikes;
import org.apache.tools.ant.taskdefs.JikesOutputParser;
import org.apache.tools.ant.taskdefs.MatchingTask;
import sun.tools.javac.Main;

public class Javac
extends MatchingTask {
    private File srcDir;
    private File destDir;
    private String compileClasspath;
    private boolean debug = false;
    private boolean optimize = false;
    private boolean deprecation = false;
    private boolean filtering = false;
    private String target;
    private String bootclasspath;
    private String extdirs;
    protected Vector compileList = new Vector();
    protected Hashtable filecopyList = new Hashtable();

    private void addExistingToClasspath(StringBuffer target, String source) {
        StringTokenizer tok = new StringTokenizer(source, System.getProperty("path.separator"), false);
        while (tok.hasMoreTokens()) {
            File f = this.project.resolveFile(tok.nextToken());
            if (f.exists()) {
                target.append(File.pathSeparator);
                target.append(f.getAbsolutePath());
                continue;
            }
            this.project.log("Dropping from classpath: " + f.getAbsolutePath(), 3);
        }
    }

    private void addExtdirsToClasspath(StringBuffer classpath) {
        if (this.extdirs != null) {
            StringTokenizer tok = new StringTokenizer(this.extdirs, File.pathSeparator, false);
            while (tok.hasMoreTokens()) {
                File dir = this.project.resolveFile(tok.nextToken());
                String[] files = dir.list(new JarFilenameFilter());
                int i = 0;
                while (i < files.length) {
                    File f = new File(dir, files[i]);
                    if (f.exists() && f.isFile()) {
                        classpath.append(File.pathSeparator);
                        classpath.append(f.getAbsolutePath());
                    }
                    ++i;
                }
            }
        }
    }

    private void doClassicCompile() throws BuildException {
        this.project.log("Using classic compiler", 3);
        String classpath = this.getCompileClasspath();
        Vector<String> argList = new Vector<String>();
        if (this.deprecation) {
            argList.addElement("-deprecation");
        }
        argList.addElement("-d");
        argList.addElement(this.destDir.getAbsolutePath());
        argList.addElement("-classpath");
        if (Project.getJavaVersion().startsWith("1.1")) {
            argList.addElement(String.valueOf(classpath) + File.pathSeparator + this.srcDir.getAbsolutePath());
        } else {
            argList.addElement(classpath);
            argList.addElement("-sourcepath");
            argList.addElement(this.srcDir.getAbsolutePath());
            if (this.target != null) {
                argList.addElement("-target");
                argList.addElement(this.target);
            }
        }
        if (this.debug) {
            argList.addElement("-g");
        }
        if (this.optimize) {
            argList.addElement("-O");
        }
        if (this.bootclasspath != null) {
            argList.addElement("-bootclasspath");
            argList.addElement(this.bootclasspath);
        }
        if (this.extdirs != null) {
            argList.addElement("-extdirs");
            argList.addElement(this.extdirs);
        }
        this.project.log("Compilation args: " + argList.toString(), 3);
        String[] args = new String[argList.size() + this.compileList.size()];
        int counter = 0;
        int i = 0;
        while (i < argList.size()) {
            args[i] = (String)argList.elementAt(i);
            ++counter;
            ++i;
        }
        StringBuffer niceSourceList = new StringBuffer("Files to be compiled:\r\n");
        Enumeration enumeration = this.compileList.elements();
        while (enumeration.hasMoreElements()) {
            args[counter] = (String)enumeration.nextElement();
            niceSourceList.append("    " + args[counter] + "\r\n");
            ++counter;
        }
        this.project.log(niceSourceList.toString(), 3);
        JavacOutputStream jos = new JavacOutputStream(this.project);
        Main compiler = new Main((OutputStream)jos, "javac");
        compiler.compile(args);
        if (jos.getErrorFlag()) {
            String msg = "Compile failed, messages should have been provided.";
            throw new BuildException(msg);
        }
    }

    private void doJikesCompile() throws BuildException {
        this.project.log("Using jikes compiler", 3);
        StringBuffer classpath = new StringBuffer();
        classpath.append(this.getCompileClasspath());
        this.addExtdirsToClasspath(classpath);
        classpath.append(File.pathSeparator);
        classpath.append(this.srcDir.getAbsolutePath());
        Vector<String> argList = new Vector<String>();
        if (this.deprecation) {
            argList.addElement("-deprecation");
        }
        argList.addElement("-Xstdout");
        argList.addElement("-d");
        argList.addElement(this.destDir.getAbsolutePath());
        argList.addElement("-classpath");
        argList.addElement(classpath.toString());
        if (this.debug) {
            argList.addElement("-g");
        }
        if (this.optimize) {
            argList.addElement("-O");
        }
        boolean emacsMode = false;
        String emacsProperty = this.project.getProperty("build.compiler.emacs");
        if (emacsProperty != null && (emacsProperty.equalsIgnoreCase("on") || emacsProperty.equalsIgnoreCase("true"))) {
            emacsMode = true;
        }
        boolean warnings = true;
        String warningsProperty = this.project.getProperty("build.compiler.warnings");
        if (warningsProperty != null && (warningsProperty.equalsIgnoreCase("off") || warningsProperty.equalsIgnoreCase("false"))) {
            warnings = false;
        }
        if (emacsMode) {
            argList.addElement("+E");
        }
        if (!warnings) {
            argList.addElement("-nowarn");
        }
        this.project.log("Compilation args: " + argList.toString(), 3);
        String[] args = new String[argList.size() + this.compileList.size()];
        int counter = 0;
        int i = 0;
        while (i < argList.size()) {
            args[i] = (String)argList.elementAt(i);
            ++counter;
            ++i;
        }
        StringBuffer niceSourceList = new StringBuffer("Files to be compiled:\r\n");
        Enumeration enumeration = this.compileList.elements();
        while (enumeration.hasMoreElements()) {
            args[counter] = (String)enumeration.nextElement();
            niceSourceList.append("    " + args[counter] + "\r\n");
            ++counter;
        }
        this.project.log(niceSourceList.toString(), 3);
        JikesOutputParser jop = new JikesOutputParser(this.project, emacsMode);
        Jikes compiler = new Jikes(jop, "jikes");
        compiler.compile(args);
        if (jop.getErrorFlag()) {
            String msg = "Compile failed, messages should have been provided.";
            throw new BuildException(msg);
        }
    }

    private void doModernCompile() throws BuildException {
        this.project.log("Performing a Modern Compile");
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!");
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        this.scanDir(this.srcDir, this.destDir, files);
        String compiler = this.project.getProperty("build.compiler");
        if (compiler == null) {
            compiler = Project.getJavaVersion().startsWith("1.3") ? "modern" : "classic";
        }
        if (this.compileList.size() > 0) {
            this.project.log("Compiling " + this.compileList.size() + " source files to " + this.destDir);
            if (compiler.equalsIgnoreCase("classic")) {
                this.doClassicCompile();
            } else if (compiler.equalsIgnoreCase("modern")) {
                this.doModernCompile();
            } else if (compiler.equalsIgnoreCase("jikes")) {
                this.doJikesCompile();
            } else {
                String msg = "Don't know how to use compiler " + compiler;
                throw new BuildException(msg);
            }
        }
        if (this.filecopyList.size() > 0) {
            this.project.log("Copying " + this.filecopyList.size() + " support files to " + this.destDir.getAbsolutePath());
            Enumeration enumeration = this.filecopyList.keys();
            while (enumeration.hasMoreElements()) {
                String fromFile = (String)enumeration.nextElement();
                String toFile = (String)this.filecopyList.get(fromFile);
                try {
                    this.project.copyFile(fromFile, toFile, this.filtering);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg);
                }
            }
        }
    }

    private String getCompileClasspath() {
        StringBuffer classpath = new StringBuffer();
        classpath.append(this.destDir.getAbsolutePath());
        if (this.compileClasspath != null) {
            this.addExistingToClasspath(classpath, this.compileClasspath);
        }
        this.addExistingToClasspath(classpath, System.getProperty("java.class.path"));
        return classpath.toString();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        this.compileList.removeAllElements();
        this.filecopyList.clear();
        long now = new Date().getTime();
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            if (files[i].endsWith(".java")) {
                File classFile = new File(destDir, String.valueOf(files[i].substring(0, files[i].indexOf(".java"))) + ".class");
                if (srcFile.lastModified() > now) {
                    this.project.log("Warning: file modified in the future: " + files[i], 1);
                }
                if (srcFile.lastModified() > classFile.lastModified()) {
                    this.compileList.addElement(srcFile.getAbsolutePath());
                }
            } else {
                File destFile = new File(destDir, files[i]);
                if (srcFile.lastModified() > destFile.lastModified()) {
                    this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
                }
            }
            ++i;
        }
    }

    public void setBootclasspath(String bootclasspath) {
        this.bootclasspath = this.project.translatePath(bootclasspath);
    }

    public void setClasspath(String classpath) {
        this.compileClasspath = this.project.translatePath(classpath);
    }

    public void setDebug(String debugString) {
        this.debug = Project.toBoolean(debugString);
    }

    public void setDeprecation(String deprecationString) {
        this.deprecation = Project.toBoolean(deprecationString);
    }

    public void setDestdir(String destDirName) {
        this.destDir = this.project.resolveFile(destDirName);
    }

    public void setExtdirs(String extdirs) {
        this.extdirs = this.project.translatePath(extdirs);
    }

    public void setFiltering(String filter) {
        this.filtering = Project.toBoolean(filter);
    }

    public void setOptimize(String optimizeString) {
        this.optimize = Project.toBoolean(optimizeString);
    }

    public void setSrcdir(String srcDirName) {
        this.srcDir = this.project.resolveFile(srcDirName);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    class JarFilenameFilter
    implements FilenameFilter {
        JarFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

