#!/bin/sh
#
# c5921-swr-init.sh - Sample initialization Script.  Place in /etc/init.d
#
# Copyright (c) 2013, 2016 by cisco Systems, Inc.
# All rights reserved.
#########################################################################
### BEGIN INIT INFO
# Provides:          c5921-i386
# Required-Start:    $network $remote_fs $syslog
# Required-Stop:     $network $remote_fs $syslog
# Default-Start:     3 5
# Default-Stop:      0 1 2 6
# Short-Description: Sample Startup script for c5921 Software Router
# Description: Startup script for the Cisco c5921 Software Router product.  This
#              is a sample script provided by Cisco Systems.  System Integrators
#              may customize it as suits their needs.  To install, copy it to
#              (or place a symbolic link to it in):
#                   /etc/init.d
#              and from the above directory issue:
#                  insserv c5921-swr-init.sh (OpenSUSE, Ubuntu)
#              or:
#                  chkconfig --add c5921-swr-init.sh (CentOS)
#                  chkconfig c5921-swr-init.sh on 
#              Then edit the below defines to match the location and names of
#              the executables and interface mappings.
### END INIT INFO

########################################################################
# Place all executables and the SWROPTIONS file in $homedir.  Also, change
# the below defines to match locations and names where the executable 
# files are installed for c5921 Software Router product.
########################################################################
homedir="/opt/cisco/c5921"
swr="./swr_reload"
image="c5921i86-universalk9-ms.SPA"
shr_lib="libdyncs.so"
swroptions="$homedir/SWROPTIONS"
session_id="100"

if [ -f /lib/init/vars.sh ] ; then
  . /lib/init/vars.sh
  . /lib/lsb/init-functions
  log_daemon_msg="log_daemon_msg"
else
  log_daemon_msg="echo"
fi

cd $homedir

# Test for required files, and exit if not found.
if ! test -r $swroptions ; then
  $log_daemon_msg "Missing required file: $swroptions"
  exit 6
fi

if ! test -x $swr ; then
   $log_daemon_msg "Missing required file: $swr"
   exit 5
fi

if ! test -x $shr_lib ; then
   $log_daemon_msg "Missing required file: $shr_lib"
  exit 6
fi

########################################################################
# do_start()
#
# Routine to start the Software Router
########################################################################
do_start () {
  cd $homedir
  export LD_LIBRARY_PATH=$homedir
  $swr -L $session_id -o $swroptions & 
  $log_daemon_msg "starting $swr...\n"

}

########################################################################
# do_stop()
#
# Routine to stop the Software router upon shutdown/restart.
########################################################################
do_stop () {
   $log_daemon_msg "stopping  $swr...\n"
   cd $homedir  
   $swr -stop -o $swroptions 
}

case "$1" in
    start)
        do_start
        ;;
    stop)
        do_stop
        ;;
   
      status)
        $log_daemon_msg "Status not implemented"
        ;; 
    *)
        $log_daemon_msg "Usage: $0 {start|stop|status}"
        exit 1
        ;;
esac

exit 0
