/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.jabber.guest.api;

import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.SystemClock;
import android.view.TextureView;
import com.cisco.jabber.jcf.JGRenderSink;
import com.cisco.jabber.jcf.JGRenderType;
import com.cisco.jabber.jcf.JGVideoLayout;

public class RenderSink
implements JGRenderSink,
TextureView.SurfaceTextureListener {
    private static final String TAG = "RenderSink";
    private final long DROPPED_FRAMES_THRESHOLD = 2000L;
    private RenderSinkListener mRenderSinkListener;
    private Handler mHandler;
    private TextureView mTextureView;
    private int[] mFrameBuffer = null;
    private long mLastFrameTime = 0L;
    private FrameState mFrameState = FrameState.beforeFirst;
    private int mRoiHeight = 0;
    private int mRoiWidth = 0;
    private Runnable mCheckFrameState = new Runnable(){

        public void run() {
            boolean droppedThresholdPassed;
            long lastFrameMillisAgo = SystemClock.uptimeMillis() - RenderSink.this.mLastFrameTime;
            boolean bl = droppedThresholdPassed = lastFrameMillisAgo >= 2000L;
            if (RenderSink.this.mFrameState == FrameState.beforeFirst) {
                RenderSink.this.mFrameState = FrameState.receiving;
                RenderSink.this.mRenderSinkListener.onFirstFrame();
            } else if (RenderSink.this.mFrameState == FrameState.dropping) {
                RenderSink.this.mFrameState = FrameState.receiving;
                RenderSink.this.mRenderSinkListener.onFramesResumed();
            } else if (RenderSink.this.mFrameState == FrameState.receiving && droppedThresholdPassed) {
                RenderSink.this.mFrameState = FrameState.dropping;
                RenderSink.this.mRenderSinkListener.onFramesDropped();
            }
            if (RenderSink.this.mFrameState == FrameState.receiving) {
                RenderSink.this.mHandler.postDelayed((Runnable)this, 2000L - lastFrameMillisAgo);
            }
        }
    };
    private boolean mSurfaceTextureAvailable;

    public static native void setenv(String var0);

    public static native void libyuvI420ToARGB(int var0, int var1, int var2, int var3, int var4, int var5, int[] var6, int var7, int var8, int var9);

    private static void I420ToARGB(int buffer, int[] argbBuffer, int width, int height, int top, int left, int bottom, int right) {
        int roi_width = right - left + 1;
        int roi_height = bottom - top + 1;
        int length = width * height;
        int y_stride = width;
        int cr_stride = width / 2;
        int argb_stride = roi_width * 4;
        int y_offset = buffer + top * y_stride + left;
        int u_offset = buffer + length + top / 2 * cr_stride + left / 2;
        int v_offset = u_offset + length / 4;
        RenderSink.libyuvI420ToARGB(y_offset, y_stride, u_offset, cr_stride, v_offset, cr_stride, argbBuffer, argb_stride, roi_width, roi_height);
    }

    private static void LangleyToARGB(int buffer, int[] argbBuffer, int width, int height, int top, int left, int bottom, int right) {
        int roi_width = right - left + 1;
        int roi_height = bottom - top + 1;
        int y_stride = width + 64 + 127 & 0xFFFFFF80;
        int lh = height + 48 + 15 & 0xFFFFFFF0;
        int cr_stride = y_stride;
        int argb_stride = roi_width * 4;
        int y_offset = buffer + top * y_stride + left;
        int u_offset = buffer + (lh + top / 2) * y_stride - 16 + (left >> 1);
        int v_offset = u_offset + y_stride / 2;
        RenderSink.libyuvI420ToARGB(y_offset, y_stride, u_offset, cr_stride, v_offset, cr_stride, argbBuffer, argb_stride, roi_width, roi_height);
    }

    public void setRenderSinkListener(Handler handler, RenderSinkListener listener) {
        this.mHandler = handler;
        this.mRenderSinkListener = listener;
        this.mFrameState = FrameState.beforeFirst;
        this.mRoiHeight = 0;
        this.mRoiWidth = 0;
    }

    public synchronized void render(JGRenderType renderType, JGVideoLayout layout, int width, int height, int top, int left, int bottom, int right, int buffer, int bufferLength) {
        int roiWidth = right - left + 1;
        int roiHeight = bottom - top + 1;
        this.mLastFrameTime = SystemClock.uptimeMillis();
        if (this.mHandler != null && this.mRenderSinkListener != null) {
            if (this.mFrameState == FrameState.beforeFirst || this.mFrameState == FrameState.dropping) {
                this.mHandler.removeCallbacks(this.mCheckFrameState);
                this.mHandler.post(this.mCheckFrameState);
            }
            if (roiWidth != this.mRoiWidth || roiHeight != this.mRoiHeight) {
                this.mRoiWidth = roiWidth;
                this.mRoiHeight = roiHeight;
                this.mHandler.post((Runnable)new PostOnFrameSizeChanged(roiWidth, roiHeight));
            }
        }
        if (this.mTextureView == null || !this.mSurfaceTextureAvailable) {
            return;
        }
        int length = roiWidth * roiHeight;
        if (this.mFrameBuffer == null || this.mFrameBuffer.length != length) {
            this.mFrameBuffer = new int[length];
        }
        if ((float)bufferLength == (float)(width * height) * 1.5f) {
            RenderSink.I420ToARGB(buffer, this.mFrameBuffer, width, height, top, left, bottom, right);
        } else {
            RenderSink.LangleyToARGB(buffer, this.mFrameBuffer, width, height, top, left, bottom, right);
        }
        Canvas canvas = this.mTextureView.lockCanvas();
        if (canvas == null) {
            return;
        }
        canvas.drawARGB(255, 0, 0, 0);
        int viewWidth = this.mTextureView.getWidth();
        int viewHeight = this.mTextureView.getHeight();
        float scale = Math.min((float)viewWidth / (float)roiWidth, (float)viewHeight / (float)roiHeight);
        int save = canvas.save();
        if (renderType == JGRenderType.Self) {
            canvas.scale(-1.0f, 1.0f, (float)(viewWidth / 2), (float)(viewHeight / 2));
            canvas.scale((float)viewWidth / (float)roiWidth, (float)viewHeight / (float)roiHeight);
        } else {
            canvas.translate((float)(viewWidth / 2) - (float)roiWidth * scale / 2.0f, (float)(viewHeight / 2) - (float)roiHeight * scale / 2.0f);
            canvas.scale(scale, scale);
        }
        canvas.drawBitmap(this.mFrameBuffer, 0, roiWidth, 0.0f, 0.0f, roiWidth, roiHeight, false, null);
        canvas.restoreToCount(save);
        this.mTextureView.unlockCanvasAndPost(canvas);
    }

    public synchronized void setTextureView(TextureView textureView) {
        this.mTextureView = textureView;
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.mSurfaceTextureAvailable = this.mTextureView.isAvailable();
    }

    public void invalidate() {
        if (this.mTextureView != null) {
            this.mTextureView.invalidate();
        }
    }

    public synchronized void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        this.mSurfaceTextureAvailable = true;
    }

    public synchronized boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        if (this.mTextureView.getSurfaceTexture() == surfaceTexture) {
            this.mSurfaceTextureAvailable = false;
        }
        return true;
    }

    public synchronized void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
    }

    public synchronized void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    class PostOnFrameSizeChanged
    implements Runnable {
        int mWidth;
        int mHeight;

        public PostOnFrameSizeChanged(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        public void run() {
            RenderSink.this.mRenderSinkListener.onFrameSizeChanged(this.mWidth, this.mHeight);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FrameState {
        beforeFirst,
        receiving,
        dropping;

    }

    public static interface RenderSinkListener {
        public void onFramesDropped();

        public void onFramesResumed();

        public void onFrameSizeChanged(int var1, int var2);

        public void onFirstFrame();
    }
}

